/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.columngroup.command;

import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.column.MCell;
import com.jaspersoft.studio.components.table.model.column.command.RefreshColumnNamesCommand;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroup;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroupCell;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import org.eclipse.gef.commands.Command;

public class MoveColumnOutsideGroupCommand
extends Command {
    private HashMap<DesignCell, Integer> oldCellSizes = new HashMap();
    private StandardTable table;
    private StandardBaseColumn movedColumn;
    private MTable tableNode;
    private RefreshColumnNamesCommand refreshNameCommand;
    private int newIndex;

    public MoveColumnOutsideGroupCommand(MColumnGroupCell parent, MCell movedElement, int newIndex) {
        this((StandardColumnGroup)parent.getValue(), movedElement, newIndex);
    }

    public MoveColumnOutsideGroupCommand(MColumnGroup parent, MCell movedElement, int newIndex) {
        this(parent.getValue(), movedElement, newIndex);
    }

    public MoveColumnOutsideGroupCommand(StandardColumnGroup parent, MCell movedElement, int newIndex) {
        super(Messages.ReorderColumnGroupCommand_reorder_column_group);
        this.movedColumn = movedElement.getValue();
        this.tableNode = movedElement.getMTable();
        this.table = this.tableNode.getStandardTable();
        if (newIndex < 0) {
            newIndex = 0;
        } else if (newIndex >= this.table.getColumns().size()) {
            newIndex = this.table.getColumns().size() - 1;
        }
        this.newIndex = newIndex;
        this.refreshNameCommand = new RefreshColumnNamesCommand(this.tableNode, true, true);
    }

    private int getHeight(BaseColumn column, int section) {
        int currentHeight = 0;
        if (section == 0 && column.getTableHeader() != null) {
            currentHeight += column.getTableHeader().getHeight().intValue();
        } else if (section == 1 && column.getTableFooter() != null) {
            currentHeight += column.getTableFooter().getHeight().intValue();
        } else if (section == 2 && column.getColumnHeader() != null) {
            currentHeight += column.getColumnHeader().getHeight().intValue();
        } else if (section == 3 && column.getColumnFooter() != null) {
            currentHeight += column.getColumnFooter().getHeight().intValue();
        } else if (section == 4 && column instanceof StandardColumn) {
            currentHeight += ((StandardColumn)column).getDetailCell().getHeight().intValue();
        }
        if (column instanceof StandardColumnGroup) {
            currentHeight += this.getHeight((BaseColumn)((StandardColumnGroup)column).getColumns().get(0), section);
        }
        return currentHeight;
    }

    private void moveColumn() {
        DesignCell movedCell;
        BaseColumn sibling = this.table.getColumns().size() > 0 ? (BaseColumn)this.table.getColumns().get(0) : null;
        this.table.addColumn(this.newIndex, (BaseColumn)this.movedColumn);
        if (this.movedColumn.getTableHeader() != null) {
            movedCell = (DesignCell)this.movedColumn.getTableHeader();
            this.oldCellSizes.put(movedCell, movedCell.getHeight());
            if (sibling != null) {
                movedCell.setHeight(Integer.valueOf(this.getHeight(sibling, 0)));
            }
        }
        if (this.movedColumn.getTableFooter() != null) {
            movedCell = (DesignCell)this.movedColumn.getTableFooter();
            this.oldCellSizes.put(movedCell, movedCell.getHeight());
            if (sibling != null) {
                movedCell.setHeight(Integer.valueOf(this.getHeight(sibling, 1)));
            }
        }
        if (this.movedColumn.getColumnHeader() != null) {
            movedCell = (DesignCell)this.movedColumn.getColumnHeader();
            this.oldCellSizes.put(movedCell, movedCell.getHeight());
            if (sibling != null) {
                movedCell.setHeight(Integer.valueOf(this.getHeight(sibling, 2)));
            }
        }
        if (this.movedColumn.getColumnFooter() != null) {
            movedCell = (DesignCell)this.movedColumn.getColumnFooter();
            this.oldCellSizes.put(movedCell, movedCell.getHeight());
            if (sibling != null) {
                movedCell.setHeight(Integer.valueOf(this.getHeight(sibling, 3)));
            }
        }
        this.tableNode.getTableManager().updateTableSpans();
        this.refreshNameCommand.execute();
    }

    private void restoreColumn() {
        this.table.removeColumn((BaseColumn)this.movedColumn);
        for (Map.Entry<DesignCell, Integer> entry : this.oldCellSizes.entrySet()) {
            entry.getKey().setHeight(entry.getValue());
        }
        this.oldCellSizes.clear();
        this.tableNode.getTableManager().updateTableSpans();
        this.refreshNameCommand.undo();
    }

    public boolean canExecute() {
        return this.table != null && this.tableNode != null;
    }

    public boolean canUndo() {
        return this.table != null && this.tableNode != null;
    }

    public void execute() {
        if (this.tableNode.hasColumnsAutoresizeProportional()) {
            this.tableNode.setPropertyValue("com.jaspersoft.studio.components.autoresize.proportional", false);
            this.moveColumn();
            this.tableNode.setPropertyValue("com.jaspersoft.studio.components.autoresize.proportional", true);
        } else {
            this.moveColumn();
        }
    }

    public void undo() {
        if (this.tableNode.hasColumnsAutoresizeProportional()) {
            this.tableNode.setPropertyValue("com.jaspersoft.studio.components.autoresize.proportional", false);
            this.restoreColumn();
            this.tableNode.setPropertyValue("com.jaspersoft.studio.components.autoresize.proportional", true);
        } else {
            this.restoreColumn();
        }
    }
}

