/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.dialog;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.components.table.model.dialog.TableStyle;
import com.jaspersoft.studio.editor.style.ApplyStyleAction;
import com.jaspersoft.studio.editor.style.TemplateStyle;
import com.jaspersoft.studio.model.style.command.CreateConditionalStyleCommand;
import com.jaspersoft.studio.model.style.command.CreateStyleCommand;
import com.jaspersoft.studio.model.style.command.DeleteConditionalStyleCommand;
import com.jaspersoft.studio.model.style.command.UpdateStyleCommand;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.GroupCell;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.components.table.TableComponent;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.ModeEnum;
import org.eclipse.gef.commands.Command;

public class ApplyTableStyleAction
extends ApplyStyleAction {
    public static final String TABLE_HEADER_PROPERTY = "com.jaspersoft.studio.table.style.table_header";
    public static final String COLUMN_HEADER_PROPERTY = "com.jaspersoft.studio.table.style.column_header";
    public static final String DETAIL_PROPERTY = "com.jaspersoft.studio.table.style.detail";
    public static final String ALT_ROW_EXP = "new Boolean($V{REPORT_COUNT}.intValue()%2==0)";
    private List<JRDesignStyle> styles = null;

    public ApplyTableStyleAction(TableStyle style, JRElement table) {
        super((TemplateStyle)style, table);
    }

    public ApplyTableStyleAction(List<JRDesignStyle> styles, JRElement table) {
        super(null, table);
        this.styles = styles;
    }

    public void applayStyle(JasperDesign design) {
        List<JRDesignStyle> styleList = this.createStyles(design);
        this.setCellStyles(styleList);
    }

    private void setCellStyles(List<JRDesignStyle> styleList) {
        StandardTable table = this.getStandardTable(this.getElement());
        JRPropertiesMap tableMap = this.getElement().getPropertiesMap();
        if (styleList.get(1) != null) {
            tableMap.setProperty(TABLE_HEADER_PROPERTY, styleList.get(1).getName());
        }
        if (styleList.get(2) != null) {
            tableMap.setProperty(COLUMN_HEADER_PROPERTY, styleList.get(2).getName());
        }
        if (styleList.get(3) != null) {
            tableMap.setProperty(DETAIL_PROPERTY, styleList.get(3).getName());
        }
        List columns = TableUtil.getAllColumns((TableComponent)table);
        for (BaseColumn col : columns) {
            this.setColumnStyles(col, styleList);
        }
        for (BaseColumn baseCol : table.getColumns()) {
            if (!(baseCol instanceof StandardColumnGroup)) continue;
            StandardColumnGroup columnGroup = (StandardColumnGroup)baseCol;
            this.setColumnStyles((BaseColumn)columnGroup, styleList);
        }
    }

    private void setColumnStyles(BaseColumn col, List<JRDesignStyle> styleList) {
        DesignCell grCell;
        DesignCell detCell;
        DesignCell colFooterCell;
        DesignCell tblFooterCell;
        DesignCell tblHeadCell;
        DesignCell colHeadCell = (DesignCell)col.getColumnHeader();
        if (colHeadCell != null) {
            colHeadCell.setStyle(null);
            colHeadCell.setStyle((JRStyle)styleList.get(2));
        }
        if ((tblHeadCell = (DesignCell)col.getTableHeader()) != null) {
            tblHeadCell.setStyle(null);
            tblHeadCell.setStyle((JRStyle)styleList.get(1));
        }
        if ((tblFooterCell = (DesignCell)col.getTableFooter()) != null) {
            tblFooterCell.setStyle(null);
            tblFooterCell.setStyle((JRStyle)styleList.get(1));
        }
        if ((colFooterCell = (DesignCell)col.getColumnFooter()) != null) {
            colFooterCell.setStyle(null);
            colFooterCell.setStyle((JRStyle)styleList.get(2));
        }
        if (col instanceof StandardColumn && (detCell = (DesignCell)((StandardColumn)col).getDetailCell()) != null) {
            detCell.setStyle(null);
            detCell.setStyle((JRStyle)styleList.get(3));
        }
        for (GroupCell cell : col.getGroupHeaders()) {
            grCell = (DesignCell)cell.getCell();
            if (grCell == null) continue;
            grCell.setStyle(null);
            grCell.setStyle((JRStyle)styleList.get(2));
        }
        for (GroupCell cell : col.getGroupFooters()) {
            grCell = (DesignCell)cell.getCell();
            if (grCell == null) continue;
            grCell.setStyle(null);
            grCell.setStyle((JRStyle)styleList.get(2));
        }
    }

    public JRDesignStyle[] getStylesFromTable(JasperDesign jd) {
        StandardTable jrTable = this.getStandardTable(this.getElement());
        return ApplyTableStyleAction.getStylesFromTable(jrTable, this.getElement().getPropertiesMap(), jd);
    }

    protected static boolean hasStyleProperties(JRPropertiesMap tableMap) {
        return tableMap.containsProperty(COLUMN_HEADER_PROPERTY) || tableMap.containsProperty(TABLE_HEADER_PROPERTY) || tableMap.containsProperty(DETAIL_PROPERTY);
    }

    public static JRDesignStyle[] getStylesFromTable(StandardTable jrTable, JRPropertiesMap tableMap, JasperDesign jd) {
        JRDesignStyle[] stylesArray = new JRDesignStyle[4];
        if (ApplyTableStyleAction.hasStyleProperties(tableMap)) {
            String tableHeaderStyle = tableMap.getProperty(TABLE_HEADER_PROPERTY);
            stylesArray[1] = (JRDesignStyle)jd.getStylesMap().get(tableHeaderStyle);
            String columnHeaderStyle = tableMap.getProperty(COLUMN_HEADER_PROPERTY);
            stylesArray[2] = (JRDesignStyle)jd.getStylesMap().get(columnHeaderStyle);
            String detailStyle = tableMap.getProperty(DETAIL_PROPERTY);
            stylesArray[3] = (JRDesignStyle)jd.getStylesMap().get(detailStyle);
        } else {
            List columns = TableUtil.getAllColumns((TableComponent)jrTable);
            if (columns.size() > 0) {
                DesignCell detCell;
                BaseColumn standardCol = (BaseColumn)columns.get(0);
                if (standardCol.getColumnFooter() != null) {
                    stylesArray[2] = (JRDesignStyle)standardCol.getColumnFooter().getStyle();
                }
                if (standardCol.getColumnHeader() != null) {
                    stylesArray[2] = (JRDesignStyle)standardCol.getColumnHeader().getStyle();
                }
                if (standardCol.getTableHeader() != null) {
                    stylesArray[1] = (JRDesignStyle)standardCol.getTableHeader().getStyle();
                }
                if (standardCol.getTableFooter() != null) {
                    stylesArray[1] = (JRDesignStyle)standardCol.getTableFooter().getStyle();
                }
                if (standardCol instanceof StandardColumn && (detCell = (DesignCell)((StandardColumn)standardCol).getDetailCell()) != null) {
                    stylesArray[3] = (JRDesignStyle)detCell.getStyle();
                }
            }
        }
        return stylesArray;
    }

    private StandardTable getStandardTable(JRElement element) {
        JRDesignComponentElement jrElement = (JRDesignComponentElement)element;
        StandardTable jrTable = (StandardTable)jrElement.getComponent();
        return jrTable;
    }

    public void updateStyle(JasperDesign design, TableStyle newStyles, boolean updatOldStyles, boolean removeOldStyles) {
        this.updateStyle(design, this.createStyles(design, false), updatOldStyles, removeOldStyles);
    }

    public void updateStyle(JasperDesign design, List<JRDesignStyle> newStyles, boolean updatOldStyles, boolean removeOldStyles) {
        if (updatOldStyles) {
            JSSCompoundCommand commands = new JSSCompoundCommand(null);
            ArrayList<JRDesignStyle> stylesToApply = new ArrayList<JRDesignStyle>(newStyles);
            JRDesignStyle[] actualStyles = this.getStylesFromTable(design);
            int i = 0;
            while (i < actualStyles.length) {
                JRDesignStyle style = actualStyles[i];
                if (style != null) {
                    JRDesignStyle updatedStyle = (JRDesignStyle)stylesToApply.get(i);
                    updatedStyle.setName(style.getName());
                    JRDesignStyle styleToUpdate = (JRDesignStyle)design.getStylesMap().get(style.getName());
                    stylesToApply.set(i, styleToUpdate);
                    if (styleToUpdate != null) {
                        commands.add((Command)new UpdateStyleCommand(updatedStyle, styleToUpdate));
                        if (i == 3) {
                            for (JRConditionalStyle oldCondStyle : styleToUpdate.getConditionalStyleList()) {
                                if (oldCondStyle.getConditionExpression() == null || !ALT_ROW_EXP.equals(oldCondStyle.getConditionExpression().getText())) continue;
                                commands.add((Command)new DeleteConditionalStyleCommand(styleToUpdate, oldCondStyle));
                                break;
                            }
                            if (!updatedStyle.getConditionalStyleList().isEmpty()) {
                                for (JRConditionalStyle newCondStyle : new ArrayList(updatedStyle.getConditionalStyleList())) {
                                    updatedStyle.removeConditionalStyle(newCondStyle);
                                    commands.add((Command)new CreateConditionalStyleCommand(styleToUpdate, newCondStyle));
                                }
                            }
                        }
                    } else {
                        stylesToApply.set(i, null);
                    }
                } else {
                    stylesToApply.set(i, null);
                }
                ++i;
            }
            commands.execute();
            this.setCellStyles(stylesToApply);
        } else {
            JSSCompoundCommand commands = new JSSCompoundCommand(null);
            ArrayList<JRDesignStyle> stylesToApply = new ArrayList<JRDesignStyle>(newStyles);
            this.styles = stylesToApply;
            Map stylesMap = design.getStylesMap();
            if (removeOldStyles) {
                JRDesignStyle[] oldStyles;
                JRDesignStyle[] jRDesignStyleArray = oldStyles = this.getStylesFromTable(design);
                int n = oldStyles.length;
                int n2 = 0;
                while (n2 < n) {
                    JRDesignStyle style = jRDesignStyleArray[n2];
                    if (style != null) {
                        design.removeStyle((JRStyle)style);
                    }
                    ++n2;
                }
            }
            for (JRDesignStyle style : stylesToApply) {
                if (style == null || stylesMap.containsKey(style.getName())) continue;
                commands.add((Command)new CreateStyleCommand(design, style));
            }
            commands.execute();
            this.setCellStyles(stylesToApply);
        }
    }

    private boolean stylePresent(Map<String, JRStyle> styleMap, String baseName) {
        return styleMap.containsKey(String.valueOf(baseName) + "_TH") || styleMap.containsKey(String.valueOf(baseName) + "_CH") || styleMap.containsKey(String.valueOf(baseName) + "_TD");
    }

    private List<JRDesignStyle> createStyles(JasperDesign jd, boolean addStylesToReport) {
        String name;
        String baseName = "Table";
        TableStyle style = (TableStyle)this.getStyle();
        JSSCompoundCommand commands = new JSSCompoundCommand(null);
        int i = 0;
        while (true) {
            name = baseName;
            if (i > 0) {
                name = String.valueOf(baseName) + " " + i;
            }
            if (!this.stylePresent(jd.getStylesMap(), name)) break;
            ++i;
        }
        baseName = name;
        ArrayList<JRDesignStyle> result = new ArrayList<JRDesignStyle>();
        result.add(null);
        JRDesignStyle tableHeaderStyle = new JRDesignStyle();
        tableHeaderStyle.setName(String.valueOf(baseName) + "_TH");
        if (style.getBorderStyle() == TableStyle.BorderStyleEnum.FULL) {
            this.setBorderColor(tableHeaderStyle, style.getBorderColor());
            this.setBorderWidth(tableHeaderStyle, 0.5f);
        } else {
            tableHeaderStyle.getLineBox().getBottomPen().setLineColor(style.getBorderColor());
            tableHeaderStyle.getLineBox().getBottomPen().setLineWidth(Float.valueOf(0.5f));
            tableHeaderStyle.getLineBox().getTopPen().setLineColor(style.getBorderColor());
            tableHeaderStyle.getLineBox().getTopPen().setLineWidth(Float.valueOf(0.5f));
        }
        tableHeaderStyle.setMode(ModeEnum.OPAQUE);
        tableHeaderStyle.setBackcolor(style.getColorValue("color_table_header"));
        commands.add((Command)new CreateStyleCommand(jd, tableHeaderStyle));
        result.add(tableHeaderStyle);
        JRDesignStyle columnHeaderStyle = new JRDesignStyle();
        columnHeaderStyle.setName(String.valueOf(baseName) + "_CH");
        if (style.getBorderStyle() == TableStyle.BorderStyleEnum.FULL) {
            this.setBorderColor(columnHeaderStyle, style.getBorderColor());
            this.setBorderWidth(columnHeaderStyle, 0.5f);
        } else {
            columnHeaderStyle.getLineBox().getBottomPen().setLineColor(style.getBorderColor());
            columnHeaderStyle.getLineBox().getBottomPen().setLineWidth(Float.valueOf(0.5f));
            columnHeaderStyle.getLineBox().getTopPen().setLineColor(style.getBorderColor());
            columnHeaderStyle.getLineBox().getTopPen().setLineWidth(Float.valueOf(0.5f));
        }
        columnHeaderStyle.setMode(ModeEnum.OPAQUE);
        columnHeaderStyle.setBackcolor(style.getColorValue("color_column_header"));
        commands.add((Command)new CreateStyleCommand(jd, columnHeaderStyle));
        result.add(columnHeaderStyle);
        JRDesignStyle cellStyle = new JRDesignStyle();
        cellStyle.setName(String.valueOf(baseName) + "_TD");
        if (style.getBorderStyle() == TableStyle.BorderStyleEnum.FULL) {
            this.setBorderColor(cellStyle, style.getBorderColor());
            this.setBorderWidth(cellStyle, 0.5f);
        } else {
            cellStyle.getLineBox().getBottomPen().setLineColor(style.getBorderColor());
            cellStyle.getLineBox().getBottomPen().setLineWidth(Float.valueOf(0.5f));
            cellStyle.getLineBox().getTopPen().setLineColor(style.getBorderColor());
            cellStyle.getLineBox().getTopPen().setLineWidth(Float.valueOf(0.5f));
        }
        cellStyle.setMode(ModeEnum.OPAQUE);
        cellStyle.setBackcolor(style.getColorValue("color_detail_standard"));
        if (style.hasAlternateColor().booleanValue()) {
            JRDesignConditionalStyle condStyle = new JRDesignConditionalStyle();
            condStyle.setConditionExpression((JRExpression)ModelUtils.createExpression((String)ALT_ROW_EXP));
            condStyle.setBackcolor(style.getColorValue("color_detail"));
            cellStyle.addConditionalStyle((JRConditionalStyle)condStyle);
        }
        commands.add((Command)new CreateStyleCommand(jd, cellStyle));
        result.add(cellStyle);
        if (addStylesToReport) {
            commands.execute();
        }
        return result;
    }

    public List<JRDesignStyle> createStyles(JasperDesign jd) {
        if (this.styles == null) {
            return this.createStyles(jd, true);
        }
        return this.styles;
    }
}

