/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.dialog;

import com.jaspersoft.studio.components.table.model.dialog.TableStyle;
import com.jaspersoft.studio.editor.gef.figures.borders.ShadowBorder;
import com.jaspersoft.studio.property.color.ColorSchemaGenerator;
import com.jaspersoft.studio.utils.AlfaRGB;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wb.swt.SWTResourceManager;

public class TableStylePreview
extends Composite {
    private TableStyle tableStyle;
    private Figure parentFigure;
    private Canvas square;
    private RectangleFigure borderPreview;
    private LightweightSystem lws;
    private List<Listener> previewPaintListener = new ArrayList<Listener>();

    public TableStylePreview(Composite parent, int style) {
        super(parent, style);
        AlfaRGB baseColor = AlfaRGB.getFullyOpaque((RGB)ColorConstants.lightBlue.getRGB());
        AlfaRGB borderColor = AlfaRGB.getFullyOpaque((RGB)ColorConstants.black.getRGB());
        this.tableStyle = new TableStyle(baseColor, ColorSchemaGenerator.SCHEMAS.DEFAULT, TableStyle.BorderStyleEnum.FULL, borderColor, false);
        this.createFigure();
    }

    public void setTableStyle(TableStyle style) {
        this.tableStyle = style;
        this.setTBounds();
    }

    private void createFigure() {
        this.setLayout((Layout)new GridLayout(1, false));
        this.lws = new LightweightSystem();
        this.square = new Canvas((Composite)this, 0x140000);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 2;
        this.square.setLayoutData((Object)gd);
        this.lws.setControl(this.square);
        this.parentFigure = new Figure();
        this.parentFigure.setLayoutManager((LayoutManager)new XYLayout());
        this.lws.setContents((IFigure)this.parentFigure);
        this.borderPreview = new RectangleFigure(){

            public void paint(Graphics graphics) {
                int y = 5;
                int x = 5;
                int w = this.getBounds().width - 10;
                int h = this.getBounds().height - 10;
                int rowHeight = h / 7;
                Color originalBackgroun = graphics.getBackgroundColor();
                Color originalForeground = graphics.getForegroundColor();
                Rectangle row_bounds = new Rectangle(x, y + rowHeight * 2, w, rowHeight);
                java.awt.Color colorDetail = TableStylePreview.this.tableStyle.getColorValue("color_detail_standard");
                graphics.setBackgroundColor(TableStylePreview.this.getSwtColor(colorDetail));
                graphics.fillRectangle(row_bounds.x, row_bounds.y, row_bounds.width, row_bounds.height);
                java.awt.Color c = null;
                row_bounds = new Rectangle(x, y + rowHeight * 3, w, rowHeight);
                graphics.setBackgroundColor(TableStylePreview.this.getSwtColor(colorDetail));
                if (TableStylePreview.this.tableStyle.hasAlternateColor().booleanValue()) {
                    c = TableStylePreview.this.tableStyle.getColorValue("color_detail");
                    graphics.setBackgroundColor(TableStylePreview.this.getSwtColor(c));
                }
                graphics.fillRectangle(row_bounds);
                row_bounds = new Rectangle(x, y + rowHeight * 4, w, rowHeight);
                graphics.setBackgroundColor(TableStylePreview.this.getSwtColor(colorDetail));
                graphics.fillRectangle(row_bounds);
                row_bounds = new Rectangle(x, y + rowHeight * 0, w, rowHeight);
                c = TableStylePreview.this.tableStyle.getColorValue("color_table_header");
                graphics.setBackgroundColor(TableStylePreview.this.getSwtColor(c));
                graphics.fillRectangle(row_bounds);
                row_bounds = new Rectangle(x, y + rowHeight * 6, w, rowHeight);
                graphics.setBackgroundColor(TableStylePreview.this.getSwtColor(c));
                graphics.fillRectangle(row_bounds);
                row_bounds = new Rectangle(x, y + rowHeight * 1, w, rowHeight);
                c = TableStylePreview.this.tableStyle.getColorValue("color_column_header");
                graphics.setBackgroundColor(TableStylePreview.this.getSwtColor(c));
                graphics.fillRectangle(row_bounds);
                row_bounds = new Rectangle(x, y + rowHeight * 5, w, rowHeight);
                graphics.setBackgroundColor(TableStylePreview.this.getSwtColor(c));
                graphics.fillRectangle(row_bounds);
                graphics.setForegroundColor(TableStylePreview.this.getSwtColor(TableStylePreview.this.tableStyle.getBorderColor()));
                int i = 0;
                while (i < 8) {
                    graphics.drawLine(x, y + rowHeight * i, x + w, y + rowHeight * i);
                    ++i;
                }
                h = rowHeight * 7;
                if (TableStylePreview.this.tableStyle.getBorderStyle() == TableStyle.BorderStyleEnum.FULL) {
                    i = 0;
                    while (i < 3) {
                        graphics.drawLine(x + i * (w / 3), y, x + i * (w / 3), y + h);
                        ++i;
                    }
                    graphics.drawLine(x + w, y, x + w, y + h - 1);
                }
                if (TableStylePreview.this.tableStyle.getBorderStyle() == TableStyle.BorderStyleEnum.ONLY_HORIZONTAL) {
                    graphics.drawLine(x, y, x, y + h);
                    graphics.drawLine(x + w, y, x + w, y + h - 1);
                }
                graphics.setBackgroundColor(originalBackgroun);
                graphics.setForegroundColor(originalForeground);
                TableStylePreview.this.firePreviewPaintListeners(graphics, x, y, w, h);
            }
        };
        this.borderPreview.setBorder((Border)new ShadowBorder());
        this.parentFigure.add((IFigure)this.borderPreview);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TableStylePreview.this.setTBounds();
            }
        });
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                TableStylePreview.this.setTBounds();
            }
        });
    }

    private Color getSwtColor(java.awt.Color awtColor) {
        return SWTResourceManager.getColor((int)awtColor.getRed(), (int)awtColor.getGreen(), (int)awtColor.getBlue());
    }

    public void setTBounds() {
        if (!this.isDisposed()) {
            Dimension psize = this.parentFigure.getSize();
            this.borderPreview.setSize(psize);
            this.borderPreview.setLocation(new Point(0, 0));
            this.parentFigure.invalidate();
            this.square.redraw();
            this.lws.getUpdateManager().performUpdate();
        }
    }

    public void addPreviewPaintListenr(Listener listener) {
        if (listener != null && !this.previewPaintListener.contains(listener)) {
            this.previewPaintListener.add(listener);
        }
    }

    protected void firePreviewPaintListeners(Graphics graphics, int x, int y, int w, int h) {
        Event e = new Event();
        e.widget = this;
        e.data = graphics;
        e.x = x;
        e.y = y;
        e.width = w;
        e.height = h;
        for (Listener listener : this.previewPaintListener) {
            listener.handleEvent(e);
        }
    }

    public void dispose() {
        super.dispose();
        this.previewPaintListener.clear();
    }
}

