/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.util;

import com.jaspersoft.studio.components.table.model.MTableColumnFooter;
import com.jaspersoft.studio.components.table.model.MTableColumnHeader;
import com.jaspersoft.studio.components.table.model.MTableDetail;
import com.jaspersoft.studio.components.table.model.MTableFooter;
import com.jaspersoft.studio.components.table.model.MTableGroupFooter;
import com.jaspersoft.studio.components.table.model.MTableGroupHeader;
import com.jaspersoft.studio.components.table.model.MTableHeader;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.components.table.util.TableUtil;

public class TableColumnSize {
    public static int getType(Class<?> c) {
        if (c.isAssignableFrom(MTableHeader.class)) {
            return 0;
        }
        if (c.isAssignableFrom(MTableFooter.class)) {
            return 1;
        }
        if (c.isAssignableFrom(MTableColumnHeader.class)) {
            return 2;
        }
        if (c.isAssignableFrom(MTableColumnFooter.class)) {
            return 3;
        }
        if (c.isAssignableFrom(MTableDetail.class)) {
            return 4;
        }
        if (c.isAssignableFrom(MTableGroupHeader.class)) {
            return 5;
        }
        if (c.isAssignableFrom(MTableGroupFooter.class)) {
            return 6;
        }
        return -1;
    }

    public static int getInitGroupHeight(StandardTable jrTable, StandardColumnGroup jrGroup, int type, String grName) {
        int maxh = 0;
        if (jrGroup.getColumns().isEmpty()) {
            maxh = TableColumnSize.getInitTableHeight(jrTable, type, grName) - TableColumnSize.getGroupHeigh2Top(jrTable.getColumns(), jrGroup, type, grName);
        } else {
            for (BaseColumn bc : jrGroup.getColumns()) {
                maxh = Math.max(maxh, TableColumnSize.getColumnHeight(bc, type, grName));
            }
        }
        return maxh <= 0 ? 40 : maxh;
    }

    private static int getGroupHeigh2Top(List<BaseColumn> cols, StandardColumnGroup scg, int type, String grName) {
        for (BaseColumn bc : cols) {
            int hg;
            if (bc == scg) {
                return Math.max(0, TableColumnSize.getCellHeight(bc, type, grName));
            }
            if (!(bc instanceof StandardColumnGroup) || (hg = TableColumnSize.getGroupHeigh2Top(((StandardColumnGroup)bc).getColumns(), scg, type, grName)) < 0) continue;
            return Math.max(0, TableColumnSize.getCellHeight(bc, type, grName)) + hg;
        }
        return -1;
    }

    public static int setGroupWidth2Top(List<BaseColumn> cols, StandardColumnGroup scg, int delta) {
        for (BaseColumn bc : cols) {
            int hg;
            if (bc == scg) {
                ((StandardBaseColumn)bc).setWidth(Integer.valueOf(bc.getWidth() + delta));
                return 0;
            }
            if (!(bc instanceof StandardColumnGroup) || (hg = TableColumnSize.setGroupWidth2Top(((StandardColumnGroup)bc).getColumns(), scg, delta)) != 0) continue;
            ((StandardBaseColumn)bc).setWidth(Integer.valueOf(bc.getWidth() + delta));
            return 0;
        }
        return -1;
    }

    public static int getInitTableHeight(StandardTable jrTable, int type, String grName) {
        int maxh = -1;
        for (BaseColumn bc : jrTable.getColumns()) {
            maxh = Math.max(maxh, TableColumnSize.getColumnHeight(bc, type, grName));
        }
        return maxh < 0 ? 30 : maxh;
    }

    public static int getColumnHeight(BaseColumn bc, int type, String grName) {
        int height = -1;
        if (!(bc instanceof StandardColumnGroup) || type != 4) {
            height = TableColumnSize.getCellHeight(bc, type, grName);
        }
        if (bc instanceof StandardColumnGroup) {
            int maxh = -1;
            for (BaseColumn bcg : ((StandardColumnGroup)bc).getColumns()) {
                int h = TableColumnSize.getColumnHeight(bcg, type, grName);
                if (h < 0) continue;
                maxh = Math.max(maxh, h);
            }
            if (maxh >= 0) {
                if (height < 0) {
                    height = 0;
                }
                height += maxh;
            }
        }
        return height;
    }

    private static int getCellHeight(BaseColumn bc, int type, String grName) {
        Cell cell = null;
        switch (type) {
            case 0: {
                cell = bc.getTableHeader();
                break;
            }
            case 1: {
                cell = bc.getTableFooter();
                break;
            }
            case 2: {
                cell = bc.getColumnHeader();
                break;
            }
            case 3: {
                cell = bc.getColumnFooter();
                break;
            }
            case 4: {
                if (!(bc instanceof StandardColumn)) break;
                cell = ((StandardColumn)bc).getDetailCell();
                break;
            }
            case 5: {
                cell = bc.getGroupHeader(grName);
                break;
            }
            case 6: {
                cell = bc.getGroupFooter(grName);
            }
        }
        if (cell != null) {
            return cell.getHeight();
        }
        return -1;
    }

    public static int setCellHeightDelta(BaseColumn bc, int type, String grName, int delta) {
        int dif = 0;
        Cell cell = TableUtil.getCell((BaseColumn)bc, (int)type, (String)grName);
        if (cell != null) {
            DesignCell designCell = (DesignCell)cell;
            int height = cell.getHeight() + delta;
            if (height < 0) {
                dif = height;
                height = 0;
            }
            designCell.setHeight(Integer.valueOf(height));
        }
        return dif;
    }
}

