/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.widgets.framework.ui;

import com.jaspersoft.studio.components.widgets.framework.ui.dialogs.ShapeDefinitionWizard;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.manager.WidgetFactory;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.AbstractExpressionPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import net.sf.jasperreports.customizers.shape.Point;
import net.sf.jasperreports.customizers.shape.ShapePoints;
import net.sf.jasperreports.customizers.shape.ShapeTypeEnum;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ShapePointsDescription
extends AbstractExpressionPropertyDescription<String> {
    public static final String SHAPE_TYPE_PROPERTY = "shapeType";
    public static final String SHAPE_POINTS_PROPERTY = "shapePoints";

    public ShapePointsDescription() {
    }

    public ShapePointsDescription(String name, String label, String description, boolean mandatory, String defaultValue) {
        super(name, label, description, mandatory, (Object)defaultValue);
    }

    public Control createControl(final IWItemProperty wiProp, Composite parent) {
        DoubleControlComposite cmp = new DoubleControlComposite(parent, 0);
        cmp.setLayoutData((Object)new GridData(768));
        this.lazyCreateExpressionControl(wiProp, cmp);
        cmp.getSecondContainer().setLayout((Layout)WidgetFactory.getNoPadLayout((int)2));
        final Text simpleControl = new Text(cmp.getSecondContainer(), 2048);
        cmp.getSecondContainer().setData((Object)simpleControl);
        cmp.setSimpleControlToHighlight((Control)simpleControl);
        GridData textData = new GridData(768);
        textData.verticalAlignment = 0x1000000;
        textData.grabExcessVerticalSpace = true;
        simpleControl.setLayoutData((Object)textData);
        simpleControl.setEnabled(false);
        simpleControl.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (UIUtil.isMacAndEclipse4()) {
                    if (((Text)e.getSource()).isDisposed()) {
                        return;
                    }
                    wiProp.updateWidget();
                }
            }
        });
        Button openWizardButton = new Button(cmp.getSecondContainer(), 8);
        openWizardButton.setText("...");
        openWizardButton.setEnabled(!this.isReadOnly());
        GridData buttonData = new GridData();
        buttonData.verticalAlignment = 0x1000000;
        buttonData.grabExcessVerticalSpace = true;
        openWizardButton.setLayoutData((Object)buttonData);
        openWizardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String currentValue = wiProp.getStaticValue();
                ShapePoints currentPoints = ShapePoints.decode((String)currentValue);
                String shapeType = wiProp.getPropertyEditor().getPropertyValue(ShapePointsDescription.SHAPE_TYPE_PROPERTY);
                ShapeTypeEnum shapeTypeEnum = ShapeTypeEnum.POLYLINE;
                if (shapeType != null) {
                    shapeTypeEnum = (ShapeTypeEnum)NamedEnumPropertyDescriptor.getEnumValue((Enum)ShapeTypeEnum.ELLIPSE, (NullEnum)NullEnum.NOTNULL, (Object)shapeType);
                }
                ShapeDefinitionWizard wizard = new ShapeDefinitionWizard(shapeTypeEnum, currentPoints);
                WizardDialog dialog = new WizardDialog(simpleControl.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    wiProp.setValue(wizard.getEncodedPoints(), null);
                }
            }
        });
        this.setupContextMenu((Control)simpleControl, wiProp);
        cmp.switchToFirstContainer();
        return cmp;
    }

    public void update(Control c, IWItemProperty wip) {
        DoubleControlComposite cmp = (DoubleControlComposite)wip.getControl();
        if (wip.isExpressionMode()) {
            this.lazyCreateExpressionControl(wip, cmp);
            Text expressionControl = (Text)cmp.getFirstContainer().getData();
            super.update((Control)expressionControl, wip);
            cmp.switchToFirstContainer();
        } else {
            ShapePoints points;
            boolean isFallback = false;
            Text simpleControl = (Text)cmp.getSecondContainer().getData();
            String v = wip.getStaticValue();
            if (v == null && wip.getFallbackValue() != null) {
                v = wip.getFallbackValue().toString();
                isFallback = true;
            }
            if ((points = ShapePoints.decode((String)v)) != null && points.getPoints() != null && !points.getPoints().isEmpty()) {
                simpleControl.setText(this.getPointsAsString(points));
            } else {
                simpleControl.setText("No points defined");
            }
            this.changeFallbackForeground(isFallback, (Control)simpleControl);
            cmp.switchToSecondContainer();
        }
    }

    protected String getPointsAsString(ShapePoints points) {
        StringBuilder result = new StringBuilder();
        for (Point point : points.getPoints()) {
            result.append("(");
            result.append(point.getX());
            result.append(",");
            result.append(point.getY());
            result.append("),");
        }
        return result.substring(0, result.length() - 1);
    }

    public ShapePointsDescription clone() {
        ShapePointsDescription result = new ShapePointsDescription();
        result.defaultValue = (String)this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.readOnly = this.readOnly;
        result.fallbackValue = (String)this.fallbackValue;
        return result;
    }

    public ItemPropertyDescription<?> getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        ShapePointsDescription result = new ShapePointsDescription(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), cpd.getDefaultValue());
        result.setReadOnly(cpd.isReadOnly());
        result.setFallbackValue(cpd.getFallbackValue());
        return result;
    }
}

