/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.action;

import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.action.AMultiSelectionAction;
import com.jaspersoft.studio.data.sql.messages.Messages;
import com.jaspersoft.studio.data.sql.ui.gef.command.DeleteObjectCommand;
import com.jaspersoft.studio.model.ANode;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;

public class DeleteAction<T extends ANode>
extends AMultiSelectionAction {
    protected String name;
    protected Class<T> type;
    protected SQLQueryDesigner designer;

    public DeleteAction(SQLQueryDesigner designer, TreeViewer treeViewer, String name, Class<T> type) {
        super(String.valueOf(Messages.DeleteAction_0) + name, treeViewer);
        this.name = name;
        this.type = type;
        this.designer = designer;
    }

    @Override
    protected boolean isGoodNode(ANode element) {
        return this.type.isAssignableFrom(element.getClass());
    }

    public void run() {
        ArrayList<ANode> lst = new ArrayList<ANode>();
        Object[] objectArray = this.selection;
        int n = this.selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (this.isObjectToDelete(obj)) {
                lst.add((ANode)obj);
            }
            ++n2;
        }
        if (DeleteAction.showConfirmation(this.designer, this.name, lst)) {
            this.doDelete(lst);
        }
    }

    public static boolean showConfirmation(SQLQueryDesigner designer, String name, List<?> lst) {
        boolean showConf = designer.getjConfig().getPropertyBoolean("com.jaspersoft.studio.data.sql.prefs.delSHOWCONFIRMATION", false);
        return !showConf || UIUtils.showDeleteConfirmation((Shell)designer.getControl().getShell(), (String)(String.valueOf(Messages.DeleteAction_2) + name.toLowerCase() + (lst.size() == 1 ? "?" : Messages.DeleteAction_3)));
    }

    protected boolean isObjectToDelete(Object obj) {
        return this.type.isAssignableFrom(obj.getClass());
    }

    protected void doDelete(List<T> lst) {
        ANode mfrom = null;
        int indx = 0;
        ArrayList<ANode> toRemove = new ArrayList<ANode>();
        for (ANode ftbl : lst) {
            if (mfrom == null) {
                mfrom = ftbl.getParent();
            }
            indx = mfrom.getChildren().indexOf(ftbl);
            toRemove.add(ftbl);
            List<ANode> delMore = this.doDeleteMore(mfrom, this.type.isAssignableFrom(ftbl.getClass()) ? ftbl : null);
            if (Misc.isNullOrEmpty(delMore)) continue;
            toRemove.addAll(delMore);
        }
        DeleteObjectCommand c = new DeleteObjectCommand(toRemove);
        this.designer.getDiagram().getViewer().getEditDomain().getCommandStack().execute((Command)c);
        ANode toSelect = mfrom;
        if (indx - 1 > 0 && !mfrom.getChildren().isEmpty()) {
            toSelect = (ANode)mfrom.getChildren().get(Math.min(mfrom.getChildren().size() - 1, indx));
        }
        if (toSelect != null) {
            this.selectInTree(toSelect);
        }
        this.designer.refreshQueryText();
    }

    protected List<ANode> doDeleteMore(ANode parent, T todel) {
        return null;
    }
}

