/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.action.expression;

import com.jaspersoft.studio.data.designer.AQueryDesigner;
import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.action.AAction;
import com.jaspersoft.studio.data.sql.action.table.CreateTable;
import com.jaspersoft.studio.data.sql.dialogs.EditExpressionDialog;
import com.jaspersoft.studio.data.sql.messages.Messages;
import com.jaspersoft.studio.data.sql.model.enums.Operator;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.query.MHaving;
import com.jaspersoft.studio.data.sql.model.query.MWhere;
import com.jaspersoft.studio.data.sql.model.query.expression.AMExpression;
import com.jaspersoft.studio.data.sql.model.query.expression.MExpression;
import com.jaspersoft.studio.data.sql.model.query.expression.MExpressionGroup;
import com.jaspersoft.studio.data.sql.model.query.from.MFrom;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTableJoin;
import com.jaspersoft.studio.data.sql.model.query.operand.FieldOperand;
import com.jaspersoft.studio.data.sql.model.query.operand.ParameterPOperand;
import com.jaspersoft.studio.data.sql.model.query.select.MSelectColumn;
import com.jaspersoft.studio.data.sql.widgets.Factory;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import org.eclipse.jface.viewers.TreeViewer;

public class CreateExpression
extends AAction {
    private CreateTable ct;
    private SQLQueryDesigner designer;

    public CreateExpression(SQLQueryDesigner designer, TreeViewer treeViewer) {
        super(Messages.CreateExpression_0, treeViewer);
        this.designer = designer;
    }

    @Override
    public boolean calculateEnabled(Object[] selection) {
        super.calculateEnabled(selection);
        return selection != null && selection.length == 1 && CreateExpression.isInSelect(selection[0]);
    }

    public static boolean isInSelect(Object element) {
        return element instanceof MWhere || element instanceof MHaving || element instanceof AMExpression || element instanceof MFromTableJoin && ((MFromTableJoin)element).getJoinKey().equals("ON") || element instanceof MExpressionGroup;
    }

    public void run() {
        Object sel = this.selection[0];
        AMExpression mexpr = null;
        if (sel instanceof AMExpression) {
            mexpr = this.run(null, (AMExpression)sel);
        } else if (CreateExpression.isInSelect(sel)) {
            mexpr = this.run(null, (ANode)sel, -1);
        }
        mexpr.getOperands().add(Factory.getDefaultOperand(mexpr));
        mexpr.getOperands().add(Factory.getDefaultOperand(mexpr));
        this.showDialog((MExpression)mexpr);
    }

    public void run(List<JRDesignParameter> prms) {
        Object sel = this.selection[0];
        MExpression mexpr = null;
        Util.getFromTables((ANode)sel);
        for (JRParameter jRParameter : prms) {
            if (sel instanceof AMExpression) {
                mexpr = this.run(jRParameter, (AMExpression)sel);
            } else if (CreateExpression.isInSelect(sel)) {
                mexpr = this.run(jRParameter, (ANode)sel, -1);
            }
            sel = mexpr;
            mexpr.getOperands().add(Factory.getDefaultOperand(mexpr));
            ParameterPOperand pop = new ParameterPOperand(mexpr);
            pop.setJrParameter((JRDesignParameter)jRParameter);
            mexpr.getOperands().add(pop);
        }
        this.showDialog(mexpr);
    }

    public void run(Collection<MSQLColumn> nodes) {
        Object sel = this.selection[0];
        MExpression mexpr = null;
        List<MFromTable> tbls = Util.getFromTables((ANode)sel);
        for (MSQLColumn t : nodes) {
            MSqlTable tbl = (MSqlTable)t.getParent();
            MFromTable mftable = null;
            for (MFromTable ft : tbls) {
                if (!((MSqlTable)ft.getValue()).equals(tbl)) continue;
                mftable = ft;
                break;
            }
            if (mftable == null) {
                if (this.ct == null) {
                    this.ct = new CreateTable(this.designer, this.treeViewer);
                }
                ANode r = Util.getQueryRoot((ANode)sel);
                for (INode n : r.getChildren()) {
                    if (!(n instanceof MFrom)) continue;
                    mftable = this.ct.run(tbl, (MFrom)n, -1);
                    break;
                }
            }
            if (sel instanceof AMExpression) {
                mexpr = this.run(t, (AMExpression)sel);
            } else if (CreateExpression.isInSelect(sel)) {
                mexpr = this.run(t, (ANode)sel, -1);
            }
            sel = mexpr;
            mexpr.getOperands().add(new FieldOperand(t, mftable, mexpr));
            mexpr.getOperands().add(Factory.getDefaultOperand(mexpr));
        }
        this.showDialog(mexpr);
    }

    public void run(ANode node, MSelectColumn selcol) {
        MExpression mexpr = this.run(selcol.getValue(), node, -1);
        mexpr.getOperands().add(new FieldOperand((MSQLColumn)selcol.getValue(), selcol.getMFromTable(), mexpr));
        mexpr.getOperands().add(Factory.getDefaultOperand(mexpr));
        this.showDialog(mexpr);
    }

    protected void showDialog(MExpression mexpr) {
        EditExpressionDialog dialog = new EditExpressionDialog(this.treeViewer.getControl().getShell(), (AQueryDesigner)this.designer);
        dialog.setValue(mexpr);
        if (dialog.open() == 0) {
            mexpr.setOperator(Operator.getOperator(dialog.getOperator()));
            mexpr.setPrevCond(dialog.getPrevcond());
            mexpr.setOperands(dialog.getOperands());
            this.selectInTree(mexpr);
        } else {
            ANode p = mexpr.getParent();
            p.removeChild((ANode)mexpr);
            this.selectInTree(p);
        }
    }

    protected MExpression run(Object node, AMExpression<?> mtable) {
        ANode mfrom = mtable.getParent();
        return this.run(node, mfrom, mfrom.getChildren().indexOf(mtable) + 1);
    }

    public MExpression run(Object node, ANode select, int index) {
        return new MExpression(select, node, index);
    }
}

