/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.dialogs;

import com.jaspersoft.studio.data.sql.messages.Messages;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlSchema;
import com.jaspersoft.studio.data.sql.model.metadata.MTables;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.outline.ReportTreeContetProvider;
import com.jaspersoft.studio.outline.ReportTreeLabelProvider;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ColumnsDialog
extends ATitledDialog {
    private TreeViewer treeViewer;
    private MRoot root;
    private List<MSQLColumn> cols = new ArrayList<MSQLColumn>();

    public ColumnsDialog(Shell parentShell) {
        super(parentShell);
        this.setTitle(Messages.ColumnsDialog_0);
        this.setDefaultSize(650, 780);
    }

    public void setRoot(MRoot root) {
        this.root = root;
    }

    public boolean close() {
        TreeSelection ts = (TreeSelection)this.treeViewer.getSelection();
        for (Object obj : ts.toList()) {
            if (!(obj instanceof MSQLColumn)) continue;
            this.cols.add((MSQLColumn)obj);
        }
        return super.close();
    }

    public List<MSQLColumn> getColumns() {
        return this.cols;
    }

    protected Control createDialogArea(Composite parent) {
        Composite cmp = (Composite)super.createDialogArea(parent);
        this.treeViewer = new TreeViewer(cmp, 2050);
        this.treeViewer.setContentProvider((IContentProvider)new ReportTreeContetProvider(){

            public Object[] getChildren(Object parentElement) {
                MSqlSchema p;
                if (parentElement instanceof MSqlSchema && (p = (MSqlSchema)parentElement).getChildren() != null && p.getChildren().size() > 0) {
                    ArrayList<INode> n = new ArrayList<INode>();
                    for (INode node : p.getChildren()) {
                        if (!(node instanceof MTables)) continue;
                        n.add(node);
                    }
                    return n.toArray();
                }
                return super.getChildren(parentElement);
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ReportTreeLabelProvider());
        GridData gd = new GridData(1808);
        gd.minimumHeight = 400;
        gd.minimumWidth = 400;
        this.treeViewer.getControl().setLayoutData((Object)gd);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection ts = (TreeSelection)ColumnsDialog.this.treeViewer.getSelection();
                Object el = ts.getFirstElement();
                if (el instanceof MSQLColumn) {
                    ColumnsDialog.this.okPressed();
                } else if (ColumnsDialog.this.treeViewer.getExpandedState(el)) {
                    ColumnsDialog.this.treeViewer.collapseToLevel(el, 1);
                } else {
                    ColumnsDialog.this.treeViewer.expandToLevel(el, 1);
                }
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.treeViewer.setInput((Object)this.root);
        return cmp;
    }
}

