/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.model.enums;

public enum Operator {
    LESS("<", 2),
    GREATER(">", 2),
    EQUALS("=", 2),
    LESSOREQUALS("<=", 2),
    GREATEROREQUALS(">=", 2),
    NOTEQUALS("<>", 2),
    LIKE("LIKE", 2),
    BETWEEN("BETWEEN", 3),
    NOTBETWEEN("NOT BETWEEN", 3),
    IN("IN", Integer.MAX_VALUE),
    NOTIN("NOT IN", Integer.MAX_VALUE),
    ISNULL("IS NULL", 1),
    ISNOTNULL("IS NOT NULL", 1);

    private final String sqlname;
    private final int nrOperands;
    public static final String[] operators;

    static {
        operators = Operator.getOperators();
    }

    private Operator(String sqlname, int nrOperands) {
        this.sqlname = sqlname;
        this.nrOperands = nrOperands;
    }

    public static Operator getOperator(String sqlname) {
        int i = 0;
        while (i < Operator.values().length) {
            Operator r = Operator.values()[i];
            if (r.getSqlname().equalsIgnoreCase(sqlname)) {
                return r;
            }
            ++i;
        }
        return EQUALS;
    }

    public String getSqlname() {
        return this.sqlname;
    }

    public int getNrOperands() {
        return this.nrOperands;
    }

    public String getFormat(Operator op) {
        if (op.getNrOperands() == 1) {
            return "{0} " + op.sqlname + " ";
        }
        if (op.getNrOperands() == 2) {
            return "{0} " + op.sqlname + " {1}";
        }
        if (op == BETWEEN) {
            return "{0} BETWEEN {1} AND {2}";
        }
        if (op == NOTBETWEEN) {
            return "{0} NOT BETWEEN {1} AND {2}";
        }
        if (op.getNrOperands() > 3) {
            return "{0} " + op.getSqlname() + " ({1})";
        }
        return "";
    }

    public static String[] getOperators() {
        Operator[] op = Operator.values();
        String[] ops = new String[op.length];
        int i = 0;
        while (i < op.length) {
            ops[i] = op[i].getSqlname();
            ++i;
        }
        return ops;
    }
}

