/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.model.query.from;

import com.jaspersoft.studio.data.sql.model.query.expression.MExpression;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTableJoin;
import com.jaspersoft.studio.data.sql.model.query.operand.AOperand;
import com.jaspersoft.studio.data.sql.model.query.operand.FieldOperand;

public class TableJoinDetail {
    private MFromTable srcTbl;
    private MFromTable destTbl;
    private MExpression expr;

    public TableJoinDetail(MFromTable srcTbl, MFromTable destTbl, MExpression expr) {
        this.srcTbl = srcTbl;
        this.destTbl = destTbl;
        this.expr = expr;
    }

    public MExpression getExpr() {
        return this.expr;
    }

    public MFromTable getSrcTable() {
        return this.srcTbl;
    }

    public MFromTable getDestTable() {
        return this.destTbl;
    }

    public FieldOperand getSrcColumn() {
        if (this.expr != null && !this.expr.getOperands().isEmpty()) {
            for (AOperand op : this.expr.getOperands()) {
                if (!(op instanceof FieldOperand) || ((FieldOperand)op).getFromTable() != this.srcTbl) continue;
                return (FieldOperand)op;
            }
        }
        return null;
    }

    public FieldOperand getTgtColumn() {
        if (this.expr != null && !this.expr.getOperands().isEmpty()) {
            for (AOperand op : this.expr.getOperands()) {
                if (!(op instanceof FieldOperand) || ((FieldOperand)op).getFromTable() != this.destTbl) continue;
                return (FieldOperand)op;
            }
        }
        return null;
    }

    public MFromTableJoin getMFromTableJoin() {
        if (this.destTbl instanceof MFromTableJoin) {
            return (MFromTableJoin)this.destTbl;
        }
        if (this.srcTbl instanceof MFromTableJoin) {
            return (MFromTableJoin)this.srcTbl;
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.srcTbl.toSQLString()) + " , " + this.destTbl.toSQLString();
    }
}

