/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.model.query.operand;

import com.jaspersoft.studio.data.sql.model.query.expression.AMExpression;
import com.jaspersoft.studio.data.sql.model.query.operand.AOperand;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;

public class FunctionOperand
extends AOperand {
    public static final long serialVersionUID = 10200L;
    private String function;
    private List<AOperand> arguments;
    private boolean star = false;
    private String analytical;

    public FunctionOperand(AMExpression<?> mexpr, String function, List<AOperand> arguments) {
        super(mexpr);
        this.function = function;
        this.arguments = arguments;
    }

    public FunctionOperand(AMExpression<?> mexpr, String function, boolean star) {
        super(mexpr);
        this.function = function;
        this.star = star;
    }

    public FunctionOperand(AMExpression<?> mexpr, String function, String analytical) {
        super(mexpr);
        this.function = function;
        this.analytical = analytical;
    }

    @Override
    public String toSQLString() {
        StringBuffer ss = new StringBuffer();
        ss.append(this.function);
        if (this.star) {
            ss.append("*");
        } else if (!Misc.isNullOrEmpty(this.arguments)) {
            String del = "";
            for (AOperand op : this.arguments) {
                ss.append(del);
                ss.append(op.toSQLString());
                del = ",";
            }
        } else {
            ss.append("OVER " + this.analytical);
        }
        ss.append(")");
        return ss.toString();
    }

    @Override
    public String toXString() {
        return this.toSQLString();
    }
}

