/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.model.query.select;

import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.query.AMQueryAliased;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.text2model.ConvertUtil;
import com.jaspersoft.studio.model.ANode;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.jface.viewers.StyledString;

public class MSelectColumn
extends AMQueryAliased<MSQLColumn> {
    public static final long serialVersionUID = 10200L;
    private MFromTable mfTable;

    public MSelectColumn(ANode parent, MSQLColumn value, MFromTable mfTable) {
        this(parent, value, mfTable, -1);
    }

    public MSelectColumn(ANode parent, MSQLColumn value, MFromTable mfTable, int index) {
        super(parent, value, null, index);
        this.mfTable = mfTable;
    }

    public MFromTable getMFromTable() {
        return this.mfTable;
    }

    public void setMFromTable(MFromTable mfTable) {
        this.mfTable = mfTable;
    }

    @Override
    public StyledString getStyledDisplayText() {
        StyledString ss = new StyledString();
        if (this.mfTable.getAlias() != null && !this.mfTable.getAlias().trim().isEmpty()) {
            ss.append(this.mfTable.getAlias());
        } else {
            ss.append(ConvertUtil.cleanDbNameFull(((MSqlTable)this.mfTable.getValue()).toSQLString()));
        }
        ss.append("." + ((MSQLColumn)this.getValue()).getDisplayText());
        this.addAlias(ss);
        return ss;
    }

    @Override
    public String getToolTip() {
        MSQLColumn mc = (MSQLColumn)this.getValue();
        String tooltip = ConvertUtil.cleanDbNameFull(mc.toSQLString());
        tooltip = String.valueOf(tooltip) + this.addAlias();
        tooltip = String.valueOf(tooltip) + "\n" + mc.getTypeName();
        if (((MSQLColumn)this.getValue()).getRemarks() != null) {
            tooltip = String.valueOf(tooltip) + "\n" + mc.getRemarks();
        }
        return tooltip;
    }

    @Override
    public String toSQLString() {
        String IQ = this.getRoot().getIdentifierQuote();
        boolean onlyException = this.getRoot().isQuoteExceptions();
        StringBuffer ss = new StringBuffer();
        if (this.mfTable.getAlias() != null && !this.mfTable.getAlias().trim().isEmpty()) {
            ss.append(this.mfTable.getAlias());
        } else {
            if (Util.getFromTables((ANode)this).size() < 2) {
                ss.append(Misc.quote((String)((MSQLColumn)this.getValue()).getDisplayText(), (String)IQ, (boolean)onlyException));
                return this.isFirst() ? ss.toString() : ",\n\t" + ss.toString();
            }
            ss.append(((MSqlTable)this.mfTable.getValue()).toSQLString());
        }
        ss.append("." + Misc.quote((String)((MSQLColumn)this.getValue()).getDisplayText(), (String)IQ, (boolean)onlyException));
        ss.append(this.addAlias());
        return this.isFirst() ? ss.toString() : ",\n\t" + ss.toString();
    }
}

