/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.text2model;

import com.jaspersoft.studio.data.sql.GroupByColumnFull;
import com.jaspersoft.studio.data.sql.OrGroupByColumn;
import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.impl.DbObjectNameImpl;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.query.AMQueryAliased;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.groupby.MGroupBy;
import com.jaspersoft.studio.data.sql.model.query.groupby.MGroupByColumn;
import com.jaspersoft.studio.data.sql.model.query.groupby.MGroupByExpression;
import com.jaspersoft.studio.data.sql.model.query.select.MSelect;
import com.jaspersoft.studio.data.sql.model.query.select.MSelectColumn;
import com.jaspersoft.studio.data.sql.model.query.select.MSelectExpression;
import com.jaspersoft.studio.data.sql.text2model.ConvertSelectColumns;
import com.jaspersoft.studio.data.sql.text2model.ConvertUtil;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import net.sf.jasperreports.eclipse.util.KeyValue;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ConvertGroupBy {
    public static void convertGroupBy(SQLQueryDesigner designer, ANode qroot, OrGroupByColumn cols) {
        if (cols == null) {
            return;
        }
        if (cols instanceof GroupByColumnFull) {
            ConvertGroupBy.doColumn(designer, Util.getKeyword(qroot, MSelect.class), (GroupByColumnFull)cols);
        } else if (cols instanceof OrGroupByColumn) {
            MSelect msel = Util.getKeyword(qroot, MSelect.class);
            for (GroupByColumnFull fcol : cols.getEntries()) {
                ConvertGroupBy.doColumn(designer, msel, fcol);
            }
        }
    }

    private static void doColumn(SQLQueryDesigner designer, MSelect msel, GroupByColumnFull tf) {
        try {
            MGroupBy parent = Util.getKeyword(msel.getParent(), MGroupBy.class);
            if (tf.getGbFunction() != null) {
                String f = ConvertSelectColumns.getFunctionString(designer, (ANode)msel.getRoot(), (ANode)parent, tf.getGbFunction(), msel);
                new MGroupByExpression((ANode)parent, f);
            } else if (tf.getColGrBy() != null) {
                EList eContents = tf.eContents();
                String column = null;
                column = tf instanceof DbObjectNameImpl ? ((DbObjectNameImpl)tf).getDbname() : ConvertUtil.getDbObjectName((EList<EObject>)eContents, 1);
                String table = ConvertUtil.getDbObjectName((EList<EObject>)eContents, 2);
                String schema = ConvertUtil.getDbObjectName((EList<EObject>)eContents, 3);
                KeyValue<MSQLColumn, MFromTable> kv = ConvertUtil.findColumn(msel, schema, table, column, designer);
                if (kv != null) {
                    new MGroupByColumn((ANode)parent, (MSQLColumn)kv.key, (MFromTable)kv.value);
                } else {
                    for (INode sn : msel.getChildren()) {
                        String alias;
                        if (!(sn instanceof AMQueryAliased) || Misc.isNullOrEmpty((String)(alias = ((AMQueryAliased)sn).getAlias())) || !alias.equalsIgnoreCase(column)) continue;
                        if (sn instanceof MSelectColumn) {
                            new MGroupByColumn((ANode)parent, (MSQLColumn)((MSelectColumn)sn).getValue(), ((MSelectColumn)sn).getMFromTable());
                            continue;
                        }
                        if (!(sn instanceof MSelectExpression)) continue;
                        new MGroupByExpression((ANode)parent, (MSelectExpression)sn);
                    }
                }
            } else {
                new MGroupByExpression((ANode)parent, Long.toString(tf.getGrByInt()));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

