/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.text2model;

import com.jaspersoft.studio.data.sql.DbObjectName;
import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.impl.ColImpl;
import com.jaspersoft.studio.data.sql.model.MDBObjects;
import com.jaspersoft.studio.data.sql.model.metadata.INotInMetadata;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlSchema;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.metadata.MTables;
import com.jaspersoft.studio.data.sql.model.query.AMQueryObject;
import com.jaspersoft.studio.data.sql.model.query.from.MFrom;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.select.MSelect;
import com.jaspersoft.studio.data.sql.model.query.select.MSelectExpression;
import com.jaspersoft.studio.data.sql.model.query.subquery.MQueryTable;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MDummy;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.model.util.ModelVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.jasperreports.eclipse.util.KeyValue;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ConvertUtil {
    public static String getDbObjectName(EList<EObject> eContents, int i) {
        int indx;
        ColImpl c;
        EObject eobj;
        int size = eContents.size();
        if (size >= i && (eobj = (EObject)eContents.get(size - i)) instanceof DbObjectName) {
            return ((DbObjectName)eobj).getDbname();
        }
        if (!eContents.isEmpty() && eContents.get(0) instanceof ColImpl && (size = (c = (ColImpl)eContents.get(0)).getEntries().size()) >= (indx = size - i) && indx >= 0) {
            return ((DbObjectName)c.getEntries().get(indx)).getDbname();
        }
        return null;
    }

    public static void cleanDBMetadata(MRoot dbRoot) {
        new ModelVisitor<Object>((INode)dbRoot){

            public boolean visit(INode n) {
                return true;
            }

            public void iterate(INode node) {
                ArrayList<INode> toRemove = null;
                for (INode n : node.getChildren()) {
                    if (n instanceof INotInMetadata && ((INotInMetadata)n).isNotInMetadata()) {
                        if (toRemove == null) {
                            toRemove = new ArrayList<INode>();
                        }
                        toRemove.add(n);
                        continue;
                    }
                    if (!this.visit(n)) continue;
                    this.iterate(n);
                }
                if (toRemove != null) {
                    ((ANode)node).removeChildren(toRemove);
                }
            }
        };
    }

    public static boolean isInSchema(MSqlTable msqltable, String schema) {
        MDBObjects mschema = null;
        if (schema != null) {
            schema = ConvertUtil.getDbName(schema);
            ANode parent = msqltable.getParent();
            if (parent != null) {
                if (parent instanceof MSqlSchema) {
                    mschema = (MSqlSchema)parent;
                } else if ((parent = parent.getParent()) instanceof MSqlSchema) {
                    mschema = (MSqlSchema)parent;
                }
            }
            if (mschema != null && !mschema.getValue().equalsIgnoreCase(schema)) {
                return false;
            }
        }
        return true;
    }

    public static KeyValue<MSQLColumn, MFromTable> findColumn(MSelect msel, String sch, String tbl, String clmn, SQLQueryDesigner designer) {
        final String schema = ConvertUtil.getDbName(sch);
        final String table = ConvertUtil.getDbName(tbl);
        final String column = ConvertUtil.getDbName(clmn);
        MFrom mfrom = Util.getKeyword((ANode)msel, MFrom.class);
        KeyValue<MSQLColumn, MFromTable> key = (KeyValue<MSQLColumn, MFromTable>)new ModelVisitor<KeyValue<MSQLColumn, MFromTable>>((INode)mfrom){

            public boolean visit(INode n) {
                if (n instanceof MFromTable) {
                    MFromTable ft = (MFromTable)n;
                    MSqlTable msqltable = (MSqlTable)ft.getValue();
                    if (!ConvertUtil.isInSchema(msqltable, schema)) {
                        return true;
                    }
                    if (table != null && !msqltable.getValue().equalsIgnoreCase(table) && (ft.getAlias() == null || ft.getAlias() != null && !ft.getAlias().equalsIgnoreCase(table))) {
                        return true;
                    }
                    for (INode c : msqltable.getChildren()) {
                        MSQLColumn mcol;
                        if (!(c instanceof MSQLColumn) || !(mcol = (MSQLColumn)c).getValue().equalsIgnoreCase(column)) continue;
                        this.setObject(new KeyValue((Object)mcol, (Object)ft));
                        this.stop();
                    }
                    return true;
                }
                return false;
            }
        }.getObject();
        if (key == null) {
            for (MFromTable mft : Util.getFromTables((ANode)msel)) {
                if (mft.getValue() instanceof MQueryTable && (key = ConvertUtil.findColumn(((MQueryTable)mft.getValue()).getSubquery(), schema, tbl, clmn, designer)) != null) {
                    key.value = mft;
                    return key;
                }
                if (!((MSqlTable)mft.getValue()).isNotInMetadata() || !((MSqlTable)mft.getValue()).getValue().equalsIgnoreCase(table)) continue;
                return new KeyValue((Object)ConvertUtil.addColumn((ANode)mft.getValue(), column), (Object)mft);
            }
        }
        if (key == null) {
            AMQueryObject star = null;
            Iterator<Object> iterator = msel.getChildren().iterator();
            while (iterator.hasNext()) {
                Object mse;
                String val;
                INode sn = (INode)iterator.next();
                if (!(sn instanceof MSelectExpression) || !(val = (String)((AMQueryObject)(mse = (MSelectExpression)sn)).getValue()).equals("*") && !val.endsWith(".*")) continue;
                star = mse;
                break;
            }
            if (star != null) {
                if (((String)star.getValue()).endsWith(".*")) {
                    String tblName = ((String)star.getValue()).substring(0, ((String)star.getValue()).length() - 2);
                    for (MFromTable mft : Util.getFromTables((ANode)msel)) {
                        MSqlTable v = (MSqlTable)mft.getValue();
                        if (v.isNotInMetadata() || !v.getValue().equalsIgnoreCase(tblName)) continue;
                        return new KeyValue((Object)ConvertUtil.addColumn((ANode)v, column), (Object)mft);
                    }
                    ConvertUtil.getTableUnknown(msel.getRoot(), schema, tblName, designer);
                }
                if (((String)star.getValue()).equals("*") && (iterator = Util.getFromTables((ANode)msel).iterator()).hasNext()) {
                    MFromTable mft = (MFromTable)iterator.next();
                    MSqlTable v = (MSqlTable)mft.getValue();
                    return new KeyValue((Object)ConvertUtil.addColumn((ANode)v, column), (Object)mft);
                }
                ConvertUtil.getTableUnknown(msel.getRoot(), schema, "", designer);
            }
        }
        return key;
    }

    public static MSQLColumn addColumn(ANode parent, String value) {
        for (INode n : parent.getChildren()) {
            if (!(n instanceof MSQLColumn) || !n.getValue().equals(value)) continue;
            return (MSQLColumn)n;
        }
        return new MSQLColumn(parent, value, null);
    }

    public static MSqlTable getTableUnknown(MRoot dbroot, String schema, String table, SQLQueryDesigner designer) {
        table = ConvertUtil.getDbName(table);
        MSqlSchema msqlschem = ConvertUtil.findSchema(dbroot, Misc.nvl((String)schema), designer);
        MSqlTable mtbl = ConvertUtil.findTable(dbroot, schema, Misc.nvl((String)table), designer);
        if (mtbl == null) {
            for (INode n : msqlschem.getChildren()) {
                if (!(n instanceof MTables)) continue;
                return new MSqlTable((MTables)n, Misc.nvl((String)table), true);
            }
            return new MSqlTable(new MTables(msqlschem, "Table"), Misc.nvl((String)table), true);
        }
        return mtbl;
    }

    public static MSqlSchema findSchema(MRoot dbroot, String schema, SQLQueryDesigner designer) {
        MSqlSchema ms;
        if (schema == null) {
            schema = "";
        }
        schema = ConvertUtil.getDbName(schema);
        boolean isNull = schema.isEmpty();
        for (INode n : dbroot.getChildren()) {
            ms = (MSqlSchema)n;
            if ((isNull || !ms.getValue().equalsIgnoreCase(schema)) && (!isNull || ms.getValue() == null || !ms.isCurrent() && !ms.getValue().equals(schema))) continue;
            designer.getDbMetadata().loadSchema(ms);
            return ms;
        }
        for (INode n : dbroot.getChildren()) {
            ms = (MSqlSchema)n;
            if (ms.getValue() == null || !ms.getValue().equals(schema)) continue;
            return ms;
        }
        return new MSqlSchema((ANode)dbroot, schema, null, true);
    }

    public static MSqlTable findTable(MRoot dbroot, String schema, String table, final SQLQueryDesigner designer) {
        final String tbl = ConvertUtil.getDbName(table);
        MSqlSchema ms = ConvertUtil.findSchema(dbroot, schema, designer);
        return (MSqlTable)new ModelVisitor<MSqlTable>((INode)ms){

            public boolean visit(INode n) {
                if (n instanceof MSqlTable) {
                    MSqlTable mt = (MSqlTable)n;
                    if (mt.getValue().equalsIgnoreCase(tbl)) {
                        if (mt.getChildren().isEmpty() || mt.getChildren().get(0) instanceof MDummy) {
                            designer.getDbMetadata().loadTable(mt);
                        }
                        this.setObject(mt);
                        this.stop();
                    }
                } else if (n instanceof MTables) {
                    return true;
                }
                return false;
            }
        }.getObject();
    }

    public static String cleanDbNameFull(String dbname) {
        StringBuilder r = new StringBuilder("");
        String sep = "";
        String[] stringArray = dbname.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            r.append(sep).append(ConvertUtil.getDbName(s));
            sep = ".";
            ++n2;
        }
        return r.toString();
    }

    public static String getDbName(String dbname) {
        if (dbname != null && !dbname.isEmpty()) {
            if (dbname.startsWith("\"") || dbname.endsWith("\"")) {
                return dbname.replace("\"", "");
            }
            if (dbname.startsWith("[") || dbname.endsWith("]")) {
                return dbname.replace("[", "").replace("]", "");
            }
            if (dbname.startsWith("`") || dbname.endsWith("`")) {
                return dbname.replace("`", "").replace("`$", "");
            }
        }
        return dbname;
    }

    public static String getParamValue(String prm) {
        return prm.replace("$P{", "").replace("}", "");
    }

    public static String getParamExclamationValue(String prm) {
        return prm.replace("$P!{", "").replace("}", "");
    }
}

