/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.ui.gef.command;

import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.query.expression.MExpression;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTableJoin;
import com.jaspersoft.studio.data.sql.model.query.from.TableJoin;
import com.jaspersoft.studio.data.sql.model.query.operand.FieldOperand;
import com.jaspersoft.studio.data.sql.ui.gef.command.ACommand;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;

public class JoinTableCommand
extends ACommand {
    private MSQLColumn src;
    private MFromTable srcTbl;
    private MSQLColumn dest;
    private MFromTable destTbl;
    private MFromTable fromTbl;
    private MExpression mexpr;
    private String join;

    public JoinTableCommand(MSQLColumn src, MFromTable srcTbl, MSQLColumn dest, MFromTable destTbl, MFromTable fromTbl, String join) {
        this.src = src;
        this.srcTbl = srcTbl;
        this.dest = dest;
        this.destTbl = destTbl;
        this.fromTbl = fromTbl;
        this.join = join;
    }

    @Override
    public void execute() {
        super.execute();
        if (this.src == null) {
            this.src = this.getColumn((MSqlTable)this.srcTbl.getValue());
        }
        if (this.dest == null) {
            this.dest = this.getColumn((MSqlTable)this.destTbl.getValue());
        }
        this.srcTbl.setParent(null, -1);
        boolean onlyExpression = false;
        for (INode n : this.fromTbl.getChildren()) {
            if (n != this.destTbl) continue;
            onlyExpression = true;
            break;
        }
        MFromTableJoin mtbljoin = null;
        if (!onlyExpression) {
            mtbljoin = new MFromTableJoin(this.fromTbl, (MSqlTable)this.srcTbl.getValue());
            mtbljoin.setNoEvents(true);
            mtbljoin.setPropertyValue("x", this.srcTbl.getPropertyActualValue("x"));
            mtbljoin.setPropertyValue("y", this.srcTbl.getPropertyActualValue("y"));
            mtbljoin.setNoEvents(false);
            mtbljoin.setAlias(this.srcTbl.getAlias());
            mtbljoin.setAliasKeyword(this.srcTbl.getAliasKeyword());
            this.fromTbl.removeTableJoin(mtbljoin.getTableJoin());
            mtbljoin.setJoin(this.join);
            mtbljoin.setTableJoin(new TableJoin(mtbljoin, this.destTbl));
            Util.copySubQuery(this.srcTbl, mtbljoin);
        } else {
            mtbljoin = (MFromTableJoin)this.destTbl;
        }
        this.mexpr = new MExpression((ANode)mtbljoin, this.src, -1);
        this.mexpr.getOperands().add(new FieldOperand(this.src, mtbljoin, this.mexpr));
        this.mexpr.getOperands().add(new FieldOperand(this.dest, this.destTbl, this.mexpr));
        Util.cleanTableVersions(mtbljoin, this.srcTbl);
    }

    public MExpression getMexpr() {
        return this.mexpr;
    }

    private MSQLColumn getColumn(MSqlTable tbl) {
        if (!tbl.getChildren().isEmpty()) {
            for (INode n : tbl.getChildren()) {
                if (((MSQLColumn)n).getPrimaryKey() == null) continue;
                return (MSQLColumn)n;
            }
            return (MSQLColumn)tbl.getChildren().get(0);
        }
        return null;
    }

    @Override
    protected void firePropertyChange() {
    }
}

