/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.ui.gef.parts;

import com.jaspersoft.studio.data.sql.QueryWriter;
import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.action.table.EditTableJoin;
import com.jaspersoft.studio.data.sql.model.query.IQueryString;
import com.jaspersoft.studio.data.sql.model.query.expression.MExpression;
import com.jaspersoft.studio.data.sql.model.query.expression.MExpressionGroup;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTableJoin;
import com.jaspersoft.studio.data.sql.model.query.from.TableJoinDetail;
import com.jaspersoft.studio.data.sql.model.query.operand.AOperand;
import com.jaspersoft.studio.data.sql.model.query.operand.FieldOperand;
import com.jaspersoft.studio.data.sql.model.query.subquery.MQueryTable;
import com.jaspersoft.studio.data.sql.ui.gef.anchors.LateralAnchor;
import com.jaspersoft.studio.data.sql.ui.gef.parts.ColumnEditPart;
import com.jaspersoft.studio.data.sql.ui.gef.parts.TableEditPart;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.util.ModelVisitor;
import java.util.List;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;

public class RelationshipDetailPart
extends AbstractConnectionEditPart {
    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
    }

    public TableJoinDetail getModel() {
        return (TableJoinDetail)super.getModel();
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType())) {
            SQLQueryDesigner designer = (SQLQueryDesigner)((Object)this.getViewer().getProperty("SQLQUERYDIAGRAM"));
            EditTableJoin ct = designer.getOutline().getAfactory().getAction(EditTableJoin.class);
            MFromTableJoin tJoin = this.getModel().getMFromTableJoin();
            if (ct.calculateEnabled(new Object[]{tJoin})) {
                ct.run();
            }
        }
    }

    protected IFigure createFigure() {
        PolylineConnection conn = (PolylineConnection)super.createFigure();
        conn.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        conn.setForegroundColor(UIUtils.getSystemColor((int)2));
        conn.setBackgroundColor(UIUtils.getSystemColor((int)2));
        return conn;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        TableJoinDetail m = this.getModel();
        MFromTableJoin tJoin = m.getMFromTableJoin();
        PolylineConnection f = (PolylineConnection)this.getFigure();
        this.setupToolTip(tJoin, f);
        if (tJoin.getJoin().equals("INNER JOIN")) {
            f.setTargetDecoration(RelationshipDetailPart.getInnerDecoration());
            f.setSourceDecoration(RelationshipDetailPart.getInnerDecoration());
        } else if (tJoin.getJoin().equals("LEFT OUTER JOIN")) {
            f.setTargetDecoration(RelationshipDetailPart.getOuterDecoration());
            f.setSourceDecoration(RelationshipDetailPart.getInnerDecoration());
        } else if (tJoin.getJoin().equals("RIGHT OUTER JOIN")) {
            f.setTargetDecoration(RelationshipDetailPart.getInnerDecoration());
            f.setSourceDecoration(RelationshipDetailPart.getOuterDecoration());
        } else if (tJoin.getJoin().equals("FULL OUTER JOIN")) {
            f.setTargetDecoration(RelationshipDetailPart.getOuterDecoration());
            f.setSourceDecoration(RelationshipDetailPart.getOuterDecoration());
        } else if (tJoin.getJoin().equals("CROSS JOIN")) {
            f.setTargetDecoration(RelationshipDetailPart.getCrossDecoration());
            f.setSourceDecoration(RelationshipDetailPart.getCrossDecoration());
        }
        if (m.getExpr() != null) {
            List<AOperand> ops = m.getExpr().getOperands();
            IFigure fcol = this.getColumnFigure(this.getSource(), ops);
            if (fcol != null) {
                f.setSourceAnchor((ConnectionAnchor)new LateralAnchor(fcol));
            }
            if ((fcol = this.getColumnFigure(this.getTarget(), ops)) != null) {
                f.setTargetAnchor((ConnectionAnchor)new LateralAnchor(fcol));
            }
        }
    }

    private void setupToolTip(MFromTableJoin tJoin, PolylineConnection f) {
        final StringBuffer tt = new StringBuffer();
        if (tJoin != null && tJoin.getValue() instanceof MQueryTable) {
            tt.append(String.valueOf(tJoin.toSQLString()) + QueryWriter.writeQuery((ANode)tJoin));
        } else {
            tt.append(tJoin.getToolTip());
            new ModelVisitor<Object>((INode)tJoin){

                public boolean visit(INode n) {
                    if (n instanceof MExpression || n instanceof MExpressionGroup) {
                        tt.append(((IQueryString)n).toSQLString());
                        return true;
                    }
                    return false;
                }
            };
        }
        f.setToolTip((IFigure)new Label(tt.toString().trim()));
    }

    private IFigure getColumnFigure(EditPart ep, List<AOperand> ops) {
        if (ep instanceof TableEditPart) {
            TableEditPart tep = (TableEditPart)ep;
            for (Object p : tep.getChildren()) {
                if (!(p instanceof ColumnEditPart)) continue;
                ColumnEditPart fo = (ColumnEditPart)((Object)p);
                for (AOperand o : ops) {
                    if (!(o instanceof FieldOperand) || !((FieldOperand)o).getMColumn().equals(fo.getModel())) continue;
                    return fo.getFigure();
                }
            }
        }
        return null;
    }

    public static RotatableDecoration getInnerDecoration() {
        CircleDecoration srcpd = new CircleDecoration();
        srcpd.setBackgroundColor(ColorConstants.black);
        return srcpd;
    }

    public static RotatableDecoration getOuterDecoration() {
        CircleDecoration srcpd = new CircleDecoration();
        srcpd.setBackgroundColor(ColorConstants.white);
        return srcpd;
    }

    public static RotatableDecoration getCrossDecoration() {
        CircleDecoration srcpd = new CircleDecoration();
        srcpd.setBackgroundColor(ColorConstants.lightGray);
        return srcpd;
    }

    public static class CircleDecoration
    extends Ellipse
    implements RotatableDecoration {
        private static final int RADIUS = 3;
        private Point location = new Point();

        public void setLocation(Point p) {
            this.location = p;
            int d = 6;
            Rectangle bounds = new Rectangle(this.location.x - 3, this.location.y - 3, d, d);
            this.setBounds(bounds);
        }

        public void setReferencePoint(Point p) {
            double d = Math.sqrt(Math.pow(this.location.x - p.x, 2.0) + Math.pow(this.location.y - p.y, 2.0));
            if (d < 3.0) {
                return;
            }
            double k = (d - 3.0) / d;
            int x = (int)(k * (double)Math.abs(p.x - this.location.x));
            int y = (int)(k * (double)Math.abs(p.y - this.location.y));
            int rx = this.location.x < p.x ? p.x - x : p.x + x;
            int ry = this.location.y > p.y ? p.y + y : p.y - y;
            this.setBounds(new Rectangle(rx - 3, ry - 3, 7, 7));
        }
    }
}

