/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.binary.asm;

class SignatureUtil {
    private static final char C_BOOLEAN = 'Z';
    private static final char C_BYTE = 'B';
    private static final char C_CHAR = 'C';
    private static final char C_DOUBLE = 'D';
    private static final char C_FLOAT = 'F';
    private static final char C_INT = 'I';
    private static final char C_SEMICOLON = ';';
    private static final char C_LONG = 'J';
    private static final char C_SHORT = 'S';
    private static final char C_VOID = 'V';
    private static final char C_TYPE_VARIABLE = 'T';
    private static final char C_STAR = '*';
    private static final char C_EXTENDS = '+';
    private static final char C_SUPER = '-';
    private static final char C_DOT = '.';
    private static final char C_ARRAY = '[';
    private static final char C_RESOLVED = 'L';
    private static final char C_UNRESOLVED = 'Q';
    private static final char C_GENERIC_START = '<';
    private static final char C_GENERIC_END = '>';
    private static final char C_CAPTURE = '!';

    SignatureUtil() {
    }

    static int scanTypeSignature(String string, int start) {
        if (start >= string.length()) {
            throw new IllegalArgumentException();
        }
        char c = string.charAt(start);
        switch (c) {
            case '[': {
                return SignatureUtil.scanArrayTypeSignature(string, start);
            }
            case 'L': 
            case 'Q': {
                return SignatureUtil.scanClassTypeSignature(string, start);
            }
            case 'T': {
                return SignatureUtil.scanTypeVariableSignature(string, start);
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return SignatureUtil.scanBaseTypeSignature(string, start);
            }
            case '!': {
                return SignatureUtil.scanCaptureTypeSignature(string, start);
            }
            case '*': 
            case '+': 
            case '-': {
                return SignatureUtil.scanTypeBoundSignature(string, start);
            }
        }
        throw new IllegalArgumentException();
    }

    private static int scanBaseTypeSignature(String string, int start) {
        if (start >= string.length()) {
            throw new IllegalArgumentException();
        }
        char c = string.charAt(start);
        if ("BCDFIJSVZ".indexOf(c) >= 0) {
            return start;
        }
        throw new IllegalArgumentException();
    }

    private static int scanArrayTypeSignature(String string, int start) {
        int length = string.length();
        if (start >= length - 1) {
            throw new IllegalArgumentException();
        }
        char c = string.charAt(start);
        if (c != '[') {
            throw new IllegalArgumentException();
        }
        c = string.charAt(++start);
        while (c == '[') {
            if (start >= length - 1) {
                throw new IllegalArgumentException();
            }
            c = string.charAt(++start);
        }
        return SignatureUtil.scanTypeSignature(string, start);
    }

    private static int scanCaptureTypeSignature(String string, int start) {
        if (start >= string.length() - 1) {
            throw new IllegalArgumentException();
        }
        char c = string.charAt(start);
        if (c != '!') {
            throw new IllegalArgumentException();
        }
        return SignatureUtil.scanTypeBoundSignature(string, start + 1);
    }

    private static int scanTypeVariableSignature(String string, int start) {
        if (start >= string.length() - 2) {
            throw new IllegalArgumentException();
        }
        char c = string.charAt(start);
        if (c != 'T') {
            throw new IllegalArgumentException();
        }
        int id = SignatureUtil.scanIdentifier(string, start + 1);
        c = string.charAt(id + 1);
        if (c == ';') {
            return id + 1;
        }
        throw new IllegalArgumentException();
    }

    private static int scanIdentifier(String string, int start) {
        if (start >= string.length()) {
            throw new IllegalArgumentException();
        }
        int p = start;
        do {
            char c;
            if ((c = string.charAt(p)) != '<' && c != '>' && c != ':' && c != ';' && c != '.' && c != '/') continue;
            return p - 1;
        } while (++p != string.length());
        return p - 1;
    }

    private static int scanClassTypeSignature(String string, int start) {
        if (start >= string.length() - 2) {
            throw new IllegalArgumentException();
        }
        char c = string.charAt(start);
        if (c != 'L' && c != 'Q') {
            return -1;
        }
        int p = start + 1;
        while (true) {
            if (p >= string.length()) {
                throw new IllegalArgumentException();
            }
            c = string.charAt(p);
            if (c == ';') {
                return p;
            }
            if (c == '<') {
                int e;
                p = e = SignatureUtil.scanTypeArgumentSignatures(string, p);
            } else if (c == '.' || c == '/') {
                int id;
                p = id = SignatureUtil.scanIdentifier(string, p + 1);
            }
            ++p;
        }
    }

    private static int scanTypeBoundSignature(String string, int start) {
        if (start >= string.length()) {
            throw new IllegalArgumentException();
        }
        char c = string.charAt(start);
        switch (c) {
            case '*': {
                return start;
            }
            case '+': 
            case '-': {
                if (start < string.length() - 2) break;
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        c = string.charAt(++start);
        switch (c) {
            case '!': {
                return SignatureUtil.scanCaptureTypeSignature(string, start);
            }
            case '+': 
            case '-': {
                return SignatureUtil.scanTypeBoundSignature(string, start);
            }
            case 'L': 
            case 'Q': {
                return SignatureUtil.scanClassTypeSignature(string, start);
            }
            case 'T': {
                return SignatureUtil.scanTypeVariableSignature(string, start);
            }
            case '[': {
                return SignatureUtil.scanArrayTypeSignature(string, start);
            }
            case '*': {
                return start;
            }
        }
        throw new IllegalArgumentException();
    }

    private static int scanTypeArgumentSignatures(String string, int start) {
        if (start >= string.length() - 1) {
            throw new IllegalArgumentException();
        }
        char c = string.charAt(start);
        if (c != '<') {
            throw new IllegalArgumentException();
        }
        int p = start + 1;
        while (true) {
            if (p >= string.length()) {
                throw new IllegalArgumentException();
            }
            c = string.charAt(p);
            if (c == '>') {
                return p;
            }
            int e = SignatureUtil.scanTypeArgumentSignature(string, p);
            p = e + 1;
        }
    }

    static int scanTypeArgumentSignature(String string, int start) {
        if (start >= string.length()) {
            throw new IllegalArgumentException();
        }
        char c = string.charAt(start);
        switch (c) {
            case '*': {
                return start;
            }
            case '+': 
            case '-': {
                return SignatureUtil.scanTypeBoundSignature(string, start);
            }
        }
        return SignatureUtil.scanTypeSignature(string, start);
    }
}

