/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.customvisualization.creation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public class ModuleDefinition {
    private String moduleVisualName;
    private String moduleName;
    private String licenseURL;
    private String libraryURL;
    private String variableName;
    private String renderResource;
    private String cssResource;
    private String libraryVersionNumber;
    private boolean needShim = false;
    private List<String> shim_dependencies = new ArrayList<String>();
    private String shimExportName;
    private List<ModuleDefinition> requiredLibraries = new ArrayList<ModuleDefinition>();
    private List<String> sampleResources = new ArrayList<String>();

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        Assert.isNotNull((Object)moduleName);
        this.moduleName = moduleName;
    }

    public String getModuleVisualName() {
        return this.moduleVisualName;
    }

    public void setModuleVisualName(String moduleVisualName) {
        this.moduleVisualName = moduleVisualName;
    }

    public String getLicenseURL() {
        return this.licenseURL;
    }

    public void setLicenseURL(String licenseURL) {
        Assert.isNotNull((Object)licenseURL);
        this.licenseURL = licenseURL;
    }

    public String getLibraryURL() {
        return this.libraryURL;
    }

    public void setLibraryURL(String libraryURL) {
        this.libraryURL = libraryURL;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String name) {
        Assert.isNotNull((Object)name);
        this.variableName = name;
    }

    public void setRenderResource(String renderResource) {
        this.renderResource = renderResource;
    }

    public String getRenderResourcePath() {
        return this.renderResource;
    }

    public String getRenderResource() {
        if (this.renderResource == null) {
            return null;
        }
        return this.fetchResource(this.renderResource);
    }

    public void setCssResource(String cssResource) {
        this.cssResource = cssResource;
    }

    public String getCssResource() {
        if (this.cssResource == null) {
            return null;
        }
        return this.fetchResource(this.cssResource);
    }

    public boolean isNeedShim() {
        return this.needShim;
    }

    public void setNeedShim(boolean needShim) {
        this.needShim = needShim;
    }

    public String getShimExportName() {
        return this.shimExportName;
    }

    public void setShimExportName(String shimExportName) {
        this.shimExportName = shimExportName;
    }

    public List<String> getShimDependencies() {
        return this.shim_dependencies;
    }

    public void addShimDependency(String dependency) {
        Assert.isNotNull((Object)dependency);
        this.shim_dependencies.add(dependency);
    }

    public String getLibraryVersionNumber() {
        return this.libraryVersionNumber;
    }

    public void setVersionNumber(String versionNumber) {
        Assert.isNotNull((Object)versionNumber);
        this.libraryVersionNumber = versionNumber;
    }

    public void addRequiredLibrary(ModuleDefinition library) {
        Assert.isNotNull((Object)library);
        this.requiredLibraries.add(library);
    }

    public List<ModuleDefinition> getRequiredLibraries() {
        return this.requiredLibraries;
    }

    public List<String> getSampleResources() {
        return this.sampleResources;
    }

    public void addSampleResource(String sampleResourcePath) {
        String path = sampleResourcePath.trim();
        if (!this.sampleResources.contains(path)) {
            this.sampleResources.add(path);
        }
    }

    public InputStream getResource(String resourceName) {
        URL url = this.getClass().getClassLoader().getResource(resourceName);
        try {
            return url.openStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return String.valueOf(this.getModuleName()) + " " + this.getLibraryVersionNumber();
    }

    public String getLibraryFilename() {
        String url = this.getLibraryURL();
        if (url == null) {
            return null;
        }
        return url.substring(url.lastIndexOf("/") + 1);
    }

    public File fetchLicense() {
        try {
            URL resource = new URL(this.licenseURL);
            InputStream is = resource.openStream();
            String tempDir = System.getProperty("java.io.tmpdir");
            File tempFile = new File(tempDir, "license");
            int counter = 0;
            while (tempFile.exists()) {
                tempFile = new File(tempDir, "license_" + counter);
                ++counter;
            }
            FileOutputStream outputStream = new FileOutputStream(tempFile);
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = is.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
            outputStream.close();
            return tempFile;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private String fetchResource(String path) {
        try {
            String line;
            URL url = this.getClass().getClassLoader().getResource(path);
            String result = "";
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((line = in.readLine()) != null) {
                result = String.valueOf(result) + line + "\n";
            }
            in.close();
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public File fetchLibrary() {
        try {
            URL resource = new URL(this.libraryURL);
            InputStream is = resource.openStream();
            String tempDir = System.getProperty("java.io.tmpdir");
            File tempFile = new File(tempDir, this.getLibraryFilename());
            if (tempFile.exists()) {
                tempFile.delete();
            }
            FileOutputStream outputStream = new FileOutputStream(tempFile);
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = is.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
            outputStream.close();
            return tempFile;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

