/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.customvisualization.properties;

import com.jaspersoft.studio.components.customvisualization.messages.Messages;
import com.jaspersoft.studio.components.customvisualization.properties.CVItemPropertyDialog;
import com.jaspersoft.studio.components.customvisualization.properties.ItemPropertyNameLabelProvider;
import com.jaspersoft.studio.components.customvisualization.properties.ItemPropertyValueLabelProvider;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItem;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class CVItemDialog
extends PersistentLocationDialog
implements IExpressionContextSetter {
    private StandardItem item;
    private ExpressionContext expContext;
    private TableViewer propertiesTV;
    private Button btnAddProperty;
    private Button btnModifyProperty;
    private Button btnRemoveProperty;

    public CVItemDialog(Shell parentShell, Item item) {
        super(parentShell);
        this.item = (StandardItem)item;
        if (this.item == null) {
            this.item = new StandardItem();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(2, false));
        this.propertiesTV = this.createPropertiesTable(container);
        this.btnAddProperty = new Button(container, 8);
        this.btnAddProperty.setText(Messages.CVItemDialog_Add);
        this.btnAddProperty.setLayoutData((Object)new GridData(4, 128, false, false));
        this.btnAddProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CVItemDialog.this.addNewPropertyBtnPressed();
            }
        });
        this.btnModifyProperty = new Button(container, 8);
        this.btnModifyProperty.setText(Messages.CVItemDialog_Edit);
        this.btnModifyProperty.setLayoutData((Object)new GridData(4, 128, false, false));
        this.btnModifyProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CVItemDialog.this.modifyPropertyBtnPressed();
            }
        });
        this.btnRemoveProperty = new Button(container, 8);
        this.btnRemoveProperty.setText(Messages.CVItemDialog_Remove);
        this.btnRemoveProperty.setLayoutData((Object)new GridData(4, 128, false, false));
        this.btnRemoveProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CVItemDialog.this.removePropertyBtnPressed();
            }
        });
        CVItemDialog.applyDialogFont((Control)container);
        this.propertiesTV.setInput((Object)this.item.getProperties());
        return container;
    }

    private void addNewPropertyBtnPressed() {
        CVItemPropertyDialog d = new CVItemPropertyDialog(UIUtils.getShell(), null, null);
        d.setExpressionContext(this.expContext);
        if (d.open() == 0) {
            this.item.getProperties().add(d.getItemProperty());
            this.propertiesTV.setInput((Object)this.item.getProperties());
        }
    }

    private void modifyPropertyBtnPressed() {
        ItemProperty p = this.getCurrentSelectedProperty();
        if (p != null) {
            ItemProperty clonedP = (ItemProperty)p.clone();
            CVItemPropertyDialog d = new CVItemPropertyDialog(UIUtils.getShell(), clonedP, null);
            d.setExpressionContext(this.expContext);
            if (d.open() == 0) {
                int idx = this.item.getProperties().indexOf(p);
                this.item.getProperties().remove(p);
                this.item.getProperties().add(idx, clonedP);
                this.propertiesTV.setInput((Object)this.item.getProperties());
            }
        }
    }

    private void removePropertyBtnPressed() {
        ItemProperty p = this.getCurrentSelectedProperty();
        if (p != null) {
            this.item.getProperties().remove(p);
            this.propertiesTV.setInput((Object)this.item.getProperties());
        }
    }

    private ItemProperty getCurrentSelectedProperty() {
        Object selEl = ((IStructuredSelection)this.propertiesTV.getSelection()).getFirstElement();
        if (selEl instanceof ItemProperty) {
            return (ItemProperty)selEl;
        }
        return null;
    }

    private TableViewer createPropertiesTable(Composite parent) {
        Composite cmpItemPropertiesTableViewer = new Composite(parent, 0);
        cmpItemPropertiesTableViewer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        TableColumnLayout tl_itemPropertiesTableViewer = new TableColumnLayout();
        cmpItemPropertiesTableViewer.setLayout((Layout)tl_itemPropertiesTableViewer);
        TableViewer tv = new TableViewer(cmpItemPropertiesTableViewer, 68100);
        tv.getTable().setHeaderVisible(true);
        tv.getTable().setLinesVisible(true);
        TableViewerColumn tvcName = new TableViewerColumn(tv, 0);
        tvcName.getColumn().setText(Messages.CVItemDialog_ColName);
        tvcName.setLabelProvider((CellLabelProvider)new ItemPropertyNameLabelProvider());
        tl_itemPropertiesTableViewer.setColumnData((Widget)tvcName.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        TableViewerColumn tvcValue = new TableViewerColumn(tv, 0);
        tvcValue.getColumn().setText(Messages.CVItemDialog_ColValue);
        tvcValue.setLabelProvider((CellLabelProvider)new ItemPropertyValueLabelProvider());
        tl_itemPropertiesTableViewer.setColumnData((Widget)tvcValue.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        tv.setContentProvider((IContentProvider)new ArrayContentProvider());
        tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CVItemDialog.this.modifyPropertyBtnPressed();
            }
        });
        return tv;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CVItemDialog_EditItem);
        UIUtils.resizeAndCenterShell((Shell)newShell, (int)450, (int)300);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public Item getCVItem() {
        return this.item;
    }
}

