/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.domain.client;

import com.jaspersoft.jasperserver.api.metadata.common.domain.InternalURI;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@XmlRootElement(name="user")
public class UserImpl
implements User,
InternalURI,
Serializable {
    @XmlTransient
    private Set roleSet = new HashSet();
    private String username = null;
    private String fullName = null;
    @XmlTransient
    private String password = null;
    @XmlTransient
    private String emailAddress = null;
    private boolean externallyDefined = false;
    @XmlTransient
    private boolean enabled = false;
    @XmlTransient
    private Date previousPasswordChangeTime = null;
    @XmlTransient
    private List attributes = null;
    private String tenantId = null;

    @Override
    @XmlElement(name="username")
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String newUsername) {
        if (newUsername == null || newUsername.trim().length() == 0) {
            throw new RuntimeException("No user name");
        }
        this.username = newUsername;
    }

    @Override
    @XmlElement(name="fullName")
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Override
    @XmlTransient
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    @XmlTransient
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @Override
    @XmlTransient
    public Set getRoles() {
        return this.roleSet;
    }

    @Override
    public void setRoles(Set newRoleSet) {
        this.roleSet = newRoleSet;
    }

    @Override
    public void addRole(Role newRole) {
        if (newRole != null && !this.getRoles().contains(newRole)) {
            this.getRoles().add(newRole);
        }
    }

    @Override
    public void removeRole(Role removedRole) {
        this.getRoles().remove(removedRole);
    }

    @Override
    @XmlTransient
    public List getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(List attrs) {
        this.attributes = attrs;
    }

    @Override
    @XmlElement(name="externallyDefined")
    public boolean isExternallyDefined() {
        return this.externallyDefined;
    }

    @Override
    public void setExternallyDefined(boolean externallyDefined) {
        this.externallyDefined = externallyDefined;
    }

    @Override
    @XmlTransient
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("username", (Object)this.getUsername());
        if (this.getTenantId() != null) {
            builder.append("tenantId", (Object)this.getTenantId());
        }
        return builder.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof UserImpl)) {
            return false;
        }
        UserImpl castOther = (UserImpl)other;
        return new EqualsBuilder().append((Object)this.getUsername(), (Object)castOther.getUsername()).append((Object)this.getTenantId(), (Object)castOther.getTenantId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getUsername()).append((Object)this.getTenantId()).toHashCode();
    }

    @Override
    @XmlTransient
    public Date getPreviousPasswordChangeTime() {
        return this.previousPasswordChangeTime;
    }

    @Override
    public void setPreviousPasswordChangeTime(Date previousPasswordChangeTime) {
        this.previousPasswordChangeTime = previousPasswordChangeTime;
    }

    @Override
    @XmlElement(name="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tid) {
        this.tenantId = tid;
    }

    @Override
    @XmlTransient
    public String getURI() {
        StringBuilder res = new StringBuilder("user").append(":");
        if (this.getTenantId() != null) {
            res.append("/").append(this.getTenantId());
        }
        return res.append("/").append(this.getUsername()).toString();
    }

    @Override
    @XmlTransient
    public String getPath() {
        StringBuilder res = new StringBuilder();
        if (this.getTenantId() != null) {
            res.append("/").append(this.getTenantId());
        }
        return res.append("/").append(this.getUsername()).toString();
    }

    @Override
    @XmlTransient
    public String getProtocol() {
        return "user";
    }

    @Override
    @XmlTransient
    public String getParentURI() {
        return null;
    }

    @Override
    @XmlTransient
    public String getParentPath() {
        return null;
    }
}

