/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services;

import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.services.ExecutionStatus;
import com.jaspersoft.jasperserver.remote.services.ExportExecutionOptions;
import com.jaspersoft.jasperserver.remote.services.ReportOutputResource;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
public class ExportExecution {
    private ExportExecutionOptions options;
    private ExecutionStatus status;
    private ErrorDescriptor errorDescriptor;
    private ReportOutputResource outputResource;
    private Map<String, ReportOutputResource> attachments = new ConcurrentHashMap<String, ReportOutputResource>();
    private Lock lock = new ReentrantLock();
    private Condition condition = this.lock.newCondition();
    private volatile Boolean done = false;

    @XmlElement
    public String getId() {
        return this.options.toString();
    }

    @XmlTransient
    public ExportExecutionOptions getOptions() {
        return this.options;
    }

    public void setOptions(ExportExecutionOptions options) {
        this.options = options;
    }

    public ExecutionStatus getStatus() {
        return this.status;
    }

    public void setStatus(ExecutionStatus status) {
        this.lock.lock();
        try {
            this.status = status;
            if (status != ExecutionStatus.queued && status != ExecutionStatus.execution) {
                this.done = true;
                this.condition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public ErrorDescriptor getErrorDescriptor() {
        return this.errorDescriptor;
    }

    public void setErrorDescriptor(ErrorDescriptor errorDescriptor) {
        this.lock.lock();
        try {
            this.status = ExecutionStatus.failed;
            this.errorDescriptor = errorDescriptor;
            this.done = true;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public ReportOutputResource getOutputResource() {
        return this.outputResource;
    }

    @XmlTransient
    public ReportOutputResource getFinalOutputResource() throws RemoteException {
        this.lock.lock();
        try {
            while (!this.done.booleanValue()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw new RemoteException(new ErrorDescriptor().setException((Throwable)e));
                }
            }
            if (this.status == null) {
                throw new IllegalStateException("Status shouldn't be null");
            }
            ErrorDescriptor descriptor = null;
            switch (this.status) {
                case failed: {
                    descriptor = this.errorDescriptor != null ? this.errorDescriptor : new ErrorDescriptor().setErrorCode("export.failed").setMessage("Export failed");
                    break;
                }
                case cancelled: {
                    descriptor = new ErrorDescriptor().setErrorCode("export.cancelled").setMessage("Export cancelled");
                    break;
                }
                case ready: {
                    break;
                }
                default: {
                    descriptor = new ErrorDescriptor().setErrorCode("export.not.ready").setMessage("Export not ready");
                }
            }
            if (descriptor != null) {
                throw new RemoteException(descriptor);
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.outputResource;
    }

    public void setOutputResource(ReportOutputResource outputResource) {
        this.outputResource = outputResource;
    }

    @XmlTransient
    public Map<String, ReportOutputResource> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Map<String, ReportOutputResource> attachments) {
        this.attachments = attachments;
    }

    @XmlElementWrapper(name="attachments")
    @XmlElement(name="attachment")
    public Set<ReportOutputResource> getAttachmentsSet() {
        return this.attachments != null && !this.attachments.isEmpty() ? new HashSet<ReportOutputResource>(this.attachments.values()) : null;
    }
}

