/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services.impl;

import com.jaspersoft.jasperserver.remote.services.impl.ExcludeDaysWrapper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class ExcludeDaysXmlAdapter
extends XmlAdapter<ExcludeDaysWrapper, ArrayList<Calendar>> {
    private DateFormat format = new SimpleDateFormat("yyyy-MM-dd");

    public ArrayList<Calendar> unmarshal(ExcludeDaysWrapper v) throws Exception {
        ArrayList<Calendar> result = null;
        if (v != null && v.getExcludeDays() != null && !v.getExcludeDays().isEmpty()) {
            result = new ArrayList<Calendar>();
            for (String currentCalendarString : v.getExcludeDays()) {
                Date date = this.format.parse(currentCalendarString);
                Calendar currentCalendar = Calendar.getInstance();
                currentCalendar.setTime(date);
                result.add(currentCalendar);
            }
        }
        return result;
    }

    public ExcludeDaysWrapper marshal(ArrayList<Calendar> v) throws Exception {
        ExcludeDaysWrapper result = null;
        if (v != null && !v.isEmpty()) {
            ArrayList<String> dayStrings = new ArrayList<String>();
            for (Calendar currentCalendar : v) {
                dayStrings.add(this.format.format(currentCalendar.getTime()));
            }
            result = new ExcludeDaysWrapper(dayStrings);
        }
        return result;
    }
}

