/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.action.resource;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.server.ResourceFactory;
import com.jaspersoft.studio.server.action.resource.AddResourceAction;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MAdHocDataView;
import java.util.ArrayList;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class CutResourceAction
extends Action {
    private TreeViewer treeViewer;

    public CutResourceAction(TreeViewer treeViewer) {
        this.setId(ActionFactory.CUT.getId());
        this.setText(Messages.common_cut);
        this.setToolTipText(Messages.common_cut);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        this.treeViewer = treeViewer;
    }

    public boolean isEnabled() {
        boolean b;
        Object firstElement = ((TreeSelection)this.treeViewer.getSelection()).getFirstElement();
        boolean bl = b = firstElement != null && firstElement instanceof AMResource;
        if (firstElement instanceof MAdHocDataView) {
            return false;
        }
        if (b) {
            AMResource mres = (AMResource)((Object)firstElement);
            int pmask = mres.getValue().getPermissionMask(mres.getWsClient());
            boolean bl2 = b = b && (pmask == 1 || (pmask & 2) == 2 && (pmask & 0x10) == 16);
            if (AddResourceAction.isSpecialFolder(mres)) {
                return false;
            }
        }
        return b;
    }

    public void run() {
        TreeSelection s = (TreeSelection)this.treeViewer.getSelection();
        final TreePath[] p = s.getPaths();
        final ArrayList rlist = new ArrayList();
        Job job = new Job("Copy resources"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Copy resources", -1);
                try {
                    int i = 0;
                    while (i < p.length) {
                        Object obj = p[i].getLastSegment();
                        if (obj instanceof AMResource) {
                            AMResource amres = (AMResource)((Object)obj);
                            if (amres.getValue().getWsType().equals("contentResource")) {
                                try {
                                    ResourceDescriptor rd = amres.getWsClient().get(monitor, amres.getValue(), null);
                                    amres.setValue(rd);
                                    ANode parent = amres.getParent();
                                    int indx = parent.getChildren().indexOf(obj);
                                    parent.removeChild((ANode)amres);
                                    obj = ResourceFactory.getResource(parent, rd, indx);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            ((AMResource)((Object)obj)).setCut(true);
                            rlist.add((AMResource)((Object)obj));
                        }
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        ++i;
                    }
                    UIUtils.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!rlist.isEmpty()) {
                                Clipboard.getDefault().setContents((Object)rlist);
                            }
                            (this).CutResourceAction.this.treeViewer.refresh();
                        }
                    });
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.schedule();
    }
}

