/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.action.resource;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.action.resource.AddResourceAction;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MFolder;
import com.jaspersoft.studio.server.model.MJrxml;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class DeleteResourceAction
extends Action {
    public static final String ID = "com.jaspersoft.studio.server.action.resource.deleteResourceAction";
    private TreeViewer treeViewer;

    public DeleteResourceAction(TreeViewer treeViewer) {
        this.setId(ID);
        this.setText(Messages.common_delete);
        this.setToolTipText(Messages.common_delete);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.treeViewer = treeViewer;
    }

    public boolean isEnabled() {
        Object firstElement = ((TreeSelection)this.treeViewer.getSelection()).getFirstElement();
        boolean b = firstElement instanceof AMResource;
        if (b) {
            AMResource mres = (AMResource)((Object)firstElement);
            int pmask = mres.getValue().getPermissionMask(mres.getWsClient());
            boolean bl = b = b && (pmask == 1 || (pmask & 0x10) == 16);
            if (AddResourceAction.isSpecialFolder(mres)) {
                return false;
            }
            if (firstElement instanceof MJrxml && ((MJrxml)((Object)firstElement)).getValue().isMainReport()) {
                return false;
            }
        }
        return b;
    }

    public void run() {
        TreeSelection s = (TreeSelection)this.treeViewer.getSelection();
        final TreePath[] p = s.getPaths();
        if (!UIUtils.showDeleteConfirmation()) {
            return;
        }
        ProgressMonitorDialog pm = new ProgressMonitorDialog(UIUtils.getShell());
        try {
            pm.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.DeleteResourceAction_0, p.length);
                    try {
                        HashSet<ANode> toRefresh = new HashSet<ANode>();
                        HashSet<MReportUnit> set = new HashSet<MReportUnit>();
                        HashSet<MReportUnit> deleted = new HashSet<MReportUnit>();
                        int i = 0;
                        while (i < p.length) {
                            Object obj = p[i].getLastSegment();
                            if (obj instanceof AMResource) {
                                AMResource mres;
                                if (((ANode)obj).getParent() != null) {
                                    toRefresh.add(((ANode)obj).getParent());
                                }
                                if ((mres = (AMResource)((Object)obj)).getParent() instanceof MServerProfile || mres.getParent() instanceof MFolder) {
                                    this.deleteResource(monitor, (AMResource)((Object)obj));
                                    if (mres instanceof MReportUnit) {
                                        deleted.add((MReportUnit)mres);
                                    }
                                } else if (mres.getParent() instanceof MReportUnit) {
                                    MReportUnit mrunit = (MReportUnit)mres.getParent();
                                    mrunit.getChildren().remove((Object)mres);
                                    if (!deleted.contains(mrunit)) {
                                        set.add(mrunit);
                                        ResourceDescriptor toDel = null;
                                        List<ResourceDescriptor> children = mrunit.getValue().getChildren();
                                        String uri = mres.getValue().getUriString();
                                        for (ResourceDescriptor rd : children) {
                                            if (rd.getUriString() == null || !rd.getUriString().equals(uri)) continue;
                                            toDel = rd;
                                            break;
                                        }
                                        if (toDel != null) {
                                            children.remove(toDel);
                                        }
                                    }
                                }
                            }
                            ++i;
                        }
                        for (MReportUnit mrunit : set) {
                            if (deleted.contains(mrunit)) continue;
                            try {
                                monitor.subTask(mrunit.getDisplayText());
                                WSClientHelper.save(monitor, mrunit);
                                deleted.add(mrunit);
                                WSClientHelper.refreshResource(mrunit, monitor);
                            }
                            catch (Throwable e) {
                                UIUtils.showError((Throwable)e);
                            }
                        }
                        for (ANode n : toRefresh) {
                            if (n instanceof AMResource) {
                                try {
                                    WSClientHelper.refreshResource((AMResource)n, monitor);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                continue;
                            }
                            if (!(n instanceof MServerProfile)) continue;
                            try {
                                WSClientHelper.connectGetData((MServerProfile)n, monitor);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        UIUtils.getDisplay().asyncExec(() -> DeleteResourceAction.this.treeViewer.refresh(true));
                    }
                    finally {
                        monitor.done();
                    }
                }

                private void deleteResource(IProgressMonitor monitor, AMResource mres) {
                    try {
                        monitor.subTask(mres.getDisplayText());
                        WSClientHelper.deleteResource(monitor, mres);
                    }
                    catch (Throwable e) {
                        UIUtils.showError((Throwable)e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            UIUtils.showError((Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            UIUtils.showError((Throwable)e);
        }
    }
}

