/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.action.resource;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.server.ServerProvider;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.protocol.Feature;
import com.jaspersoft.studio.server.protocol.IConnection;
import com.jaspersoft.studio.server.wizard.find.FindResourceJob;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class FindResourceAction
extends Action {
    public static final String ID = "findResourceAction";
    private TreeViewer treeViewer;
    private ServerProvider sp;

    public FindResourceAction(TreeViewer treeViewer, ServerProvider sp) {
        this.sp = sp;
        this.setId(ID);
        this.setText(Messages.FindResourceAction_0);
        this.setDescription(Messages.FindResourceAction_1);
        this.setToolTipText(this.getDescription());
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/find_obj.gif"));
        this.treeViewer = treeViewer;
    }

    public boolean isEnabled() {
        boolean en = false;
        TreeSelection selection = (TreeSelection)this.treeViewer.getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement != null) {
            INode n;
            MServerProfile msp = null;
            if (firstElement instanceof MServerProfile) {
                msp = (MServerProfile)((Object)firstElement);
            } else if (firstElement instanceof AMResource && (n = ((AMResource)((Object)firstElement)).getRoot()) instanceof MServerProfile) {
                msp = (MServerProfile)n;
            }
            try {
                IConnection c;
                if (msp != null && (c = msp.getWsClient()) != null) {
                    en = msp != null && c.isSupported(Feature.SEARCHREPOSITORY);
                }
            }
            catch (Exception exception) {
                en = false;
            }
        }
        this.setEnabled(en);
        return en;
    }

    public void run() {
        FindResourceJob.doFindResource(this.sp, this.treeViewer);
    }
}

