/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.action.resource;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.book.BookUtils;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.server.ResourceFactory;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.export.AExporter;
import com.jaspersoft.studio.server.export.ImageExporter;
import com.jaspersoft.studio.server.export.JrxmlExporter;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AFileResource;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MJrxml;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.publish.PublishUtil;
import com.jaspersoft.studio.utils.SelectionHelper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.ide.IDE;

public class OpenInEditorAction
extends Action {
    private static final String ID = "OPENINEDITOR";
    protected TreeViewer treeViewer;
    private boolean openInEditor = true;
    protected IPath path;

    public OpenInEditorAction(TreeViewer treeViewer, boolean openInEditor) {
        this(treeViewer);
        this.openInEditor = openInEditor;
    }

    public OpenInEditorAction(TreeViewer treeViewer) {
        this.setId(ID);
        this.setText(Messages.OpenInEditorAction_title);
        this.setDescription(Messages.OpenInEditorAction_desc);
        this.setToolTipText(Messages.OpenInEditorAction_desc);
        this.treeViewer = treeViewer;
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.isDataResource();
    }

    private boolean isDataResource() {
        TreeSelection s = (TreeSelection)this.treeViewer.getSelection();
        TreePath[] p = s.getPaths();
        int i = 0;
        while (i < p.length) {
            if (!this.isFileResource(p[i].getLastSegment())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isFileResource(Object obj) {
        return obj != null && obj instanceof AFileResource && !(obj instanceof MReportUnit);
    }

    protected boolean preDownload(AFileResource fres, IProgressMonitor monitor) {
        INode root = fres.getRoot();
        Object ttroot = null;
        try {
            ttroot = root instanceof MServerProfile ? ((MServerProfile)root).getTempWorkspaceLocation(monitor) : FileUtils.getInProjectFolder((URI)FileUtils.createTempDir().toURI(), (IProgressMonitor)monitor);
            ResourceDescriptor rd = fres.getValue();
            String f = String.valueOf(rd.getParentFolder()) + File.separator + rd.getName();
            IFile newFileRes = null;
            if (ttroot instanceof IProject) {
                newFileRes = ((IProject)ttroot).getFile(f);
            } else if (ttroot instanceof IFolder) {
                newFileRes = ((IFolder)ttroot).getFile(f);
            } else {
                throw new IOException(NLS.bind((String)"{0} is not a valid location (i.e folder or project)", (Object)ttroot.toString()));
            }
            FileUtils.createResource((IResource)newFileRes, (IProgressMonitor)monitor);
            this.path = newFileRes.getFullPath();
        }
        catch (IOException | CoreException e) {
            UIUtils.showError((Throwable)e);
        }
        return true;
    }

    public void run() {
        TreeSelection s = (TreeSelection)this.treeViewer.getSelection();
        TreePath[] p = s.getPaths();
        int i = 0;
        while (i < p.length) {
            final Object obj = p[i].getLastSegment();
            if (this.isFileResource(obj)) {
                if (!this.preDownload((AFileResource)((Object)obj), (IProgressMonitor)new NullProgressMonitor())) break;
                WorkspaceJob job = new WorkspaceJob(Messages.OpenInEditorAction_0){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        try {
                            try {
                                monitor.beginTask(Messages.OpenInEditorAction_0, -1);
                                OpenInEditorAction.this.dorun(obj, monitor);
                            }
                            catch (Throwable e) {
                                UIUtils.showError((Throwable)e);
                                monitor.done();
                            }
                        }
                        finally {
                            monitor.done();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
                break;
            }
            ++i;
        }
    }

    protected void dorun(Object obj, IProgressMonitor monitor) throws Exception {
        if (this.isFileResource(obj)) {
            AFileResource res = (AFileResource)((Object)obj);
            ResourceDescriptor rd = WSClientHelper.getResource((IProgressMonitor)new NullProgressMonitor(), (ANode)res, res.getValue());
            ANode parent = res.getParent();
            if (parent != null) {
                int index = parent.getChildren().indexOf((Object)res);
                parent.removeChild((ANode)res);
                res = (AFileResource)ResourceFactory.getResource(parent, rd, index);
                WSClientHelper.fireResourceChanged(res);
                String fkeyname = ServerManager.getKey(res);
                if (fkeyname == null) {
                    return;
                }
                String type = rd.getWsType();
                IFile f = null;
                if (type.equals("jrxml")) {
                    this.doExportJrxml(res, rd, fkeyname, monitor);
                    return;
                }
                f = type.equals("img") ? new ImageExporter(this.path).exportToIFile(res, rd, fkeyname, monitor) : new AExporter(this.path).exportToIFile(res, rd, fkeyname, monitor);
                if (f != null) {
                    PublishUtil.savePath(f, res);
                    this.openEditor(f, res);
                }
                this.path = null;
            }
        }
    }

    protected void doExportJrxml(AFileResource res, ResourceDescriptor rd, String fkeyname, IProgressMonitor monitor) throws Exception {
        IFile f = new JrxmlExporter(this.path).exportToIFile(res, rd, fkeyname, monitor);
        if (f != null) {
            JasperReportsConfiguration jrconf = JasperReportsConfiguration.getDefaultJRConfig((IFile)f);
            try {
                jrconf.getPrefStore().setValue("PUBLISH2JSS.SILENT", true);
                this.openEditor(f, res);
            }
            finally {
                jrconf.dispose();
            }
        }
        String prjPath = f.getRawLocation().removeLastSegments(1).toOSString();
        if (res.getParent() instanceof MReportUnit) {
            MReportUnit runit = (MReportUnit)res.getParent();
            List children = runit.getChildren();
            String pfolder = this.path != null ? this.path.toFile().getParentFile().getAbsolutePath() : "";
            int i = 0;
            while (i < children.size()) {
                INode n = (INode)children.get(i);
                if (n != res && n instanceof AFileResource) {
                    AFileResource mfile = (AFileResource)n;
                    fkeyname = ServerManager.getKey(mfile);
                    IPath p = Path.fromOSString((String)(String.valueOf(pfolder) + File.separator + mfile.getValue().getName()));
                    if (!Paths.get(prjPath, mfile.getValue().getName()).toFile().exists() && (rd = WSClientHelper.getResource((IProgressMonitor)new NullProgressMonitor(), (ANode)mfile, mfile.getValue())) != null) {
                        this.exportFile(rd, fkeyname, monitor, f, runit, mfile, p);
                    }
                }
                ++i;
            }
        }
    }

    private void exportFile(ResourceDescriptor rd, String fkeyname, IProgressMonitor monitor, IFile f, MReportUnit runit, AFileResource mfile, IPath p) throws Exception {
        AExporter exp = null;
        if (rd.getWsType().equals("img")) {
            exp = new ImageExporter(p);
        } else if (rd.getWsType().equals("jrxml")) {
            exp = new JrxmlExporter(p);
            if (BookUtils.isValidJRBook((IFile)f)) {
                IDE.setDefaultEditor((IFile)f, (String)"com.jaspersoft.studio.book.editors.JRBookEditor");
            } else {
                IDE.setDefaultEditor((IFile)f, (String)"com.jaspersoft.studio.editor.JrxmlEditor");
            }
        } else {
            exp = new AExporter(p);
        }
        IFile file = ((AExporter)exp).exportToIFile(mfile, rd, fkeyname, monitor);
        if (file != null) {
            PublishUtil.savePath(file, mfile);
            if (rd.getReferenceUri() != null || !rd.getUriString().startsWith(runit.getValue().getUriString())) {
                this.createLink(file.getLocation(), rd.getName(), f, monitor);
            }
        }
    }

    private void createLink(IPath path, String name, IFile file, IProgressMonitor monitor) throws CoreException {
        IProject project = file.getProject();
        IFile newFile = project.getFile(file.getParent().getProjectRelativePath() + "/" + name);
        newFile.createLink(path, 256, monitor);
    }

    protected void openEditor(IFile f, AMResource res) {
        try {
            BookUtils.checkFileResourceForDefaultEditor((IFile)f);
        }
        catch (Throwable throwable) {}
        if (!this.openInEditor) {
            return;
        }
        UIUtils.getDisplay().asyncExec(() -> {
            if (res instanceof MJrxml) {
                if (BookUtils.isValidJRBook((IFile)f)) {
                    SelectionHelper.openEditorType((IFile)f, (String)"com.jaspersoft.studio.book.editors.JRBookEditor");
                } else {
                    SelectionHelper.openEditorType((IFile)f, (String)"com.jaspersoft.studio.editor.JrxmlEditor");
                }
            } else {
                SelectionHelper.openEditor((IFile)f);
            }
        });
    }
}

