/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.action.resource;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.utils.SelectionHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;

public class RunReportUnitAction
extends Action {
    private static final String ID = "RUNREPORTUNIT";
    private TreeViewer treeViewer;

    public RunReportUnitAction(TreeViewer treeViewer) {
        this.setId(ID);
        this.setText(Messages.RunReportUnitAction_1);
        this.setDescription(Messages.RunReportUnitAction_2);
        this.setToolTipText(Messages.RunReportUnitAction_3);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/start_task.gif"));
        this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/start_task.gif"));
        this.treeViewer = treeViewer;
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.isRunnable();
    }

    private boolean isRunnable() {
        TreeSelection s = (TreeSelection)this.treeViewer.getSelection();
        TreePath[] p = s.getPaths();
        int i = 0;
        while (i < p.length) {
            if (!this.isInReportUnit(p[i].getLastSegment())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isInReportUnit(Object obj) {
        if (obj == null) {
            return false;
        }
        MReportUnit mrepunit = null;
        if (obj instanceof MReportUnit) {
            mrepunit = (MReportUnit)obj;
        } else if (((ANode)obj).getParent() instanceof MReportUnit) {
            mrepunit = (MReportUnit)((ANode)obj).getParent();
        }
        if (mrepunit == null) {
            return false;
        }
        int pmask = mrepunit.getValue().getPermissionMask(mrepunit.getWsClient());
        return pmask == 1 || (pmask & 0x20) == 32 || (pmask & 2) == 2;
    }

    public void run() {
        TreeSelection s = (TreeSelection)this.treeViewer.getSelection();
        TreePath[] p = s.getPaths();
        int i = 0;
        while (i < p.length) {
            Object obj = p[i].getLastSegment();
            if (obj instanceof AMResource) {
                String key;
                MReportUnit node = ((AMResource)((Object)obj)).getReportUnit();
                if (node == null || (key = ServerManager.getKey(node)) == null) break;
                Display.getDefault().asyncExec(() -> SelectionHelper.openEditor((String)key, (String)"com.jaspersoft.studio.server.editor.ReportUnitEditor"));
                break;
            }
            ++i;
        }
    }
}

