/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.action.server;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.server.Activator;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.action.server.EditServerAction;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.model.server.MServers;
import com.jaspersoft.studio.server.model.server.ServerProfile;
import com.jaspersoft.studio.server.wizard.ServerProfileWizard;
import com.jaspersoft.studio.server.wizard.ServerProfileWizardDialog;
import com.jaspersoft.studio.utils.BrandingInfo;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.cheatsheets.ICheatSheetAction;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;

public class CreateServerAction
extends Action
implements ICheatSheetAction {
    public static final String ID = "createServerAction";
    private TreeViewer treeViewer;
    private MServerProfile mservprof;

    public CreateServerAction() {
        this(null);
    }

    public CreateServerAction(TreeViewer treeViewer) {
        this.setId(ID);
        this.setText(Messages.CreateServerAction_title);
        this.setDescription(Messages.CreateServerAction_desc);
        this.setToolTipText(Messages.CreateServerAction_desc);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/server--plus.png"));
        this.treeViewer = treeViewer;
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public void run() {
        MRoot root = (MRoot)this.treeViewer.getInput();
        List lst = root.getChildren();
        for (INode n : lst) {
            if (!(n instanceof MServers)) continue;
            ServerProfile srv = new ServerProfile();
            srv.setName(this.getJRSProposedName());
            srv.setUrl(this.getJRSProposedURL());
            srv.setUser("username");
            srv.setSupportsDateRanges(true);
            ServerProfileWizard wizard = new ServerProfileWizard(new MServerProfile(null, srv));
            ServerProfileWizardDialog dialog = new ServerProfileWizardDialog(UIUtils.getShell(), (IWizard)wizard);
            wizard.bindTestButton(dialog);
            dialog.create();
            if (dialog.open() != 0) break;
            this.mservprof = wizard.getServerProfile();
            MServers rootServers = (MServers)n;
            MServerProfile newprofile = new MServerProfile(rootServers, this.mservprof.getValue());
            newprofile.setWsClient(this.mservprof.getWsClient());
            ServerManager.addServerProfile(newprofile);
            EditServerAction.fillServerProfile(newprofile, this.treeViewer);
            JaspersoftStudioPlugin.getInstance().getUsageManager().audit("CreatedJasperServerConnection", "JasperServer");
            break;
        }
    }

    public MServerProfile getNewServer() {
        return this.mservprof;
    }

    public void run(String[] params, ICheatSheetManager manager) {
        this.run();
        this.notifyResult(true);
    }

    private String getJRSProposedURL() {
        if (BrandingInfo.isProfessionalEdition()) {
            return "http://localhost:8080/jasperserver-pro/";
        }
        return "http://localhost:8080/jasperserver/";
    }

    private String getJRSProposedName() {
        if (BrandingInfo.isProfessionalEdition()) {
            return String.valueOf(Messages.CreateServerAction_name) + " Pro";
        }
        return Messages.CreateServerAction_name;
    }
}

