/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.action.server;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.server.Activator;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class DeleteServerAction
extends Action {
    public static final String ID = "com.jaspersoft.studio.server.action.resource.deleteServerAction";
    private TreeViewer treeViewer;

    public DeleteServerAction(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
        this.setId(ID);
        this.setText(Messages.common_delete);
        this.setDescription(com.jaspersoft.studio.server.messages.Messages.DeleteServerAction_desc);
        this.setToolTipText(com.jaspersoft.studio.server.messages.Messages.DeleteServerAction_desc);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/server--minus.png"));
    }

    public boolean isEnabled() {
        Object firstElement = ((TreeSelection)this.treeViewer.getSelection()).getFirstElement();
        return firstElement != null && firstElement instanceof MServerProfile;
    }

    public void run() {
        if (!UIUtils.showDeleteConfirmation()) {
            return;
        }
        final boolean delDir = UIUtils.showConfirmation((String)Messages.DeleteServerAction_1, (String)Messages.DeleteServerAction_2);
        TreeSelection s = (TreeSelection)this.treeViewer.getSelection();
        final TreePath[] p = s.getPaths();
        Job job = new Job(Messages.DeleteServerAction_1){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.DeleteServerAction_4, -1);
                try {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    int i = 0;
                    while (i < p.length) {
                        Object obj = p[i].getLastSegment();
                        if (obj instanceof MServerProfile) {
                            IResource r;
                            final MServerProfile msrv = (MServerProfile)((Object)obj);
                            if (delDir && msrv.getValue().getProjectPath() != null && (r = root.findMember(msrv.getValue().getProjectPath())) instanceof IFolder) {
                                try {
                                    r.delete(true, monitor);
                                }
                                catch (CoreException e) {
                                    UIUtils.showError((Throwable)e);
                                }
                            }
                            UIUtils.getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ServerManager.removeServerProfile(msrv);
                                    (this).DeleteServerAction.this.treeViewer.refresh(true);
                                }
                            });
                        }
                        ++i;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.schedule();
    }
}

