/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.dnd;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.editor.report.UnitTransfer;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.server.model.MInputControl;
import com.jaspersoft.studio.server.model.MReportUnit;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;

public class UnitDragSourceListener
implements TransferDragSourceListener {
    private StructuredViewer viewer;

    public UnitDragSourceListener(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void dragFinished(DragSourceEvent event) {
        if (!event.doit || event.detail != 2) {
            return;
        }
    }

    public void dragSetData(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        ArrayList<String> unitInfo = new ArrayList<String>();
        if (selection.getFirstElement() instanceof MReportUnit) {
            MReportUnit unit = (MReportUnit)selection.getFirstElement();
            ResourceDescriptor unitDescrtiptor = unit.getValue();
            unitInfo.add(unitDescrtiptor.getUriString());
            List childrens = unit.getChildren();
            for (INode children : childrens) {
                if (!(children instanceof MInputControl)) continue;
                ResourceDescriptor desc = (ResourceDescriptor)children.getValue();
                unitInfo.add(desc.getName());
            }
        }
        String[] gadgets = unitInfo.toArray(new String[unitInfo.size()]);
        if (UnitTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = gadgets;
        }
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        event.doit = !this.viewer.getSelection().isEmpty() && selection.getFirstElement() instanceof MReportUnit;
    }

    public Transfer getTransfer() {
        return UnitTransfer.getInstance();
    }
}

