/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.editor;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.server.ResourceFactory;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.protocol.IConnection;
import com.jaspersoft.studio.server.publish.PublishUtil;
import com.jaspersoft.studio.server.utils.ReferenceResolver;
import com.jaspersoft.studio.utils.CacheMap;
import com.jaspersoft.studio.utils.Callback;
import com.jaspersoft.studio.utils.jasper.JSSFileRepositoryService;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.repo.FileRepositoryService;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryService;
import net.sf.jasperreports.repo.Resource;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.ide.IDE;

public class JRSRepositoryService
implements RepositoryService {
    private JSSFileRepositoryService parent;
    private MServerProfile msp;
    private IConnection c;
    private String rpath;
    private String serverUri;
    private JasperDesign jDesign;
    private String runitUri;
    private JasperReportsConfiguration jConfig;
    private FileRepositoryService repService;
    private boolean isConnecting = false;
    private List<ResourceDescriptor> reportUnitResources = null;
    private CacheMap<String, String> negCache = new CacheMap(1000);
    private boolean isRefreshing = false;
    private boolean needNewRefresh = false;
    private Map<File, String> fileTypes = new HashMap<File, String>();
    private IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();

    public JRSRepositoryService(JSSFileRepositoryService parent, JasperReportsConfiguration jConfig) {
        this.parent = parent;
        this.jConfig = jConfig;
    }

    public FileRepositoryService getFileRepositoryService() {
        return this.repService;
    }

    private <K extends Resource> boolean hasServerUrl(String objuri, Class<K> resourceType) {
        String uri = null;
        String serverUser = null;
        if (this.jDesign == null) {
            this.jDesign = this.jConfig.getJasperDesign();
        }
        if (this.jDesign != null) {
            uri = this.jDesign.getProperty("ireport.jasperserver.url");
            if (uri == null) {
                return false;
            }
            serverUser = this.jDesign.getProperty("ireport.jasperserver.user");
            this.runitUri = this.jDesign.getProperty("ireport.jasperserver.reportUnit");
        } else {
            IFile f = (IFile)this.jConfig.get("ifile");
            if (f != null) {
                try {
                    List<String[]> paths = PublishUtil.loadPath((IProgressMonitor)new NullProgressMonitor(), f);
                    if (!Misc.isNullOrEmpty(paths)) {
                        uri = paths.get(0)[1];
                        if (paths.size() > 1) {
                            serverUser = paths.get(1)[1];
                        }
                    }
                    uri = f.getPersistentProperty(new QualifiedName("com.jaspersoft.studio.server", "ireport.jasperserver.url"));
                    serverUser = f.getPersistentProperty(new QualifiedName("com.jaspersoft.studio.server", "ireport.jasperserver.user"));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (uri == null) {
                uri = this.jConfig.getProperty("ireport.jasperserver.url");
                serverUser = this.jConfig.getProperty("ireport.jasperserver.user");
            }
            if (uri != null && serverUser != null) {
                String[] usrs = serverUser.split("\\|");
                if (usrs.length == 1) {
                    serverUser = usrs[0];
                } else if (usrs.length > 1 && Misc.isNullOrEmpty((String)usrs[1])) {
                    serverUser = usrs[0];
                }
            }
        }
        if (uri != null && !uri.equals(this.serverUri)) {
            this.serverUri = uri;
            this.c = null;
        }
        if (this.c == null && !this.isConnecting) {
            this.isConnecting = true;
            this.msp = ServerManager.getServerByUrl(this.serverUri, serverUser);
            if (this.msp != null) {
                this.setupConnection(this.msp.getWsClient((Callback<IConnection>)((Callback)value -> {
                    this.setupConnection((IConnection)value);
                    if (this.c != null) {
                        this.getResource(objuri, resourceType);
                    }
                })));
            }
        }
        return true;
    }

    private void setupConnection(IConnection conn) {
        this.c = conn;
        try {
            this.initRPath();
            if (this.rpath == null) {
                return;
            }
            try {
                List servs = this.parent.getRepositoryServices();
                if (this.repService != null) {
                    servs.remove(this.repService);
                }
                this.repService = new FileRepositoryService((JasperReportsContext)this.jConfig, this.rpath, true);
                int ind = servs.indexOf(this);
                servs.add(Math.max(0, Math.max(ind - 2, ind - 1)), this.repService);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            this.isConnecting = false;
        }
    }

    private void initRPath() throws IOException, CoreException {
        IContainer tmpDir = this.msp.getTempWorkspaceLocation((IProgressMonitor)new NullProgressMonitor());
        if (tmpDir.getRawLocation() != null) {
            this.rpath = tmpDir.getRawLocation().toOSString();
        } else if (tmpDir.getFullPath() != null) {
            this.rpath = tmpDir.getFullPath().toOSString();
        } else {
            IFile file = (IFile)this.jConfig.get("ifile");
            if (file != null) {
                this.rpath = file.getProject().getRawLocation().toOSString();
            }
        }
    }

    public Resource getResource(String uri) {
        return null;
    }

    public void saveResource(String uri, Resource resource) {
    }

    public synchronized <K extends Resource> K getResource(String uri, Class<K> resourceType) {
        K r;
        if (this.hasServerUrl(uri, resourceType) && this.c != null) {
            K r2;
            if (uri.startsWith("repo:") && (r2 = this.doGetResource(uri.startsWith("repo:") ? uri : "repo:" + uri, resourceType)) != null) {
                return r2;
            }
            return this.doGetResource(uri, resourceType);
        }
        if (this.c == null && uri.startsWith("repo:") && (r = this.doGetResource(uri.startsWith("repo:") ? uri : "repo:" + uri, resourceType)) != null) {
            return r;
        }
        return (K)(this.repService != null ? this.repService.getResource(uri, resourceType) : null);
    }

    private <K extends Resource> K addToCache(K res, String uri) {
        if (res == null) {
            this.negCache.put((Object)uri, null);
        }
        return res;
    }

    protected <K extends Resource> K doGetResource(String uri, Class<K> resourceType) {
        K r;
        if (this.negCache.containsKey((Object)uri)) {
            return null;
        }
        String objectUri = uri;
        if (uri.startsWith("repo:") && (r = this.getFromParent(objectUri = uri.substring(5), resourceType)) != null) {
            return this.addToCache(r, uri);
        }
        if (this.c != null) {
            try {
                NullProgressMonitor monitor = new NullProgressMonitor();
                if (objectUri.contains("/")) {
                    File f;
                    ResourceDescriptor r2 = new ResourceDescriptor();
                    r2.setUriString(objectUri);
                    r2 = this.c.get((IProgressMonitor)monitor, r2, null);
                    if (r2.getIsReference()) {
                        r2 = ReferenceResolver.resolveReference(this.c, r2, null);
                    }
                    if (this.rpath == null) {
                        this.initRPath();
                    }
                    String fpath = Misc.nvl((String)this.rpath);
                    if (!objectUri.startsWith("/")) {
                        fpath = String.valueOf(fpath) + "/";
                    }
                    if ((f = new File(fpath = String.valueOf(fpath) + objectUri)).getParentFile() != null) {
                        f.getParentFile().mkdirs();
                    }
                    if (f.createNewFile()) {
                        if (!r2.getIsReference() && r2.getHasData() && r2.getData() != null) {
                            FileUtils.writeByteArrayToFile((File)f, (byte[])r2.getData());
                        } else {
                            this.c.get((IProgressMonitor)monitor, r2, f);
                        }
                    }
                    this.fileTypes.put(f, r2.getWsType());
                } else if (this.runitUri != null) {
                    if (this.reportUnitResources == null) {
                        ResourceDescriptor rd = new ResourceDescriptor();
                        rd.setWsType("reportUnit");
                        rd.setUriString(this.runitUri);
                        rd = this.c.get((IProgressMonitor)monitor, rd, null);
                        this.reportUnitResources = this.c.list((IProgressMonitor)monitor, rd);
                        if (this.reportUnitResources == null) {
                            this.reportUnitResources = new ArrayList<ResourceDescriptor>();
                        }
                    }
                    for (ResourceDescriptor r2 : this.reportUnitResources) {
                        if (r2.getName() == null || !r2.getName().equals(objectUri)) continue;
                        if (r2.getIsReference()) {
                            r2 = ReferenceResolver.resolveReference(this.c, r2, (IProgressMonitor)monitor);
                        }
                        if (!ResourceFactory.isFileResourceType(r2)) continue;
                        IFile file = (IFile)this.jConfig.get("ifile");
                        File fp = null;
                        IContainer pf = file.getParent();
                        if (pf.getRawLocation() != null) {
                            fp = pf.getRawLocation().toFile();
                        } else if (pf.getLocationURI() != null) {
                            fp = new File(pf.getLocationURI());
                        } else {
                            return this.addToCache(null, uri);
                        }
                        File f = new File(fp, objectUri);
                        if (f.getParentFile() != null && !f.getParentFile().mkdirs() && f.createNewFile()) {
                            this.c.get((IProgressMonitor)monitor, r2, f);
                        }
                        this.fileTypes.put(f, r2.getWsType());
                        break;
                    }
                }
                this.refresh();
                String u = uri;
                if (u.startsWith("repo:")) {
                    u = u.substring(5);
                }
                return this.addToCache(this.getFromParent(u, resourceType), uri);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.addToCache(null, uri);
    }

    protected <K extends Resource> K getFromParent(String uri, Class<K> resourceType) {
        for (RepositoryService rs : this.parent.getRepositoryServices()) {
            if (rs == this) continue;
            try {
                Resource r = this.parent.doGetResource((RepositoryContext)SimpleRepositoryContext.of((JasperReportsContext)this.jConfig), uri, resourceType, rs);
                if (r == null) continue;
                return (K)r;
            }
            catch (JRRuntimeException jRRuntimeException) {}
        }
        return null;
    }

    private void refresh() {
        this.needNewRefresh = true;
        if (this.isRefreshing) {
            return;
        }
        this.isRefreshing = true;
        Job job = new Job(Messages.JRSRepositoryService_4){

            protected IStatus run(IProgressMonitor monitor) {
                block12: {
                    JRSRepositoryService.this.needNewRefresh = false;
                    try {
                        try {
                            IContainer tmpDir = JRSRepositoryService.this.msp.getTempWorkspaceLocation(monitor);
                            if (tmpDir != null) {
                                tmpDir.refreshLocal(2, monitor);
                            }
                            JRSRepositoryService.this.jConfig.getPropertyChangeSupport().firePropertyChange("RESOURCE_LOADED", true, false);
                            ArrayList<File> keys = new ArrayList<File>(JRSRepositoryService.this.fileTypes.keySet());
                            for (File f : keys) {
                                Object[] fs = JRSRepositoryService.this.root.findFilesForLocationURI(f.toURI());
                                if (Misc.isNullOrEmpty((Object[])fs)) continue;
                                Object[] objectArray = fs;
                                int n = fs.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object ifile = objectArray[n2];
                                    String id = null;
                                    String wsType = JRSRepositoryService.this.fileTypes.get(f);
                                    if (wsType.equals("jrtx")) {
                                        id = "com.jaspersoft.studio.JRtxEditor";
                                    } else if (wsType.equals("jrxml")) {
                                        id = "com.jaspersoft.studio.editor.JrxmlEditor";
                                    }
                                    if (id != null) {
                                        IDE.setDefaultEditor((IFile)ifile, (String)id);
                                    }
                                    JRSRepositoryService.this.fileTypes.remove(f);
                                    ++n2;
                                }
                            }
                        }
                        catch (Exception exception) {
                            JRSRepositoryService.this.isRefreshing = false;
                            UIUtils.getDisplay().asyncExec(() -> {
                                if (JRSRepositoryService.this.needNewRefresh) {
                                    JRSRepositoryService.this.refresh();
                                }
                            });
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        JRSRepositoryService.this.isRefreshing = false;
                        UIUtils.getDisplay().asyncExec(() -> {
                            if (JRSRepositoryService.this.needNewRefresh) {
                                JRSRepositoryService.this.refresh();
                            }
                        });
                        throw throwable;
                    }
                    JRSRepositoryService.this.isRefreshing = false;
                    UIUtils.getDisplay().asyncExec(() -> {
                        if (JRSRepositoryService.this.needNewRefresh) {
                            JRSRepositoryService.this.refresh();
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.setSystem(true);
        job.schedule(2000L);
    }
}

