/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.editor.input;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.server.editor.input.InputControlsManager;
import com.jaspersoft.studio.server.protocol.IConnection;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class PResourceDescriptor
implements IParameter {
    private ResourceDescriptor p;
    private InputControlsManager icm;

    public PResourceDescriptor(ResourceDescriptor p, InputControlsManager icm) {
        this.p = p;
        this.icm = icm;
    }

    public void setResourceDescriptor(ResourceDescriptor p) {
        this.p = p;
    }

    public String getName() {
        return this.p.getName();
    }

    public String getLabel() {
        return this.p.getLabel();
    }

    public boolean isMandatory() {
        return this.p.isMandatory();
    }

    public boolean isReadOnly() {
        return this.p.isReadOnly();
    }

    public Class<?> getValueClass() {
        try {
            return this.getValueClass(this.p);
        }
        catch (Exception e) {
            UIUtils.showError((Throwable)e);
            return null;
        }
    }

    public ResourceDescriptor getResourceDescriptor() {
        return this.p;
    }

    public IConnection getWsClient() {
        return this.icm.getWsClient();
    }

    public String getDescription() {
        return this.p.getDescription();
    }

    private Class<?> getValueClass(ResourceDescriptor rd) throws Exception {
        if (rd.getControlType() == 2) {
            ResourceDescriptor rdtype = rd.getChildren().get(0);
            if (rdtype.getWsType().equals("reference")) {
                ResourceDescriptor tmpRd = new ResourceDescriptor();
                tmpRd.setUriString(rdtype.getReferenceUri());
                rdtype = this.getWsClient().get((IProgressMonitor)new NullProgressMonitor(), tmpRd, null);
            }
            if (rdtype != null) {
                if (rdtype.getDataType() == 3) {
                    return Date.class;
                }
                if (rdtype.getDataType() == 4) {
                    return Timestamp.class;
                }
                if (rdtype.getDataType() == 1) {
                    return String.class;
                }
                if (rdtype.getDataType() == 2) {
                    return BigDecimal.class;
                }
            }
        } else {
            if (rd.getControlType() == 1) {
                return Boolean.class;
            }
            if (InputControlsManager.isICListOfValues(rd)) {
                return List.class;
            }
            if (InputControlsManager.isICQuery(rd)) {
                return ResourceDescriptor.class;
            }
        }
        return rd.getClass();
    }

    public boolean isStrictMin() {
        return this.p.isStrictMin();
    }

    public String getMinValue() {
        return this.p.getMinValue();
    }

    public boolean isStrictMax() {
        return this.p.isStrictMax();
    }

    public String getMaxValue() {
        return this.p.getMaxValue();
    }

    public String getPattern() {
        return this.p.getPattern();
    }
}

