/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.editor.input;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.editor.preview.input.IDataInput;
import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.editor.preview.view.control.AVParameters;
import com.jaspersoft.studio.editor.preview.view.control.ReportController;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.server.Activator;
import com.jaspersoft.studio.server.editor.input.DateInput;
import com.jaspersoft.studio.server.editor.input.IInputControls;
import com.jaspersoft.studio.server.editor.input.InputControlsManager;
import com.jaspersoft.studio.server.editor.input.PResourceDescriptor;
import com.jaspersoft.studio.server.editor.input.lov.ListOfValuesInput;
import com.jaspersoft.studio.server.editor.input.query.QueryInput;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class VInputControls
extends AVParameters {
    private List<IDataInput> inputs = new ArrayList<IDataInput>();
    private InputControlsManager icm;
    private ResourceDescriptor rdrepunit;
    private String type = "reportUnit";
    private String uri;
    private Set<Control> toIgnore = new HashSet<Control>();
    private String key;
    private boolean hasOptions = false;
    private List<IInputControls> controls;

    public VInputControls(Composite parent, JasperReportsConfiguration jContext) {
        super(parent, jContext);
        this.inputs.add((IDataInput)new DateInput());
        this.inputs.add((IDataInput)new ListOfValuesInput());
        this.inputs.add((IDataInput)new QueryInput());
        this.inputs.addAll(ReportController.inputs);
    }

    public InputControlsManager getIcm() {
        return this.icm;
    }

    public String getUri() {
        return this.uri;
    }

    public String getType() {
        return this.type;
    }

    public Set<Control> getToIgnore() {
        return this.toIgnore;
    }

    public String getKey() {
        return this.key;
    }

    public void setReportUnit(InputControlsManager icm, ResourceDescriptor rdrepunit, IProgressMonitor monitor, String key) {
        if (this.rdrepunit == rdrepunit) {
            return;
        }
        this.rdrepunit = rdrepunit;
        this.icm = icm;
        this.key = key;
        this.uri = rdrepunit.getUriString();
        this.type = rdrepunit.getWsType();
        this.initICOptions(icm, rdrepunit, monitor);
    }

    public void createInputControls(InputControlsManager icm, IProgressMonitor monitor) {
        this.icm = icm;
        for (IDataInput di : icm.getControls()) {
            di.dispose();
        }
        icm.getControls().clear();
        Control[] controlArray = this.composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (!this.toIgnore.contains(c)) {
                c.dispose();
            }
            ++n2;
        }
        if (!this.hasOptions) {
            this.createControl(this.composite, this);
            this.hasOptions = true;
        }
        boolean first = true;
        for (ResourceDescriptor p : icm.getInputControls()) {
            if (!p.isVisible()) continue;
            try {
                boolean created = this.createInput(this.composite, p, icm, first);
                if (!first || !created) continue;
                first = false;
            }
            catch (Exception e) {
                if (e instanceof ClassNotFoundException) continue;
                e.printStackTrace();
            }
        }
        if (this.showEmptyParametersWarning) {
            this.setDirty(false);
        }
        this.showEmptyParametersWarning = false;
        this.refreshControl();
    }

    public void setupDefaultValues(IProgressMonitor monitor) throws Exception {
        monitor.subTask(Messages.VParameters_resetparameters);
        this.rdrepunit = this.icm.getWsClient().initInputControls(this.uri, this.type, monitor);
        this.setReportUnit(this.icm, this.rdrepunit, monitor, this.key);
        this.icm.initInputControls(this.rdrepunit);
        UIUtils.getDisplay().syncExec(() -> this.createInputControls(this.icm, monitor));
    }

    public boolean checkFieldsFilled() {
        if (this.icm.isAnyVisible()) {
            Boolean rAlwaysPrompt = (Boolean)Misc.nvl((Object)this.rdrepunit.getResourcePropertyValueAsBoolean("PROP_RU_ALWAYS_PROPMT_CONTROLS"), (Object)false);
            boolean hasDirty = false;
            for (ResourceDescriptor p : this.icm.getInputControls()) {
                String pname = p.getName();
                if (!p.isVisible() || p.isReadOnly() || !this.incontrols.containsKey(pname)) continue;
                if (((IDataInput)this.incontrols.get(pname)).isDirty()) {
                    hasDirty = true;
                }
                if (!p.isMandatory() || !this.icm.getParameters().containsKey(pname) || hasDirty) continue;
                return false;
            }
            if (rAlwaysPrompt.booleanValue() && !hasDirty) {
                return false;
            }
        }
        return true;
    }

    protected boolean createInput(Composite sectionClient, ResourceDescriptor p, InputControlsManager icm, boolean first) {
        PResourceDescriptor pres = new PResourceDescriptor(p, icm);
        Class<?> vclass = pres.getValueClass();
        if (vclass != null) {
            for (IDataInput in : this.inputs) {
                if (!in.isForType(vclass)) continue;
                in = in.getInstance();
                this.incontrols.put(p.getName(), in);
                this.createVerticalSeprator(first);
                this.createLabel(sectionClient, pres, in);
                in.createInput(sectionClient, (IParameter)pres, icm.getParameters());
                if (InputControlsManager.isICSingle(p) && p.getValue() != null) {
                    in.updateModel(p.getValue());
                    in.updateInput();
                }
                in.addChangeListener(icm.getPropertyChangeListener());
                icm.getControls().add(in);
                return true;
            }
        }
        return false;
    }

    public String getToolTip(IParameter param) {
        String tt = super.getToolTip(param);
        if (param instanceof PResourceDescriptor) {
            tt = String.valueOf(tt) + "\n" + ((PResourceDescriptor)param).getResourceDescriptor().getUriString();
        }
        return tt;
    }

    public void updateInputControls(IProgressMonitor monitor) throws Exception {
        ResourceDescriptor rd = this.getICContainerUri(this.uri);
        monitor.subTask(Messages.VInputControls_0);
        rd = this.icm.getWsClient().initInputControls(rd.getUriString(), rd.getWsType(), monitor);
        this.icm.initInputControls(rd);
        this.icm.getDefaults();
        UIUtils.getDisplay().syncExec(() -> this.createInputControls(this.icm, monitor));
    }

    public void createControl(Composite composite, VInputControls icForm) {
        for (IInputControls r : this.getExtensionManager()) {
            r.createControl(composite, icForm);
        }
    }

    public ResourceDescriptor getICContainerUri(String uri) {
        ResourceDescriptor rd = null;
        for (IInputControls r : this.getExtensionManager()) {
            rd = r.getICContainerUri(uri);
        }
        return rd;
    }

    public void initICOptions(InputControlsManager icm, ResourceDescriptor rdrepunit, IProgressMonitor monitor) {
        for (IInputControls r : this.getExtensionManager()) {
            r.initICOptions(icm, rdrepunit, monitor);
        }
    }

    private List<IInputControls> getExtensionManager() {
        if (this.controls == null) {
            this.controls = Activator.getExtManager().getInstance();
        }
        return this.controls;
    }
}

