/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.editor.input.lov;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ListItem;
import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.server.editor.input.IInput;
import com.jaspersoft.studio.server.editor.input.lov.ListOfValuesInput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ListInput
implements IInput {
    private ListOfValuesInput dataInput;
    private Map<String, Object> params;
    private IParameter param;
    private Combo combo;
    private List<ListItem> items;

    public ListInput(ListOfValuesInput dataInput, IParameter param, Map<String, Object> params) {
        this.dataInput = dataInput;
        this.param = param;
        this.params = params;
    }

    @Override
    public void createControl(Composite parent, int style) {
        this.combo = new Combo(parent, 2060);
        GridData gd = new GridData(768);
        gd.horizontalIndent = 8;
        gd.minimumHeight = 100;
        this.combo.setLayoutData((Object)gd);
        this.fillControl();
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int ti = ListInput.this.combo.getSelectionIndex();
                if (ti >= 0 && ti < ListInput.this.items.size()) {
                    ListInput.this.dataInput.updateModel(ListInput.this.items.get(ti).getValue());
                }
            }
        };
        this.combo.addSelectionListener((SelectionListener)listener);
        this.updateInput();
        listener.widgetSelected(null);
    }

    @Override
    public void fillControl() {
        this.items = this.dataInput.getRd().getListOfValues();
        this.combo.removeAll();
        if (this.items != null) {
            ArrayList<Object> toSel = new ArrayList<Object>();
            String[] citems = new String[this.items.size()];
            int i = 0;
            while (i < this.items.size()) {
                ListItem li = this.items.get(i);
                citems[i] = li.getLabel();
                if (li.isSelected()) {
                    toSel.add(li.getValue());
                }
                ++i;
            }
            this.params.put(this.param.getName(), toSel);
            this.combo.setItems(citems);
        }
    }

    @Override
    public void updateInput() {
        Object value = this.params.get(this.param.getName());
        if (value != null) {
            if (value instanceof List && !((List)value).isEmpty()) {
                value = ((List)value).get(0);
            }
            int i = 0;
            while (i < this.items.size()) {
                if (this.items.get(i).getValue().equals(value)) {
                    this.combo.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public Control getControl() {
        return this.combo;
    }
}

