/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.editor.input.lov;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ListItem;
import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.server.editor.input.IInput;
import com.jaspersoft.studio.server.editor.input.lov.ListOfValuesInput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableInput
implements IInput {
    private Table table;
    private ListOfValuesInput dataInput;
    private Map<String, Object> params;
    private IParameter param;

    public TableInput(ListOfValuesInput dataInput, IParameter param, Map<String, Object> params) {
        this.dataInput = dataInput;
        this.param = param;
        this.params = params;
    }

    @Override
    public void createControl(Composite parent, int style) {
        this.table = new Table(parent, style | 0x200 | 0x100 | 0x800 | 0x10000);
        GridData gd = new GridData(768);
        gd.horizontalIndent = 8;
        gd.minimumHeight = 100;
        this.table.setLayoutData((Object)gd);
        this.fillControl();
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] ti = TableInput.this.table.getSelection();
                if (TableInput.this.dataInput.getRd().getControlType() == 10) {
                    TableInput.this.doUpdateModel(com.jaspersoft.studio.server.editor.input.query.TableInput.getCheckedElements(TableInput.this.table));
                } else if (TableInput.this.dataInput.getRd().getControlType() == 6) {
                    TableInput.this.doUpdateModel(ti);
                } else if (ti.length > 0) {
                    TableInput.this.dataInput.updateModel(ti[0].getData());
                }
            }
        };
        this.table.addSelectionListener((SelectionListener)listener);
        this.updateInput();
        listener.widgetSelected(null);
    }

    private void doUpdateModel(TableItem[] ti) {
        ArrayList<Object> lst = new ArrayList<Object>();
        TableItem[] tableItemArray = ti;
        int n = ti.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            lst.add(item.getData());
            ++n2;
        }
        this.dataInput.updateModel(lst);
    }

    @Override
    public void fillControl() {
        List<ListItem> items = this.dataInput.getRd().getListOfValues();
        this.table.removeAll();
        ArrayList<Object> toSel = new ArrayList<Object>();
        for (ListItem item : items) {
            TableItem ti = new TableItem(this.table, 0);
            ti.setText(item.getLabel());
            ti.setData(item.getValue());
            if (!item.isSelected()) continue;
            toSel.add(item.getValue());
        }
        this.params.put(this.param.getName(), toSel);
        if (items.size() > 4) {
            ((GridData)this.table.getLayoutData()).heightHint = 100;
        }
        this.table.getParent().layout();
    }

    @Override
    public void updateInput() {
        Object value = this.params.get(this.param.getName());
        if (value != null) {
            byte ct = this.dataInput.getRd().getControlType();
            if (ct == 6 || ct == 10) {
                if (value instanceof List) {
                    ArrayList<TableItem> titems = new ArrayList<TableItem>();
                    List lst = (List)value;
                    TableItem[] tableItemArray = this.table.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem ti = tableItemArray[n2];
                        if (lst.contains(ti.getData())) {
                            titems.add(ti);
                            if (ct == 10) {
                                ti.setChecked(true);
                            }
                        }
                        ++n2;
                    }
                    this.table.setSelection(titems.toArray(new TableItem[titems.size()]));
                }
            } else {
                if (value instanceof List && !((List)value).isEmpty()) {
                    value = ((List)value).get(0);
                }
                TableItem[] tableItemArray = this.table.getItems();
                int n = tableItemArray.length;
                int n3 = 0;
                while (n3 < n) {
                    TableItem ti = tableItemArray[n3];
                    if (ti.getData().equals(value)) {
                        this.table.setSelection(ti);
                        break;
                    }
                    ++n3;
                }
            }
        }
    }

    @Override
    public Control getControl() {
        return this.table;
    }
}

