/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.export;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.server.export.AExporter;
import com.jaspersoft.studio.server.model.AMResource;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class ImageExporter
extends AExporter {
    public ImageExporter(IPath path) {
        super(path);
    }

    @Override
    public IFile exportToIFile(AMResource res, ResourceDescriptor rd, String fkeyname, IProgressMonitor monitor) throws Exception {
        IFile f = super.exportToIFile(res, rd, fkeyname, monitor);
        if (this.path == null && f != null) {
            ImageTypeEnum itype;
            String filename = f.getFullPath().toOSString();
            int dotPos = filename.lastIndexOf(".");
            if (dotPos >= 0) {
                filename = filename.substring(0, dotPos);
            }
            if ((itype = JRTypeSniffer.getImageTypeValue((byte[])FileUtils.getBytes((IFile)f))) == ImageTypeEnum.UNKNOWN) {
                itype = ImageTypeEnum.PNG;
            }
            if (itype == ImageTypeEnum.GIF) {
                f = FileUtils.fileRenamed((IFile)f, (String)filename, (String)".gif", (boolean)false, (IProgressMonitor)monitor);
            } else if (itype == ImageTypeEnum.JPEG) {
                f = FileUtils.fileRenamed((IFile)f, (String)filename, (String)".jpeg", (boolean)false, (IProgressMonitor)monitor);
            } else if (itype == ImageTypeEnum.PNG) {
                f = FileUtils.fileRenamed((IFile)f, (String)filename, (String)".png", (boolean)false, (IProgressMonitor)monitor);
            } else if (itype == ImageTypeEnum.TIFF) {
                f = FileUtils.fileRenamed((IFile)f, (String)filename, (String)".tiff", (boolean)false, (IProgressMonitor)monitor);
            }
            fileurimap.put(fkeyname, f);
        }
        return f;
    }

    @Override
    public String getExtension(AMResource res) {
        return "";
    }
}

