/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.model;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.server.model.AMResource;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;

public abstract class AFileResource
extends AMResource {
    public static final long serialVersionUID = 10200L;
    private File file;

    public AFileResource(ANode parent, ResourceDescriptor rd, int index) {
        super(parent, rd, index);
    }

    public abstract String getDefaultFileExtension();

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        if (file != null) {
            try {
                this.getValue().setFile(file);
                this.getValue().setData(Base64.encodeBase64((byte[])net.sf.jasperreports.eclipse.util.FileUtils.getBytes((File)file)));
                this.getValue().setHasData(true);
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.getValue().setData(null);
        this.getValue().setHasData(false);
    }

    public String getHFFileSize() {
        if (this.file != null && this.file.exists()) {
            return FileUtils.byteCountToDisplaySize((long)this.file.length());
        }
        return "";
    }

    public String getFileName() {
        if (this.file != null) {
            try {
                return this.file.getCanonicalPath();
            }
            catch (IOException e) {
                UIUtils.showError((Throwable)e);
            }
        }
        return "";
    }

    @Override
    public String getJRSUrl() throws UnsupportedEncodingException {
        return "flow.html?_flowId=addFileResourceFlow&selectedResource=" + URLEncoder.encode(this.getValue().getUriString(), "ISO-8859-1") + "&ParentFolderUri=" + URLEncoder.encode(this.getValue().getParentFolder(), "ISO-8859-1");
    }
}

