/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.plugin;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.dto.resources.ClientResource;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.server.editor.input.IInputControls;
import com.jaspersoft.studio.server.model.AMJrxmlContainer;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.plugin.IPublishContributor;
import com.jaspersoft.studio.server.plugin.IResourceFactory;
import com.jaspersoft.studio.server.protocol.IConnection;
import com.jaspersoft.studio.server.protocol.restv2.ARestV2Connection;
import com.jaspersoft.studio.server.protocol.restv2.WsTypes;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizardPage;

public class ExtensionManager {
    private List<IResourceFactory> resources = new ArrayList<IResourceFactory>();
    private List<IConnection> protocols = new ArrayList<IConnection>();
    private List<IInputControls> inputcontrol = new ArrayList<IInputControls>();
    private Map<JasperReportsConfiguration, List<IPublishContributor>> publisher = new HashMap<JasperReportsConfiguration, List<IPublishContributor>>();

    public void init() {
        Object o;
        IConfigurationElement e;
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("com.jaspersoft.studio.server", "resources");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            e = iConfigurationElementArray[n2];
            try {
                o = e.createExecutableExtension("ClassFactory");
                if (o instanceof IResourceFactory) {
                    this.resources.add((IResourceFactory)o);
                }
            }
            catch (CoreException ex) {
                System.out.println(ex.getMessage());
            }
            ++n2;
        }
        iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("com.jaspersoft.studio.server", "protocols");
        n = config.length;
        n2 = 0;
        while (n2 < n) {
            e = iConfigurationElementArray[n2];
            try {
                o = e.createExecutableExtension("ClassFactory");
                if (o instanceof IConnection) {
                    this.protocols.add((IConnection)o);
                }
            }
            catch (CoreException ex) {
                System.out.println(ex.getMessage());
            }
            ++n2;
        }
        iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("com.jaspersoft.studio.server", "inputcontrol");
        n = config.length;
        n2 = 0;
        while (n2 < n) {
            e = iConfigurationElementArray[n2];
            try {
                o = e.createExecutableExtension("ClassFactory");
                if (o instanceof IInputControls) {
                    this.inputcontrol.add((IInputControls)o);
                }
            }
            catch (CoreException ex) {
                System.out.println(ex.getMessage());
            }
            ++n2;
        }
    }

    public List<IPublishContributor> getPublisher(JasperReportsConfiguration jrConfig) {
        List<IPublishContributor> p = this.publisher.get(jrConfig);
        if (p == null) {
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("com.jaspersoft.studio.server", "publisher");
            p = new ArrayList<IPublishContributor>();
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                try {
                    Object o = e.createExecutableExtension("ClassFactory");
                    if (o instanceof IPublishContributor) {
                        ((IPublishContributor)o).init(jrConfig);
                        p.add((IPublishContributor)o);
                    }
                }
                catch (CoreException ex) {
                    System.out.println(ex.getMessage());
                }
                ++n2;
            }
            this.publisher.put(jrConfig, p);
        }
        return p;
    }

    public void publishJrxml(JasperReportsConfiguration jrConfig, AMJrxmlContainer mrunit, IProgressMonitor monitor, JasperDesign jasper, Set<String> fileset, IFile file, String version) throws Exception {
        for (IPublishContributor r : this.getPublisher(jrConfig)) {
            r.publishJrxml(mrunit, monitor, jasper, fileset, file, version);
        }
    }

    public void publishComponent(JasperReportsConfiguration jrConfig, AMJrxmlContainer mrunit, IProgressMonitor monitor, JasperDesign jasper, Set<String> fileset, IFile file, JRDesignElement ele, String version) throws Exception {
        for (IPublishContributor r : this.getPublisher(jrConfig)) {
            r.publishComponent(mrunit, monitor, jasper, fileset, file, ele, version);
        }
    }

    public void publishParameters(JasperReportsConfiguration jrConfig, MReportUnit mrunit, IProgressMonitor monitor, JasperDesign jasper) throws Exception {
        for (IPublishContributor r : this.getPublisher(jrConfig)) {
            r.publishParameters(mrunit, monitor, jasper);
        }
    }

    public AMResource getResource(ANode parent, ResourceDescriptor resource, int index) {
        for (IResourceFactory r : this.resources) {
            AMResource mr = r.getResource(parent, resource, index);
            if (mr == null) continue;
            return mr;
        }
        return null;
    }

    public IWizardPage[] getResourcePage(ANode parent, AMResource resource) {
        for (IResourceFactory r : this.resources) {
            IWizardPage[] mr = r.getResourcePage(parent, resource);
            if (mr == null) continue;
            return mr;
        }
        return null;
    }

    public List<IConnection> getProtocols() {
        ArrayList<IConnection> cons = new ArrayList<IConnection>();
        for (IConnection p : this.protocols) {
            try {
                if (p == null) continue;
                cons.add((IConnection)p.getClass().newInstance());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return cons;
    }

    public ANode createNewResource(ANode root, ANode parent) {
        for (IResourceFactory r : this.resources) {
            r.createNewResource(root, parent);
        }
        return null;
    }

    public ANode createNewDatasource(ANode root, ANode parent) {
        for (IResourceFactory r : this.resources) {
            r.createNewDatasource(root, parent);
        }
        return null;
    }

    public void initWsTypes(WsTypes wsType) {
        for (IResourceFactory r : this.resources) {
            r.initWsTypes(wsType);
        }
    }

    public void initContainers(Set<Class<? extends ClientResource<?>>> containers) {
        for (IResourceFactory r : this.resources) {
            r.initContainers(containers);
        }
    }

    public ResourceDescriptor getRD(ARestV2Connection rc, ClientResource<?> cr, ResourceDescriptor rd) throws ParseException {
        for (IResourceFactory r : this.resources) {
            ResourceDescriptor nrd = r.getRD(rc, cr, rd);
            if (nrd == null) continue;
            return nrd;
        }
        return null;
    }

    public ClientResource<?> getResource(ARestV2Connection rc, ClientResource<?> cr, ResourceDescriptor rd) throws ParseException {
        for (IResourceFactory r : this.resources) {
            ClientResource<?> nrd = r.getResource(rc, cr, rd);
            if (nrd == null) continue;
            return nrd;
        }
        return null;
    }

    public List<IInputControls> getInstance() {
        ArrayList<IInputControls> controls = new ArrayList<IInputControls>();
        for (IInputControls r : this.inputcontrol) {
            controls.add(r.getInstance());
        }
        return controls;
    }
}

