/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.preferences;

import com.jaspersoft.studio.help.TableHelpListener;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.editor.table.TableFieldEditor;
import com.jaspersoft.studio.server.preferences.SSOServer;
import com.jaspersoft.studio.server.preferences.SSOTypes;
import com.jaspersoft.studio.swt.widgets.WSecretText;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.CastorHelper;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.SecureStorageUtils;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.exolab.castor.mapping.Mapping;
import org.xml.sax.InputSource;

public class CASListFieldEditor
extends TableFieldEditor {
    protected Button editButton;
    private List<SSOServer> items = new ArrayList<SSOServer>();
    public static Mapping mapping = new Mapping();

    static {
        mapping.loadMapping(new InputSource(CASListFieldEditor.class.getResourceAsStream("/com/jaspersoft/studio/server/preferences/SSOServer.xml")));
    }

    public CASListFieldEditor() {
    }

    public CASListFieldEditor(String name, Composite parent) {
        super(name, "", new String[]{"Type", "SSO Server"}, new int[]{50, 300}, parent);
    }

    protected String createList(String[][] items) {
        return "";
    }

    protected String[][] parseString(String string) {
        return new String[0][0];
    }

    protected String[] getNewInputObject() {
        PEditDialog dialog = new PEditDialog(UIUtils.getShell(), new SSOServer());
        if (dialog.open() == 0) {
            SSOServer srv = dialog.getValue();
            this.items.add(srv);
            return new String[]{srv.getType().name(), srv.getUrl()};
        }
        return null;
    }

    public static Mapping getMapping() {
        return mapping;
    }

    protected void doStore() {
        String v = "";
        for (SSOServer srv : this.items) {
            v = String.valueOf(v) + Base64.encodeBase64String((byte[])CastorHelper.write((Object)srv, (Mapping)mapping).getBytes()) + "\n";
            try {
                if (srv.getPassuuid() == null) continue;
                SecureStorageUtils.saveToDefaultSecurePreferences((String)"com.jaspersoft.studio.jrserver", (String)srv.getPassuuid(), (String)srv.getPassword());
            }
            catch (StorageException e) {
                e.printStackTrace();
            }
        }
        this.getPreferenceStore().setValue("com.jaspersoft.studio.server.sso", v);
    }

    protected void doLoad() {
        if (this.getTable() != null) {
            this.items.clear();
            String v = null;
            v = this.getPreferenceStore().getString("com.jaspersoft.studio.server.sso");
            String[] stringArray = v.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (!line.isEmpty()) {
                    try {
                        SSOServer srv = (SSOServer)CastorHelper.read((InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)line)), (Mapping)mapping);
                        this.items.add(srv);
                        TableItem tableItem = new TableItem(this.getTable(), 0);
                        tableItem.setText(new String[]{srv.getType().name(), srv.getUrl()});
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
            TableHelpListener.setTableHelp((Table)this.getTable());
        }
    }

    protected void doLoadDefault() {
    }

    protected void adjustForNumColumns(int numColumns) {
        super.adjustForNumColumns(numColumns);
        ((GridData)this.getLabelControl().getLayoutData()).exclude = true;
        this.getLabelControl().setVisible(false);
    }

    protected boolean isFieldEditable(int col, int row) {
        return false;
    }

    protected void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, ContextHelpIDs.PREFERENCES_PROPERTIES);
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == CASListFieldEditor.this.addButton) {
                    CASListFieldEditor.this.addPressed();
                } else if (widget == CASListFieldEditor.this.duplicateButton) {
                    CASListFieldEditor.this.duplicatePressed();
                } else if (widget == CASListFieldEditor.this.removeButton) {
                    CASListFieldEditor.this.removePressed();
                } else if (widget == CASListFieldEditor.this.editButton) {
                    CASListFieldEditor.this.editPressed();
                } else if (widget == CASListFieldEditor.this.table) {
                    CASListFieldEditor.this.selectionChanged();
                }
            }
        };
    }

    protected Button createPushButton(Composite parent, String key) {
        if (key.equals(Messages.common_duplicate)) {
            return null;
        }
        return super.createPushButton(parent, key);
    }

    protected void handleTableDoubleClick() {
        this.editPressed();
    }

    protected void removePressed() {
        int selIdx = this.table.getSelectionIndex();
        if (selIdx >= 0) {
            this.items.remove(selIdx);
        }
        super.removePressed();
    }

    private void editPressed() {
        int selIdx = this.table.getSelectionIndex();
        if (selIdx != -1) {
            TableItem item = this.table.getItem(selIdx);
            SSOServer srv = this.items.get(selIdx).clone();
            PEditDialog dialog = new PEditDialog(UIUtils.getShell(), srv);
            if (dialog.open() == 0) {
                srv = dialog.getValue();
                this.items.set(selIdx, srv);
                item.setText(0, srv.getType().name());
                item.setText(1, srv.getUrl());
            }
        }
    }

    protected void selectionChanged() {
        boolean isMultiSelection;
        super.selectionChanged();
        int index = this.table.getSelectionIndex();
        int size = this.table.getItemCount();
        boolean bl = isMultiSelection = this.table.getSelectionCount() > 1;
        if (this.editButton != null) {
            this.editButton.setEnabled(!isMultiSelection && size >= 1 && index >= 0 && index < size && this.isEditable(index));
        }
    }

    protected boolean isEditable(int row) {
        return true;
    }

    protected void createButtons(Composite box) {
        this.addButton = this.createPushButton(box, Messages.common_add);
        this.duplicateButton = this.createPushButton(box, Messages.PropertyListFieldEditor_duplicateButton);
        this.removeButton = this.createPushButton(box, Messages.common_delete);
        this.editButton = this.createPushButton(box, Messages.common_edit);
    }

    private class PEditDialog
    extends ATitledDialog {
        private SSOServer value;
        private WSecretText tpass;

        protected PEditDialog(Shell parentShell, SSOServer value) {
            super(parentShell);
            this.value = value;
            this.setTitle("SSO Server");
            this.setDefaultSize(500, 300);
        }

        public SSOServer getValue() {
            return this.value;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            composite.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(composite, 0);
            label.setText("Type");
            final Combo type = new Combo(composite, 12);
            type.setItems(SSOTypes.getLabels());
            type.select(SSOTypes.getIndex(this.value.getType()));
            type.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PEditDialog.this.value.setType(SSOTypes.valueOf(type.getText()));
                }
            });
            label = new Label(composite, 0);
            label.setText("URL");
            final Text turi = new Text(composite, 2048);
            turi.setLayoutData((Object)new GridData(768));
            turi.setText(Misc.nvl((String)this.value.getUrl()));
            turi.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PEditDialog.this.value.setUrl(turi.getText());
                    PEditDialog.this.getButton(0).setEnabled(!Misc.isNullOrEmpty((String)PEditDialog.this.value.getUrl()));
                }
            });
            label = new Label(composite, 0);
            label.setText("Username");
            final Text tname = new Text(composite, 2048);
            tname.setLayoutData((Object)new GridData(768));
            tname.setText(Misc.nvl((String)this.value.getUser()));
            tname.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PEditDialog.this.value.setUser(tname.getText());
                }
            });
            label = new Label(composite, 0);
            label.setText("Password");
            this.tpass = new WSecretText(composite, 0x400800);
            this.tpass.loadSecret("com.jaspersoft.studio.jrserver", Misc.nvl((String)this.value.getPassword()));
            this.tpass.setLayoutData((Object)new GridData(768));
            this.tpass.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PEditDialog.this.value.setPassword(PEditDialog.this.tpass.getText());
                    PEditDialog.this.value.setPassuuid(PEditDialog.this.tpass.getUUIDKey());
                }
            });
            PEditDialog.applyDialogFont((Control)composite);
            UIUtils.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PEditDialog.this.getButton(0).setEnabled(!Misc.isNullOrEmpty((String)PEditDialog.this.value.getUrl()));
                }
            });
            return composite;
        }
    }
}

