/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.preferences;

import com.jaspersoft.studio.jface.dialogs.NameDialog;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.server.protocol.restv2.CertChainValidator;
import com.jaspersoft.studio.server.protocol.restv2.CertificateDialog;
import com.jaspersoft.studio.utils.UIUtil;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class KeyStorePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "com.jaspersoft.studio.server.preferences.KeyStorePreferencePage";
    private TreeViewer treeviewer;
    private KeyStore trustStore;
    private Map<String, Certificates> aliases = new HashMap<String, Certificates>();
    private List<Certificates> certificates = new ArrayList<Certificates>();

    public KeyStorePreferencePage() {
        super("Client Authentication Key Store");
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(final Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(2, false));
        cmp.setFont(parent.getFont());
        Tree wtree = new Tree(cmp, 68098);
        GridData gd = new GridData(768);
        gd.heightHint = 70;
        wtree.setLayoutData((Object)gd);
        this.treeviewer = new TreeViewer(wtree);
        this.treeviewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public boolean hasChildren(Object element) {
                return element instanceof Certificates;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object element) {
                return this.getChildren(element);
            }

            public Object[] getChildren(Object element) {
                if (element instanceof Collection) {
                    return ((Collection)element).toArray();
                }
                if (element instanceof Certificates) {
                    ArrayList<Serializable> res = new ArrayList<Serializable>();
                    if (((Certificates)element).key != null) {
                        res.add(((Certificates)element).key);
                    }
                    if (((Certificates)element).chain != null) {
                        res.addAll(Arrays.asList(((Certificates)element).chain));
                    }
                    return res.toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.treeviewer.setLabelProvider((IBaseLabelProvider)new CertificateDialog.CertificateLabelProvider());
        UIUtil.setViewerCellEditingOnDblClick((TreeViewer)this.treeviewer);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeviewer, (int)2);
        this.treeviewer.setInput(this.certificates);
        this.treeviewer.expandAll();
        Composite bcmp = new Composite(cmp, 0);
        bcmp.setLayout((Layout)new GridLayout());
        gd = new GridData(2);
        gd.verticalSpan = 2;
        bcmp.setLayoutData((Object)gd);
        Button nb = new Button(bcmp, 8);
        nb.setText(Messages.common_add);
        nb.setLayoutData((Object)new GridData(768));
        nb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            private String askPassword(String p) {
                NameDialog d = new NameDialog(parent.getShell(), "Key Store Password", p, 0x400800, true);
                if (d.open() == 0) {
                    return d.getName();
                }
                return null;
            }

            /*
             * Exception decompiling
             */
            public void widgetSelected(SelectionEvent ev) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            protected void readKeyStore(BufferedInputStream in, KeyStore kspkcs12) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException {
                String password = "";
                char[] pass = password.toCharArray();
                while (true) {
                    if ((password = this.askPassword(password)) == null) {
                        return;
                    }
                    pass = password.toCharArray();
                    try {
                        kspkcs12.load(in, pass);
                    }
                    catch (IOException ex) {
                        in.reset();
                        UIUtils.showError((Throwable)ex);
                        continue;
                    }
                    break;
                }
                Enumeration<String> eAliases = kspkcs12.aliases();
                while (eAliases.hasMoreElements()) {
                    Certificates c = KeyStorePreferencePage.this.readCertificates(eAliases.nextElement(), kspkcs12, pass);
                    Certificates existing = null;
                    for (Certificates it : KeyStorePreferencePage.this.certificates) {
                        if (!it.alias.equals(c.alias)) continue;
                        existing = it;
                        break;
                    }
                    if (existing != null) {
                        KeyStorePreferencePage.this.certificates.remove(existing);
                        Certificates old = KeyStorePreferencePage.this.aliases.get(c.alias);
                        if (old != null) {
                            KeyStorePreferencePage.this.aliases.put(c.alias, c);
                        }
                    }
                    KeyStorePreferencePage.this.certificates.add(c);
                }
                KeyStorePreferencePage.this.treeviewer.refresh();
                KeyStorePreferencePage.this.treeviewer.expandAll();
            }
        });
        final Button db = new Button(bcmp, 8);
        db.setText(Messages.common_delete);
        db.setEnabled(false);
        db.setLayoutData((Object)new GridData(768));
        db.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection sel = (StructuredSelection)KeyStorePreferencePage.this.treeviewer.getSelection();
                Object fe = sel.getFirstElement();
                if (fe instanceof Certificates) {
                    KeyStorePreferencePage.this.certificates.remove(fe);
                    KeyStorePreferencePage.this.treeviewer.refresh();
                    KeyStorePreferencePage.this.treeviewer.expandAll();
                }
            }
        });
        final StyledText cTxt = new StyledText(cmp, 2890);
        cTxt.setLeftMargin(3);
        cTxt.setTopMargin(3);
        cTxt.setLineSpacing(1);
        cTxt.setLayoutData((Object)new GridData(1808));
        this.treeviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection sel = (StructuredSelection)KeyStorePreferencePage.this.treeviewer.getSelection();
                Object fe = sel.getFirstElement();
                if (fe instanceof X509Certificate) {
                    StyledString ss = CertificateDialog.getStyledToolTip((X509Certificate)fe);
                    cTxt.setText(ss.getString());
                    cTxt.setStyleRanges(ss.getStyleRanges());
                } else {
                    StyledString ss = new StyledString("");
                    cTxt.setText(ss.getString());
                    cTxt.setStyleRanges(ss.getStyleRanges());
                }
                db.setEnabled(!sel.isEmpty() && fe instanceof Certificates);
            }
        });
        return cmp;
    }

    public boolean performOk() {
        try {
            for (String alias : this.aliases.keySet()) {
                Certificates c = this.aliases.get(alias);
                if (this.certificates.contains(c)) continue;
                this.trustStore.deleteEntry(alias);
            }
            for (Certificates c : this.certificates) {
                this.trustStore.deleteEntry(c.alias);
                if (c.key != null) {
                    this.trustStore.setKeyEntry(c.alias, c.key, CertChainValidator.kpass, c.chain);
                    continue;
                }
                Certificate[] certificateArray = c.chain;
                int n = c.chain.length;
                int n2 = 0;
                while (n2 < n) {
                    Certificate cert = certificateArray[n2];
                    this.trustStore.setCertificateEntry(c.alias, cert);
                    ++n2;
                }
            }
            CertChainValidator.writeKeyStore(this.trustStore);
        }
        catch (KeyStoreException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (FileNotFoundException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (CertificateException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (IOException e) {
            UIUtils.showError((Throwable)e);
        }
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
        try {
            this.trustStore = CertChainValidator.getDefaultKeyStore();
            Enumeration<String> alias = this.trustStore.aliases();
            while (alias.hasMoreElements()) {
                Certificates c = this.readCertificates(alias.nextElement(), this.trustStore, CertChainValidator.kpass);
                this.certificates.add(c);
                this.aliases.put(c.alias, c);
            }
        }
        catch (KeyStoreException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (CertificateException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (IOException e) {
            UIUtils.showError((Throwable)e);
        }
    }

    protected Certificates readCertificates(String alias, KeyStore ks, char[] pass) throws KeyStoreException, NoSuchAlgorithmException {
        Certificates c = new Certificates();
        c.alias = alias;
        if (ks.isKeyEntry(c.alias)) {
            try {
                c.key = ks.getKey(c.alias, pass);
            }
            catch (UnrecoverableKeyException e) {
                UIUtils.showError((Throwable)e);
            }
        }
        c.chain = ks.getCertificateChain(c.alias);
        if (c.chain == null) {
            c.chain = new Certificate[]{ks.getCertificate(c.alias)};
        }
        return c;
    }

    class Certificates {
        public String alias;
        public Key key;
        public Certificate[] chain;

        Certificates() {
        }

        public String toString() {
            return this.alias;
        }
    }
}

