/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.preferences;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.server.protocol.restv2.CertChainValidator;
import com.jaspersoft.studio.server.protocol.restv2.CertificateDialog;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TrustStorePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "com.jaspersoft.studio.server.preferences.TrustStorePreferencePage";
    private TableViewer viewer;
    private KeyStore trustStore;
    private List<X509Certificate> trustCertificates = new ArrayList<X509Certificate>();
    private Map<String, Certificate> aliases = new HashMap<String, Certificate>();

    public TrustStorePreferencePage() {
        super("Trust Store");
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(2, false));
        cmp.setFont(parent.getFont());
        this.viewer = new TableViewer(cmp, 68354);
        TableViewerColumn col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setWidth(600);
        col.setLabelProvider((CellLabelProvider)new CertificateDialog.CertificateLabelProvider());
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setInput(this.trustCertificates);
        Table table = this.viewer.getTable();
        GridData gd = new GridData(768);
        gd.heightHint = 70;
        table.setLayoutData((Object)gd);
        final Button bDel = new Button(cmp, 8);
        bDel.setText(Messages.common_delete);
        bDel.setEnabled(false);
        bDel.setLayoutData((Object)new GridData(2));
        bDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection sel = (StructuredSelection)TrustStorePreferencePage.this.viewer.getSelection();
                if (!sel.isEmpty()) {
                    X509Certificate cert = (X509Certificate)sel.getFirstElement();
                    int ind = TrustStorePreferencePage.this.trustCertificates.indexOf(cert);
                    TrustStorePreferencePage.this.trustCertificates.remove(cert);
                    TrustStorePreferencePage.this.viewer.refresh(true);
                    if (TrustStorePreferencePage.this.trustCertificates.size() < ind) {
                        --ind;
                    }
                    if (ind >= 0 && !TrustStorePreferencePage.this.trustCertificates.isEmpty()) {
                        TrustStorePreferencePage.this.viewer.setSelection((ISelection)new StructuredSelection((Object)TrustStorePreferencePage.this.trustCertificates.get(ind)), true);
                    }
                }
            }
        });
        final StyledText cTxt = new StyledText(cmp, 2890);
        cTxt.setLeftMargin(3);
        cTxt.setTopMargin(3);
        cTxt.setLineSpacing(1);
        cTxt.setLayoutData((Object)new GridData(1808));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection sel = (StructuredSelection)TrustStorePreferencePage.this.viewer.getSelection();
                StyledString ss = CertificateDialog.getStyledToolTip((X509Certificate)sel.getFirstElement());
                cTxt.setText(ss.getString());
                cTxt.setStyleRanges(ss.getStyleRanges());
                bDel.setEnabled(!sel.isEmpty());
            }
        });
        return cmp;
    }

    public boolean performOk() {
        try {
            boolean changes = false;
            for (String alias : this.aliases.keySet()) {
                Certificate c = this.aliases.get(alias);
                if (this.trustCertificates.contains(c)) continue;
                this.trustStore.deleteEntry(alias);
                changes = true;
            }
            if (changes) {
                CertChainValidator.writeTrustStore(this.trustStore);
            }
        }
        catch (KeyStoreException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (FileNotFoundException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (CertificateException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (IOException e) {
            UIUtils.showError((Throwable)e);
        }
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
        try {
            this.trustStore = CertChainValidator.getDefaultTrustStore();
            Enumeration<String> alias = this.trustStore.aliases();
            while (alias.hasMoreElements()) {
                String a = alias.nextElement();
                Certificate c = this.trustStore.getCertificate(a);
                this.aliases.put(a, c);
                if (!(c instanceof X509Certificate)) continue;
                this.trustCertificates.add((X509Certificate)c);
            }
        }
        catch (KeyStoreException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (CertificateException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (IOException e) {
            UIUtils.showError((Throwable)e);
        }
    }
}

