/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.properties;

import com.jaspersoft.studio.properties.view.AbstractPropertySection;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetPage;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.properties.action.EditCancelAction;
import com.jaspersoft.studio.server.properties.action.EditOkAction;
import com.jaspersoft.studio.server.properties.action.EditPropertyAction;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;

public abstract class ASection
extends AbstractPropertySection {
    protected IToolBarManager tb;
    private EditPropertyAction editAction;
    private EditOkAction saveAction;
    private EditCancelAction cancelAction;
    protected AMResource res;
    protected DataBindingContext bindingContext;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setBackground(parent.getDisplay().getSystemColor(1));
        this.createSectionControls(composite, aTabbedPropertySheetPage);
        this.createActions(aTabbedPropertySheetPage);
        this.bindingContext = new DataBindingContext();
    }

    protected void createActions(TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.tb = aTabbedPropertySheetPage.getSite().getActionBars().getToolBarManager();
        this.editAction = (EditPropertyAction)this.tb.find("editproperties-js");
        if (this.editAction == null) {
            this.editAction = new EditPropertyAction();
            this.tb.add((IAction)this.editAction);
        }
        this.editAction.addSection(this);
        this.cancelAction = (EditCancelAction)this.tb.find("cancelproperties-js");
        if (this.cancelAction == null) {
            this.cancelAction = new EditCancelAction();
        }
        this.cancelAction.addSection(this);
        this.saveAction = (EditOkAction)this.tb.find("saveproperties-js");
        if (this.saveAction == null) {
            this.saveAction = new EditOkAction();
        }
        this.saveAction.addSection(this);
    }

    protected void removeActions() {
        this.tb.remove("editproperties-js");
        this.tb.remove("cancelproperties-js");
        this.tb.remove("saveproperties-js");
    }

    public void aboutToBeHidden() {
        this.removeActions();
        super.aboutToBeHidden();
    }

    protected abstract void createSectionControls(Composite var1, TabbedPropertySheetPage var2);

    public abstract void enableFields(boolean var1);

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof AMResource));
        this.res = (AMResource)((Object)input);
        this.rebind();
        this.setEditMode(this.res.isEditMode());
    }

    protected void rebind() {
        Object[] bds;
        Object[] objectArray = bds = this.bindingContext.getBindings().toArray();
        int n = bds.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            Binding b = (Binding)obj;
            this.bindingContext.removeBinding(b);
            b.dispose();
            ++n2;
        }
        this.bind();
    }

    protected abstract void bind();

    public void refresh() {
        this.bindingContext.updateTargets();
    }

    public void aboutToBeShown() {
        if (this.res != null) {
            this.setEditMode(this.res.isEditMode());
        }
        super.aboutToBeShown();
    }

    public void editProperties() {
        this.setEditMode(true);
    }

    public void cancelEditProperties() {
        this.setEditMode(false);
    }

    public void saveProperties() {
        try {
            ProgressMonitorDialog pm = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
            try {
                pm.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            try {
                                WSClientHelper.saveResource(ASection.this.res, monitor);
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        ASection.this.setEditMode(false);
                                    }
                                });
                            }
                            catch (Throwable e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                UIUtils.showError((Throwable)e);
            }
            catch (InterruptedException e) {
                UIUtils.showError((Throwable)e);
            }
        }
        catch (Exception e) {
            UIUtils.showError((Throwable)e);
        }
    }

    protected void setEditMode(boolean edit) {
        this.removeActions();
        if (edit) {
            this.tb.add((IAction)this.cancelAction);
            this.tb.add((IAction)this.saveAction);
        } else {
            this.tb.add((IAction)this.editAction);
        }
        this.tb.update(true);
        this.enableFields(edit);
        this.res.setEditMode(edit);
    }
}

