/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.properties.dialog;

import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.properties.dialog.RepositoryComposite;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class RepositoryDialog
extends ATitledDialog {
    private INode root;
    private AMResource resource;
    private Text tname;
    private Text ttype;

    public RepositoryDialog(Shell parentShell, INode root) {
        super(parentShell);
        this.root = root;
        this.setTitle(Messages.RepositoryDialog_0);
    }

    public AMResource getResource() {
        return this.resource;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(2, false));
        RepositoryComposite rcom = new RepositoryComposite(composite, 0, this.root, true){

            @Override
            protected void okPressed() {
                RepositoryDialog.this.okPressed();
            }

            @Override
            protected void setOkButtonEnabled(boolean resCompatible) {
                RepositoryDialog.this.getButton(0).setEnabled(resCompatible);
            }

            @Override
            public void setResource(AMResource res) {
                super.setResource(res);
                RepositoryDialog.this.tname.setText(res.getValue().getUriString());
                RepositoryDialog.this.ttype.setText(res.getValue().getWsType());
                RepositoryDialog.this.resource = res;
            }

            @Override
            public boolean isResourceCompatible(AMResource r) {
                return RepositoryDialog.this.isResourceCompatible(r);
            }
        };
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        gd.heightHint = 300;
        gd.widthHint = 400;
        rcom.setLayoutData(gd);
        new Label(composite, 0).setText(Messages.RepositoryDialog_1);
        this.tname = new Text(composite, 2056);
        this.tname.setLayoutData((Object)new GridData(768));
        new Label(composite, 0).setText(Messages.RepositoryDialog_2);
        this.ttype = new Text(composite, 2056);
        this.ttype.setLayoutData((Object)new GridData(768));
        return composite;
    }

    public abstract boolean isResourceCompatible(AMResource var1);

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }
}

