/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.protocol.restv2;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.dto.resources.ClientResource;
import com.jaspersoft.jasperserver.dto.serverinfo.ServerInfo;
import com.jaspersoft.studio.server.model.server.ServerProfile;
import com.jaspersoft.studio.server.protocol.Feature;
import com.jaspersoft.studio.server.protocol.IConnection;
import com.jaspersoft.studio.server.protocol.restv2.RESTv2ExceptionHandler;
import com.jaspersoft.studio.server.protocol.restv2.Rest2Soap;
import com.jaspersoft.studio.server.utils.Pass;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.sql.Date;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class ARestV2Connection
implements IConnection {
    public static final String SUFFIX = "rest_v2/";
    public static final String FORMAT = "json";
    protected ServerProfile sp;
    protected IConnection parent;
    protected final Logger logger = Logger.getLogger("global");
    protected DateFormat dateFormat = DateFormat.getDateInstance();
    protected DateFormat timestampFormat = DateFormat.getDateTimeInstance();
    protected DateFormat timeFormat = new SimpleDateFormat("h:mm:ss", Locale.US);
    protected NumberFormat numberFormat = NumberFormat.getInstance();
    protected ServerInfo serverInfo;
    protected RESTv2ExceptionHandler eh;

    @Override
    public void setParent(IConnection parent) {
        this.parent = parent;
    }

    @Override
    public ServerProfile getServerProfile() {
        return this.sp;
    }

    @Override
    public boolean connect(IProgressMonitor monitor, ServerProfile sp) throws Exception {
        this.sp = sp;
        return true;
    }

    protected String url(String suffix) throws MalformedURLException, URISyntaxException {
        return String.valueOf(this.sp.getUrl()) + SUFFIX + suffix;
    }

    @Override
    public Format getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public Format getTimestampFormat() {
        return this.timestampFormat;
    }

    @Override
    public Format getTimeFormat() {
        return this.timeFormat;
    }

    @Override
    public Format getNumberFormat() {
        return this.numberFormat;
    }

    public java.util.Date toDate(String sdate) throws ParseException {
        if (sdate == null) {
            return null;
        }
        return this.dateFormat.parse(sdate);
    }

    public java.util.Date toTimestamp(String sdate) throws ParseException {
        if (sdate == null) {
            return null;
        }
        return this.timestampFormat.parse(sdate);
    }

    public String date2str(java.util.Date d) throws ParseException {
        if (d == null) {
            return null;
        }
        return this.dateFormat.format(d);
    }

    public String timestamp2str(java.util.Date d) throws ParseException {
        if (d == null) {
            return null;
        }
        return this.timestampFormat.format(d);
    }

    public String toRestString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return this.dateFormat.format(obj);
        }
        if (obj instanceof java.util.Date) {
            return this.timestampFormat.format(obj);
        }
        if (obj instanceof Number) {
            return obj.toString();
        }
        return obj.toString();
    }

    @Override
    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    @Override
    public String getWebservicesUri() {
        try {
            return this.sp.getUrl();
        }
        catch (MalformedURLException | URISyntaxException e) {
            this.logger.log(Level.FINE, e.getMessage(), e);
            return null;
        }
    }

    @Override
    public String getUsername() {
        return this.sp.getUser();
    }

    @Override
    public String getPassword(IProgressMonitor monitor) throws Exception {
        if (this.parent != null) {
            return this.getPassword(monitor);
        }
        return Pass.getPass(this.sp.getPass());
    }

    @Override
    public ResourceDescriptor toResourceDescriptor(ClientResource<?> rest) throws Exception {
        return Rest2Soap.getRD(this, rest);
    }

    @Override
    public boolean isSupported(Feature f) {
        return false;
    }

    public RESTv2ExceptionHandler getEh() {
        return this.eh;
    }

    public abstract void getBundle(Map<String, String> var1, String var2, IProgressMonitor var3) throws Exception;

    public abstract List<ResourceDescriptor> getInputControls(String var1, IProgressMonitor var2) throws Exception;

    @Override
    public Integer getPermissionMask(ResourceDescriptor rd, IProgressMonitor monitor) throws Exception {
        return rd.getPermissionMask(null);
    }
}

