/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.protocol.restv2;

import com.jaspersoft.studio.ConfigurationManager;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.protocol.CRLVerifier;
import com.jaspersoft.studio.server.protocol.restv2.CertificateDialog;
import com.jaspersoft.studio.server.utils.Pass;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidator;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;

public class CertChainValidator {
    private static String fname = System.getProperty("javax.net.ssl.trustStore");
    private static String fksname = System.getProperty("javax.net.ssl.trustStore");
    private static final char[] spass = Misc.nvl((String)System.getProperty("javax.net.ssl.trustStorePassword")).toCharArray();
    public static final char[] kpass = Pass.getPassKeyStore(Misc.nvl((Object)System.getProperty("javax.net.ssl.keyStorePassword"), (String)"keystore")).toCharArray();
    private static String stype = System.getProperty("javax.net.ssl.trustStoreType");
    private static CertificateFactory cf;
    private static CertPathValidator validator;

    private static void removeFaultySecurityProviders() {
        Security.removeProvider("DDPKIProvider");
    }

    public static KeyStore getDefaultTrustStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        CertChainValidator.removeFaultySecurityProviders();
        stype = System.getProperty("javax.net.ssl.trustStoreType");
        KeyStore trustStore = KeyStore.getInstance(Misc.isNullOrEmpty((String)stype) ? KeyStore.getDefaultType() : stype);
        fname = System.getProperty("javax.net.ssl.trustStore");
        File f = null;
        if (Misc.isNullOrEmpty((String)fname)) {
            f = new File(ConfigurationManager.getStorage((String)"certificates"), "cert.ks");
            fname = f.getAbsolutePath();
        } else {
            f = new File(fname);
        }
        if (!f.exists()) {
            trustStore.load(null, spass);
        } else {
            FileInputStream fos = null;
            try {
                fos = new FileInputStream(fname);
                trustStore.load(fos, spass);
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(fos);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)fos);
        }
        return trustStore;
    }

    public static KeyStore getDefaultKeyStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        String kstype = System.getProperty("javax.net.ssl.keyStoreType");
        KeyStore store = KeyStore.getInstance(Misc.isNullOrEmpty((String)stype) ? KeyStore.getDefaultType() : kstype);
        fksname = System.getProperty("javax.net.ssl.keyStore");
        File f = null;
        if (Misc.isNullOrEmpty((String)fksname)) {
            f = new File(ConfigurationManager.getStorage((String)"certificates"), "certkeystore.ks");
            fksname = f.getAbsolutePath();
        } else {
            f = new File(fksname);
        }
        if (!f.exists()) {
            store.load(null, kpass);
        } else {
            FileInputStream fos = null;
            try {
                fos = new FileInputStream(fksname);
                store.load(fos, kpass);
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(fos);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)fos);
        }
        return store;
    }

    public static void writeKeyStore(KeyStore trustStore) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        CertChainValidator.writeKeyStore(fksname, trustStore);
    }

    protected static void writeKeyStore(String fname, KeyStore trustStore) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fname);
            trustStore.store(fos, kpass);
        }
        catch (Throwable throwable) {
            FileUtils.closeStream(fos);
            throw throwable;
        }
        FileUtils.closeStream((Closeable)fos);
    }

    public static void writeTrustStore(KeyStore trustStore) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        CertChainValidator.writeTrustStore(fname, trustStore);
    }

    protected static void writeTrustStore(String fname, KeyStore trustStore) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fname);
            trustStore.store(fos, spass);
        }
        catch (Throwable throwable) {
            FileUtils.closeStream(fos);
            throw throwable;
        }
        FileUtils.closeStream((Closeable)fos);
    }

    public static void validateKeyChain(X509Certificate[] chain, KeyStore trustStore) throws IOException, GeneralSecurityException {
        if (cf == null) {
            cf = CertificateFactory.getInstance("X.509");
        }
        if (validator == null) {
            validator = CertPathValidator.getInstance("PKIX");
        }
        HashSet<X509Certificate> trustCertificates = new HashSet<X509Certificate>();
        Enumeration<String> alias = trustStore.aliases();
        while (alias.hasMoreElements()) {
            Certificate c = trustStore.getCertificate(alias.nextElement());
            if (chain[0].equals(c)) {
                return;
            }
            if (!(c instanceof X509Certificate)) continue;
            trustCertificates.add((X509Certificate)c);
        }
        try {
            chain[0].checkValidity();
        }
        catch (CertificateExpiredException e) {
            CertChainValidator.confirmCertificate(chain[0], chain, trustStore, e);
            return;
        }
        if (CertChainValidator.isSelfSigned(chain[0])) {
            CertChainValidator.confirmCertificate(chain[0], chain, trustStore, new CertificateException("This is a Self-Signed certificate"));
            return;
        }
        if (trustCertificates.contains(chain[chain.length - 1])) {
            ArrayList<X509Certificate> intermediateCerts = new ArrayList<X509Certificate>();
            int i = chain.length - 1;
            while (i > 0) {
                intermediateCerts.add(chain[i]);
                --i;
            }
            try {
                CertChainValidator.verifyCertificate(chain[0], trustCertificates, intermediateCerts, false);
                CRLVerifier.verifyCertificateCRLs(chain[0]);
            }
            catch (CertificateException e) {
                CertChainValidator.confirmCertificate(chain[0], chain, trustStore, e);
            }
        } else {
            CertChainValidator.confirmCertificate(chain[chain.length - 1], new X509Certificate[]{chain[chain.length - 1]}, trustStore, new CertificateException(Messages.CertChainValidator_10));
        }
    }

    private static PKIXCertPathBuilderResult verifyCertificate(X509Certificate cert, Set<X509Certificate> trustedRootCerts, List<X509Certificate> intermediateCerts, boolean verifySelfSignedCert) throws GeneralSecurityException {
        X509CertSelector selector = new X509CertSelector();
        selector.setCertificate(cert);
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (X509Certificate trustedRootCert : trustedRootCerts) {
            trustAnchors.add(new TrustAnchor(trustedRootCert, null));
        }
        PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
        pkixParams.setRevocationEnabled(false);
        CertStore intermediateCertStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(intermediateCerts));
        pkixParams.addCertStore(intermediateCertStore);
        CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
        return (PKIXCertPathBuilderResult)builder.build(pkixParams);
    }

    private static void confirmCertificate(X509Certificate client, X509Certificate[] chain, KeyStore trustStore, CertificateException e) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        ShowDialog r = new ShowDialog(client, chain, e);
        UIUtils.getDisplay().syncExec((Runnable)r);
        if (r.result == 0) {
            trustStore.setCertificateEntry(UUID.randomUUID().toString().replaceAll("-", ""), client);
            CertChainValidator.writeTrustStore(fname, trustStore);
            throw new RuntimeException(new InterruptedException());
        }
        throw e;
    }

    public static boolean isSelfSigned(X509Certificate cert) throws CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            cert.verify(cert.getPublicKey());
            return true;
        }
        catch (InvalidKeyException | SignatureException generalSecurityException) {
            return false;
        }
    }

    static class ShowDialog
    implements Runnable {
        public int result = 1;
        private CertificateException e;
        private X509Certificate client;
        private X509Certificate[] chain;

        public ShowDialog(X509Certificate client, X509Certificate[] chain, CertificateException e) {
            this.client = client;
            this.e = e;
            this.chain = chain;
        }

        @Override
        public void run() {
            CertificateDialog d = new CertificateDialog(UIUtils.getShell(), this.e.getMessage(), this.client, this.chain);
            this.result = d.open();
        }
    }
}

