/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.protocol.restv2;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ListItem;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceProperty;
import com.jaspersoft.jasperserver.dto.resources.AbstractClientJdbcDataSource;
import com.jaspersoft.jasperserver.dto.resources.AbstractClientReportUnit;
import com.jaspersoft.jasperserver.dto.resources.ClientAdhocDataView;
import com.jaspersoft.jasperserver.dto.resources.ClientAwsDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientBeanDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientCustomDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientDataType;
import com.jaspersoft.jasperserver.dto.resources.ClientFile;
import com.jaspersoft.jasperserver.dto.resources.ClientInputControl;
import com.jaspersoft.jasperserver.dto.resources.ClientJdbcDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientJndiJdbcDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientListOfValues;
import com.jaspersoft.jasperserver.dto.resources.ClientListOfValuesItem;
import com.jaspersoft.jasperserver.dto.resources.ClientMondrianConnection;
import com.jaspersoft.jasperserver.dto.resources.ClientMondrianXmlaDefinition;
import com.jaspersoft.jasperserver.dto.resources.ClientOlapUnit;
import com.jaspersoft.jasperserver.dto.resources.ClientProperty;
import com.jaspersoft.jasperserver.dto.resources.ClientQuery;
import com.jaspersoft.jasperserver.dto.resources.ClientReference;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableDataType;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableFile;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableInputControl;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableListOfValues;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableMondrianConnection;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableQuery;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenciableOlapConnection;
import com.jaspersoft.jasperserver.dto.resources.ClientReportUnit;
import com.jaspersoft.jasperserver.dto.resources.ClientResource;
import com.jaspersoft.jasperserver.dto.resources.ClientSecureMondrianConnection;
import com.jaspersoft.jasperserver.dto.resources.ClientSubDataSourceReference;
import com.jaspersoft.jasperserver.dto.resources.ClientVirtualDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientXmlaConnection;
import com.jaspersoft.studio.server.Activator;
import com.jaspersoft.studio.server.ResourceFactory;
import com.jaspersoft.studio.server.protocol.restv2.ARestV2Connection;
import com.jaspersoft.studio.server.protocol.restv2.DiffFields;
import com.jaspersoft.studio.server.protocol.restv2.WsTypes;
import com.jaspersoft.studio.server.wizard.resource.page.selector.SelectorDatasource;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Misc;

public class Soap2Rest {
    public static Object getResourceContainer(ARestV2Connection rc, ResourceDescriptor rd) throws ParseException {
        if (rd.getParentFolder() != null && !rd.getParentFolder().endsWith("_files")) {
            rd.setIsReference(true);
        }
        if (rd.getIsReference()) {
            return new ClientReference(Misc.nvl((Object)rd.getReferenceUri(), (String)rd.getUriString()));
        }
        ClientResource<?> res = Soap2Rest.getResource(rc, rd);
        if (rd.getIsNew()) {
            res.setVersion(Integer.valueOf(-1));
        }
        return res;
    }

    public static ClientResource<?> getResource(ARestV2Connection rc, ResourceDescriptor rd) throws ParseException {
        ClientResource<?> cr = WsTypes.INST().createResource(rd);
        cr.setCreationDate(rc.timestamp2str(rd.getCreationDate()));
        cr.setLabel(rd.getLabel());
        cr.setDescription(rd.getDescription());
        cr.setUri(rd.getUriString());
        cr.setVersion(Integer.valueOf(rd.getVersion()));
        cr.setUpdateDate(DiffFields.getSoapValue(rd, "updateDate"));
        cr.setPermissionMask(Integer.valueOf(rd.getPermissionMask(null)));
        if (rd.getWsType().equals("dataType")) {
            Soap2Rest.getDataType(rc, (ClientDataType)cr, rd);
        } else if (rd.getWsType().equals("adhocDataView")) {
            Soap2Rest.getAdhocDataView(rc, (ClientAdhocDataView)cr, rd);
        } else if (rd.getWsType().equals("jdbc")) {
            Soap2Rest.getJdbcDataSource(rc, (ClientJdbcDataSource)cr, rd);
        } else if (rd.getWsType().equals("bean")) {
            Soap2Rest.getBeanDataSource(rc, (ClientBeanDataSource)cr, rd);
        } else if (rd.getWsType().equals("jndi")) {
            Soap2Rest.getJndiDataSource(rc, (ClientJndiJdbcDataSource)cr, rd);
        } else if (rd.getWsType().equals("custom")) {
            Soap2Rest.getCustomDataSource(rc, (ClientCustomDataSource)cr, rd);
        } else if (rd.getWsType().equals("aws")) {
            Soap2Rest.getAWSDataSource(rc, (ClientAwsDataSource)cr, rd);
        } else if (rd.getWsType().equals("virtual")) {
            Soap2Rest.getVirtualDataSource(rc, (ClientVirtualDataSource)cr, rd);
        } else if (rd.getWsType().equals("query")) {
            Soap2Rest.getQuery(rc, (ClientQuery)cr, rd);
        } else if (rd.getWsType().equals("inputControl")) {
            Soap2Rest.getInputControl(rc, (ClientInputControl)cr, rd);
        } else if (rd.getWsType().equals("lov")) {
            Soap2Rest.getLOV(rc, (ClientListOfValues)cr, rd);
        } else if (rd.getWsType().equals("olapXmlaCon")) {
            Soap2Rest.getXmlaConnection(rc, (ClientXmlaConnection)cr, rd);
        } else if (rd.getWsType().equals("olapUnit")) {
            Soap2Rest.getOlapUnit(rc, (ClientOlapUnit)cr, rd);
        } else if (rd.getWsType().equals("olapMondrianCon")) {
            Soap2Rest.getMondrianConnection(rc, (ClientMondrianConnection)cr, rd);
        } else if (rd.getWsType().equals("secureMondrianConnection")) {
            Soap2Rest.getSecureMondrianConnection(rc, (ClientSecureMondrianConnection)cr, rd);
        } else if (rd.getWsType().equals("mondrianXmlaDefinition")) {
            Soap2Rest.getMondrianXmlaDefinition(rc, (ClientMondrianXmlaDefinition)cr, rd);
        } else if (rd.getWsType().equals("reportUnit")) {
            Soap2Rest.getReportUnit(rc, (ClientReportUnit)cr, rd);
        }
        if (WsTypes.INST().getSoapfileMap().containsKey(rd.getWsType())) {
            Soap2Rest.getFile(rc, (ClientFile)cr, rd);
        } else {
            Activator.getExtManager().getResource(rc, cr, rd);
        }
        return cr;
    }

    private static void getAdhocDataView(ARestV2Connection rc, ClientAdhocDataView cr, ResourceDescriptor rd) throws ParseException {
        List<ResourceDescriptor> children = rd.getChildren();
        for (ResourceDescriptor r : children) {
            if (!SelectorDatasource.isDatasource(r)) continue;
            cr.setDataSource((ClientReferenceableDataSource)Soap2Rest.getResourceContainer(rc, r));
        }
    }

    private static void getLOV(ARestV2Connection rc, ClientListOfValues cr, ResourceDescriptor rd) {
        ArrayList<ClientListOfValuesItem> lovs = new ArrayList<ClientListOfValuesItem>();
        if (rd.getListOfValues() != null) {
            for (ListItem l : rd.getListOfValues()) {
                lovs.add(new ClientListOfValuesItem(l.getLabel(), (String)l.getValue()));
            }
        }
        cr.setItems(lovs);
    }

    private static void getMondrianConnection(ARestV2Connection rc, ClientMondrianConnection cr, ResourceDescriptor rd) throws ParseException {
        for (ResourceDescriptor r : rd.getChildren()) {
            if (SelectorDatasource.isDatasource(r)) {
                cr.setDataSource((ClientReferenceableDataSource)Soap2Rest.getResourceContainer(rc, r));
                continue;
            }
            if (!r.getWsType().equals("olapMondrianSchema")) continue;
            cr.setSchema((ClientReferenceableFile)Soap2Rest.getResourceContainer(rc, r));
        }
    }

    private static void getSecureMondrianConnection(ARestV2Connection rc, ClientSecureMondrianConnection cr, ResourceDescriptor rd) throws ParseException {
        for (ResourceDescriptor r : rd.getChildren()) {
            if (SelectorDatasource.isDatasource(r)) {
                cr.setDataSource((ClientReferenceableDataSource)Soap2Rest.getResourceContainer(rc, r));
                continue;
            }
            if (r.getWsType().equals("olapMondrianSchema")) {
                cr.setSchema((ClientReferenceableFile)Soap2Rest.getResourceContainer(rc, r));
                continue;
            }
            if (!r.getWsType().equals("accessGrantSchema")) continue;
            if (cr.getAccessGrants() == null) {
                cr.setAccessGrants(new ArrayList());
            }
            cr.getAccessGrants().add((ClientReferenceableFile)Soap2Rest.getResourceContainer(rc, r));
        }
    }

    private static void getMondrianXmlaDefinition(ARestV2Connection rc, ClientMondrianXmlaDefinition cr, ResourceDescriptor rd) throws ParseException {
        ResourceProperty rp = rd.getResourceProperty("PROP_XMLA_CATALOG");
        if (rp != null) {
            cr.setCatalog(rp.getValue());
        }
        for (ResourceDescriptor r : rd.getChildren()) {
            if (!r.getWsType().equals("olapMondrianCon") && !r.getWsType().equals("secureMondrianConnection")) continue;
            cr.setMondrianConnection((ClientReferenceableMondrianConnection)Soap2Rest.getResourceContainer(rc, r));
        }
    }

    private static void getXmlaConnection(ARestV2Connection rc, ClientXmlaConnection cr, ResourceDescriptor rd) {
        cr.setUrl(rd.getResourcePropertyValue("PROP_XMLA_URI"));
        cr.setDataSource(rd.getResourcePropertyValue("PROP_XMLA_DATASOURCE"));
        cr.setCatalog(rd.getResourcePropertyValue("PROP_XMLA_CATALOG"));
        cr.setUsername(rd.getResourcePropertyValue("PROP_XMLA_USERNAME"));
        cr.setPassword(Misc.nullValue((String)rd.getResourcePropertyValue("PROP_XMLA_PASSWORD")));
    }

    private static void getOlapUnit(ARestV2Connection rc, ClientOlapUnit cr, ResourceDescriptor rd) throws ParseException {
        cr.setMdxQuery(rd.getSql());
        for (ResourceDescriptor r : rd.getChildren()) {
            if (!r.getWsType().equals("olapXmlaCon") && !r.getWsType().equals("olapMondrianCon") && !r.getWsType().equals("secureMondrianConnection")) continue;
            cr.setOlapConnection((ClientReferenciableOlapConnection)Soap2Rest.getResourceContainer(rc, r));
        }
    }

    private static void getVirtualDataSource(ARestV2Connection rc, ClientVirtualDataSource cr, ResourceDescriptor rd) {
        ArrayList<ClientSubDataSourceReference> ds = new ArrayList<ClientSubDataSourceReference>();
        for (ResourceDescriptor r : rd.getChildren()) {
            ClientSubDataSourceReference d = new ClientSubDataSourceReference();
            d.setId(r.getResourcePropertyValue("PROP_DATASOURCE_SUB_DS_ID"));
            d.setUri(r.getReferenceUri());
            ds.add(d);
        }
        cr.setSubDataSources(ds);
    }

    private static void getAWSDataSource(ARestV2Connection rc, ClientAwsDataSource cr, ResourceDescriptor rd) {
        Soap2Rest.getJdbcDataSource(rc, cr, rd);
        cr.setAccessKey(DiffFields.getSoapValue(rd, "accessKey"));
        cr.setSecretKey(DiffFields.getSoapValue(rd, "secretKey"));
        cr.setRoleArn(DiffFields.getSoapValue(rd, "roleArn"));
        cr.setRegion(DiffFields.getSoapValue(rd, "region"));
        cr.setDbName(DiffFields.getSoapValue(rd, "dbName"));
        cr.setDbInstanceIdentifier(DiffFields.getSoapValue(rd, "dbInstanceIdentifier"));
        cr.setDbService(DiffFields.getSoapValue(rd, "dbService"));
        cr.setTimezone(DiffFields.getSoapValue(rd, "timezone"));
    }

    private static void getCustomDataSource(ARestV2Connection rc, ClientCustomDataSource cr, ResourceDescriptor rd) {
        cr.setServiceClass(rd.getServiceClass());
        cr.setDataSourceName(DiffFields.getSoapValue(rd, "dataSourceName"));
        Map<String, String> map = rd.getPropertyMap();
        ArrayList<ClientProperty> props = new ArrayList<ClientProperty>();
        for (String key : map.keySet()) {
            if (key.equals("password") && Misc.isNullOrEmpty((String)map.get(key))) continue;
            props.add(new ClientProperty(key, map.get(key)));
        }
        cr.setProperties(props);
    }

    private static void getJndiDataSource(ARestV2Connection rc, ClientJndiJdbcDataSource cr, ResourceDescriptor rd) {
        cr.setJndiName(rd.getJndiName());
        cr.setTimezone(DiffFields.getSoapValue(rd, "timezone"));
    }

    private static void getBeanDataSource(ARestV2Connection rc, ClientBeanDataSource cr, ResourceDescriptor rd) {
        cr.setBeanName(rd.getBeanName());
        cr.setBeanMethod(rd.getBeanMethod());
    }

    public static void getJdbcDataSource(ARestV2Connection rc, AbstractClientJdbcDataSource<?> cr, ResourceDescriptor rd) {
        cr.setDriverClass(rd.getDriverClass());
        cr.setPassword(Misc.nullValue((String)rd.getPassword()));
        cr.setUsername(rd.getUsername());
        cr.setConnectionUrl(rd.getConnectionUrl());
        cr.setTimezone(DiffFields.getSoapValue(rd, "timezone"));
    }

    private static void getDataType(ARestV2Connection rc, ClientDataType cr, ResourceDescriptor rd) {
        switch (rd.getDataType()) {
            case 1: {
                cr.setType(ClientDataType.TypeOfDataType.text);
                break;
            }
            case 2: {
                cr.setType(ClientDataType.TypeOfDataType.number);
                break;
            }
            case 3: {
                cr.setType(ClientDataType.TypeOfDataType.date);
                break;
            }
            case 4: {
                cr.setType(ClientDataType.TypeOfDataType.datetime);
                break;
            }
            case 5: {
                cr.setType(ClientDataType.TypeOfDataType.time);
            }
        }
        cr.setPattern(rd.getPattern());
        cr.setMaxValue(rd.getMaxValue());
        cr.setStrictMax(Boolean.valueOf(rd.isStrictMax()));
        cr.setMinValue(rd.getMinValue());
        cr.setStrictMin(Boolean.valueOf(rd.isStrictMin()));
        Integer ml = DiffFields.getSoapValueInteger(rd, "maxLength");
        if (ml != null && ml > 0) {
            cr.setMaxLength(ml);
        }
    }

    private static void getQuery(ARestV2Connection rc, ClientQuery cr, ResourceDescriptor rd) throws ParseException {
        cr.setValue(rd.getSql());
        cr.setLanguage(rd.getResourcePropertyValue("PROP_QUERY_LANGUAGE"));
        List<ResourceDescriptor> children = rd.getChildren();
        for (ResourceDescriptor r : children) {
            if (!SelectorDatasource.isDatasource(r)) continue;
            cr.setDataSource((ClientReferenceableDataSource)Soap2Rest.getResourceContainer(rc, r));
        }
    }

    private static void getFile(ARestV2Connection rc, ClientFile cr, ResourceDescriptor rd) {
        cr.setType(WsTypes.INST().toRestFileType(rd.getWsType()));
        if (rd.getData() != null) {
            String content = new String(rd.getData());
            if (content.isEmpty()) {
                content = "    ";
            }
            cr.setContent(content);
        }
    }

    private static void getInputControl(ARestV2Connection rc, ClientInputControl cr, ResourceDescriptor rd) throws ParseException {
        cr.setMandatory(rd.isMandatory());
        cr.setReadOnly(rd.isReadOnly());
        cr.setVisible(rd.isVisible());
        cr.setType(rd.getControlType());
        List<ResourceDescriptor> children = rd.getChildren();
        for (ResourceDescriptor r : children) {
            if (r.getWsType().equals("lov")) {
                cr.setListOfValues((ClientReferenceableListOfValues)Soap2Rest.getResourceContainer(rc, r));
                continue;
            }
            if (r.getWsType().equals("query")) {
                cr.setQuery((ClientReferenceableQuery)Soap2Rest.getResourceContainer(rc, r));
                cr.setValueColumn(rd.getQueryValueColumn());
                if (rd.getQueryVisibleColumns() == null) continue;
                cr.setVisibleColumns(Arrays.asList(rd.getQueryVisibleColumns()));
                continue;
            }
            if (!r.getWsType().equals("dataType")) continue;
            cr.setDataType((ClientReferenceableDataType)Soap2Rest.getResourceContainer(rc, r));
        }
    }

    public static void getReportUnit(ARestV2Connection rc, AbstractClientReportUnit<?> cr, ResourceDescriptor rd) throws ParseException {
        HashMap<String, ClientReferenceableFile> icf;
        cr.setAlwaysPromptControls(((Boolean)Misc.nvl((Object)rd.getResourcePropertyValueAsBoolean("PROP_RU_ALWAYS_PROPMT_CONTROLS"), (Object)Boolean.FALSE)).booleanValue());
        cr.setInputControlRenderingView(rd.getResourcePropertyValue("PROP_RU_INPUTCONTROL_RENDERING_VIEW"));
        cr.setReportRenderingView(rd.getResourcePropertyValue("PROP_RU_REPORT_RENDERING_VIEW"));
        int rurv = (Integer)Misc.nvl((Object)rd.getResourcePropertyValueAsInteger("PROP_RU_CONTROLS_LAYOUT"), (Object)1);
        switch (rurv) {
            case 1: {
                cr.setControlsLayout(AbstractClientReportUnit.ControlsLayoutType.popupScreen);
                break;
            }
            case 2: {
                cr.setControlsLayout(AbstractClientReportUnit.ControlsLayoutType.separatePage);
                break;
            }
            case 3: {
                cr.setControlsLayout(AbstractClientReportUnit.ControlsLayoutType.topOfPage);
                break;
            }
            case 4: {
                cr.setControlsLayout(AbstractClientReportUnit.ControlsLayoutType.inPage);
            }
        }
        List<ResourceDescriptor> children = rd.getChildren();
        ArrayList<ClientReferenceableInputControl> ics = cr.getInputControls();
        if (ics == null) {
            ics = new ArrayList<ClientReferenceableInputControl>();
            cr.setInputControls(ics);
        }
        if ((icf = cr.getFiles()) == null) {
            icf = new HashMap<String, ClientReferenceableFile>();
            cr.setFiles(icf);
        }
        for (ResourceDescriptor r : children) {
            if (r == null) continue;
            if (SelectorDatasource.isDatasource(r)) {
                cr.setDataSource((ClientReferenceableDataSource)Soap2Rest.getResourceContainer(rc, r));
                continue;
            }
            String t = r.getWsType();
            if (t.equals("query")) {
                cr.setQuery((ClientReferenceableQuery)Soap2Rest.getResourceContainer(rc, r));
                continue;
            }
            if ((t.equals("jrxml") || t.equals("reference")) && r.isMainReport()) {
                cr.setJrxml((ClientReferenceableFile)Soap2Rest.getResourceContainer(rc, r));
                continue;
            }
            if (t.equals("inputControl")) {
                ClientReferenceableInputControl ic = (ClientReferenceableInputControl)Soap2Rest.getResourceContainer(rc, r);
                String uri = ic.getUri();
                boolean exists = false;
                for (ClientReferenceableInputControl item : ics) {
                    if (!item.getUri().equals(uri)) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                ics.add(ic);
                continue;
            }
            if (!ResourceFactory.isFileResourceType(r) && !t.equals("reference")) continue;
            icf.put(r.getName(), (ClientReferenceableFile)Soap2Rest.getResourceContainer(rc, r));
        }
    }
}

