/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.publish;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.compatibility.JRXmlWriterHelper;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.storage.JRDefaultDataAdapterStorage;
import com.jaspersoft.studio.server.Activator;
import com.jaspersoft.studio.server.model.AMJrxmlContainer;
import com.jaspersoft.studio.server.model.MJrxml;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.plugin.ExtensionManager;
import com.jaspersoft.studio.server.plugin.IPublishContributor;
import com.jaspersoft.studio.server.publish.imp.ImpChartCustomizer;
import com.jaspersoft.studio.server.publish.imp.ImpDataAdapter;
import com.jaspersoft.studio.server.publish.imp.ImpImage;
import com.jaspersoft.studio.server.publish.imp.ImpInputControls;
import com.jaspersoft.studio.server.publish.imp.ImpJRXML;
import com.jaspersoft.studio.server.publish.imp.ImpResourceBundle;
import com.jaspersoft.studio.server.publish.imp.ImpStyleTemplate;
import com.jaspersoft.studio.server.publish.imp.ImpSubreport;
import com.jaspersoft.studio.server.utils.ResourceDescriptorUtil;
import com.jaspersoft.studio.utils.JRXMLUtils;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JSSFileRepositoryService;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRPart;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlDigesterFactory;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.parts.subreport.StandardSubreportPartComponent;
import net.sf.jasperreports.repo.FileRepositoryService;
import net.sf.jasperreports.repo.RepositoryService;
import org.apache.commons.digester.Digester;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xml.sax.InputSource;

public class JrxmlPublishContributor
implements IPublishContributor {
    public static final String COM_JASPERSOFT_JRS_DATA_SOURCE = "com.jaspersoft.jrs.data.source";
    private JasperReportsConfiguration jrConfig;
    private String version;
    private ExtensionManager extManager;
    private ImpResourceBundle impBundle;
    private ImpDataAdapter impDa;
    private ImpStyleTemplate impStyle;
    private ImpImage impImg;
    private ImpSubreport impSRP;
    private ImpInputControls impIC;
    private ImpJRXML impJRXML;
    private ImpChartCustomizer impChartCustomizer;

    @Override
    public void publishJrxml(AMJrxmlContainer mrunit, IProgressMonitor monitor, JasperDesign jasper, Set<String> fileset, IFile file, String version) throws Exception {
        this.init(mrunit.getJasperConfiguration(), version);
        this.publishJrxml(mrunit, monitor, jasper, fileset, file);
        if (ResourceDescriptorUtil.isReportMain(file)) {
            jasper.removeProperty(COM_JASPERSOFT_JRS_DATA_SOURCE);
            if (mrunit instanceof MJrxml && mrunit.getValue().isMainReport()) {
                mrunit = (AMJrxmlContainer)mrunit.getParent();
            }
            if (mrunit instanceof MReportUnit) {
                this.publishParameters((MReportUnit)mrunit, monitor, jasper);
            }
        }
    }

    @Override
    public void publishParameters(MReportUnit mrunit, IProgressMonitor monitor, JasperDesign jasper) throws Exception {
        this.impIC.publish(mrunit, monitor, jasper, this.jrConfig);
        this.extManager.publishParameters(this.jrConfig, mrunit, monitor, jasper);
    }

    private void publishJrxml(AMJrxmlContainer mres, IProgressMonitor monitor, JasperDesign jasper, Set<String> fileset, IFile file) throws Exception {
        if (monitor.isCanceled()) {
            return;
        }
        MReportUnit mrunit = null;
        if (mres instanceof MReportUnit) {
            mrunit = (MReportUnit)mres;
        } else if (mres.getParent() instanceof MReportUnit) {
            mrunit = (MReportUnit)mres.getParent();
        }
        if (mrunit != null) {
            List elements = ModelUtils.getAllElements((JasperDesign)jasper);
            for (JRDesignElement ele : elements) {
                if (ele instanceof JRDesignImage) {
                    this.publishImage(mrunit, monitor, jasper, fileset, file, ele, this.version);
                    continue;
                }
                if (ele instanceof JRDesignSubreport) {
                    this.publishSubreport(mrunit, monitor, jasper, fileset, file, ele, this.version);
                    continue;
                }
                if (ele instanceof JRChart) continue;
                this.publishComponent(mrunit, monitor, jasper, fileset, file, ele, this.version);
            }
            this.publishDataAdapters(mrunit, monitor, jasper, fileset, file, this.version);
            this.publishBundles(mrunit, monitor, jasper, fileset, file, this.version);
            this.publishTemplates(mrunit, monitor, jasper, fileset, file, this.version);
            this.publishParts(mrunit, monitor, jasper, fileset, file, this.version);
        }
        this.extManager.publishJrxml(this.jrConfig, mres, monitor, jasper, fileset, file, this.version);
        this.setupDescription(mrunit != null ? mrunit.getValue() : null, mres.getValue(), jasper);
    }

    protected void publishParts(MReportUnit mrunit, IProgressMonitor monitor, JasperDesign jasper, Set<String> fileset, IFile file, String version) throws Exception {
        List elements = ModelUtils.getAllPartElements((JasperDesign)jasper);
        for (JRPart part : elements) {
            StandardSubreportPartComponent component;
            MJrxml fres;
            if (!(part.getComponent() instanceof StandardSubreportPartComponent) || (fres = (MJrxml)this.impJRXML.publish(jasper, component = (StandardSubreportPartComponent)part.getComponent(), mrunit, monitor, fileset, file)) == null) continue;
            this.publishSubreport(fres, monitor, fileset);
            this.setupDescription(mrunit != null ? mrunit.getValue() : null, fres.getValue(), jasper);
        }
    }

    protected void publishSubreport(MReportUnit mrunit, IProgressMonitor monitor, JasperDesign jasper, Set<String> fileset, IFile file, JRDesignElement ele, String version) throws Exception {
        MJrxml fres = (MJrxml)this.impSRP.publish(jasper, ele, mrunit, monitor, fileset, file);
        this.publishSubreport(fres, monitor, fileset);
        if (fres != null) {
            this.setupDescription(mrunit != null ? mrunit.getValue() : null, fres.getValue(), jasper);
        }
    }

    private void setupDescription(ResourceDescriptor runit, ResourceDescriptor rd, JasperDesign jd) {
        String d = jd.getProperty("com.jaspersoft.studio.report.description");
        if (Misc.isNullOrEmpty((String)rd.getDescription()) && !Misc.isNullOrEmpty((String)d)) {
            rd.setDescription(d);
        }
        if (runit != null && Misc.isNullOrEmpty((String)runit.getDescription())) {
            if (!Misc.isNullOrEmpty((String)d)) {
                runit.setDescription(d);
            }
            if (!Misc.isNullOrEmpty((String)(d = jd.getProperty("com.jaspersoft.studio.report.unit.description")))) {
                runit.setDescription(d);
            }
        }
    }

    protected void publishSubreport(MJrxml fres, IProgressMonitor monitor, Set<String> fileset) throws Exception {
        if (fres == null) {
            return;
        }
        IFile fs = FileUtils.getInProjectFile((URI)fres.getFile().toURI(), (IProgressMonitor)monitor);
        if (fs != null) {
            JasperDesign jrd = this.readJR(fs);
            fres.setJd(jrd);
            if (jrd != null) {
                this.publishJrxml(fres, monitor, jrd, fileset, fs);
                File f = FileUtils.createTempFile((String)"jrsres", (String)".jrxml");
                FileUtils.writeFile((File)f, (String)JRXmlWriterHelper.writeReport((JasperReportsContext)this.jrConfig, (JRReport)jrd, (String)this.version));
                fres.setFile(f);
            }
            if (fs.isLinked()) {
                fs.delete(true, monitor);
            }
        } else if (fres.getFile().exists()) {
            JasperDesign jrd = this.readJR(fs);
            fres.setJd(jrd);
            if (jrd != null) {
                File f = FileUtils.createTempFile((String)"jrsres", (String)".jrxml");
                FileUtils.writeFile((File)f, (String)JRXmlWriterHelper.writeReport((JasperReportsContext)this.jrConfig, (JRReport)jrd, (String)this.version));
                fres.setFile(f);
            }
        }
    }

    protected JasperDesign readJR(File f) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = JRXMLUtils.getJRXMLInputStream((JasperReportsContext)this.jrConfig, (InputStream)f.toURI().toURL().openStream(), (String)FilenameUtils.getExtension((String)f.getName()), (String)"UTF-8", (String)this.version);){
                InputSource is = new InputSource(new InputStreamReader(in, "UTF-8"));
                return new JRXmlLoader((JasperReportsContext)this.jrConfig, (Digester)JRXmlDigesterFactory.createDigester((JasperReportsContext)this.jrConfig)).loadXML(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected JasperDesign readJR(IFile f) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = JRXMLUtils.getJRXMLInputStream((JasperReportsContext)this.jrConfig, (InputStream)f.getContents(), (String)f.getFileExtension(), (String)f.getCharset(true), (String)this.version);){
                InputSource is = new InputSource(new InputStreamReader(in, "UTF-8"));
                return new JRXmlLoader((JasperReportsContext)this.jrConfig, (Digester)JRXmlDigesterFactory.createDigester((JasperReportsContext)this.jrConfig)).loadXML(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void publishComponent(AMJrxmlContainer mrunit, IProgressMonitor monitor, JasperDesign jasper, Set<String> fileset, IFile file, JRDesignElement ele, String version) throws Exception {
        this.extManager.publishComponent(this.jrConfig, mrunit, monitor, jasper, fileset, file, ele, version);
    }

    protected void publishImage(MReportUnit mrunit, IProgressMonitor monitor, JasperDesign jasper, Set<String> fileset, IFile file, JRDesignElement ele, String version) throws Exception {
        this.impImg.publish(jasper, ele, mrunit, monitor, fileset, file);
    }

    protected void publishChartCustmomizer(MReportUnit mrunit, IProgressMonitor monitor, JasperDesign jasper, Set<String> fileset, IFile file, JRChart chart, String version) throws Exception {
        String customizerClass = chart.getCustomizerClass();
        this.impChartCustomizer.publish(jasper, customizerClass, mrunit, monitor, fileset, file, version);
        for (String subCustomizerClass : this.impChartCustomizer.getSubCustmizersClass(chart)) {
            this.impChartCustomizer.publish(jasper, subCustomizerClass, mrunit, monitor, fileset, file, version);
        }
    }

    protected void publishTemplates(MReportUnit mrunit, IProgressMonitor monitor, JasperDesign jasper, Set<String> fileset, IFile file, String version) throws Exception {
        for (JRReportTemplate rt : jasper.getTemplatesList()) {
            this.impStyle.publish(jasper, rt, mrunit, monitor, fileset, file);
        }
    }

    protected void publishDataAdapters(MReportUnit mrunit, IProgressMonitor monitor, JasperDesign jasper, Set<String> fileset, IFile file, String version) throws Exception {
        ArrayList<JRDataset> ds = new ArrayList<JRDataset>();
        ds.add(jasper.getMainDataset());
        List datasetsList = jasper.getDatasetsList();
        if (datasetsList != null && !datasetsList.isEmpty()) {
            ds.addAll(datasetsList);
        }
        boolean syncDA = mrunit.getWsClient().getServerProfile().isSyncDA();
        for (JRDataset d : ds) {
            String name;
            JRPropertiesMap pmap = d.getPropertiesMap();
            String dapath = pmap.getProperty("net.sf.jasperreports.data.adapter");
            if (syncDA && Misc.isNullOrEmpty((String)dapath) && !Misc.isNullOrEmpty((String)(name = pmap.getProperty("com.jaspersoft.studio.data.defaultdataadapter")))) {
                JRDefaultDataAdapterStorage storage = DataAdapterManager.getJRDefaultStorage((JasperReportsConfiguration)this.jrConfig);
                for (DataAdapterDescriptor dad : storage.getDataAdapterDescriptors()) {
                    if (!dad.getDataAdapter().getName().equals(name)) continue;
                    dapath = storage.getUrl(dad);
                    break;
                }
            }
            if (Misc.isNullOrEmpty((String)dapath)) continue;
            this.impDa.publish((JRDesignDataset)d, dapath, mrunit, monitor, fileset, file);
        }
    }

    protected void publishBundles(MReportUnit mrunit, IProgressMonitor monitor, JasperDesign jasper, Set<String> fileset, IFile file, String version) throws Exception {
        ArrayList<JRDataset> ds = new ArrayList<JRDataset>();
        ds.add(jasper.getMainDataset());
        List datasetsList = jasper.getDatasetsList();
        if (datasetsList != null && !datasetsList.isEmpty()) {
            ds.addAll(datasetsList);
        }
        for (JRDataset d : ds) {
            String dapath = d.getResourceBundle();
            if (Misc.isNullOrEmpty((String)dapath)) continue;
            this.impBundle.publish(this.jrConfig, jasper, dapath, mrunit, monitor, fileset, file);
            JSSFileRepositoryService repService = this.jrConfig.getFileRepositoryService();
            ArrayList<String> roots = new ArrayList<String>();
            List rservices = repService.getRepositoryServices();
            for (RepositoryService rs : rservices) {
                if (!(rs instanceof FileRepositoryService)) continue;
                FileRepositoryService frs = (FileRepositoryService)rs;
                roots.add(frs.getRoot());
            }
            ArrayList<File> files = new ArrayList<File>();
            HashSet<String> fileNames = new HashSet<String>();
            for (String r : roots) {
                this.look4Files(r, dapath, fileNames, files);
            }
            dapath = FilenameUtils.getPath((String)dapath);
            for (File f : files) {
                String p = String.valueOf(dapath) + FilenameUtils.getBaseName((String)f.getName());
                this.impBundle.publish(this.jrConfig, jasper, p, mrunit, monitor, fileset, file);
                if (!monitor.isCanceled()) continue;
                return;
            }
            if (!monitor.isCanceled()) continue;
            return;
        }
    }

    private void look4Files(String root, String dapath, Set<String> fileNames, List<File> files) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Stream<Path> st = Files.walk(Paths.get(root, new String[0]), new FileVisitOption[0]);){
                String pattern = "(.*)" + Pattern.quote(FilenameUtils.separatorsToSystem((String)dapath)) + "_(.*).properties";
                st.filter(path -> Files.isRegularFile(path, new LinkOption[0])).forEach(f -> {
                    File file = f.toFile();
                    String fn = file.getAbsolutePath();
                    if (!fileNames.contains(fn) && fn.matches(pattern)) {
                        fileNames.add(fn);
                        files.add(file);
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void init(JasperReportsConfiguration jrConfig, String version) {
        this.version = version;
        this.init(jrConfig);
    }

    @Override
    public void init(JasperReportsConfiguration jrConfig) {
        this.jrConfig = jrConfig;
        this.extManager = Activator.getExtManager();
        this.impDa = new ImpDataAdapter(jrConfig);
        this.impBundle = new ImpResourceBundle(jrConfig);
        this.impStyle = new ImpStyleTemplate(jrConfig);
        this.impImg = new ImpImage(jrConfig);
        this.impSRP = new ImpSubreport(jrConfig);
        this.impIC = new ImpInputControls(jrConfig);
        this.impJRXML = new ImpJRXML(jrConfig);
        this.impChartCustomizer = new ImpChartCustomizer(jrConfig);
    }
}

