/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.publish.imp;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.storage.FileDataAdapterStorage;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.server.model.AFileResource;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MContentResource;
import com.jaspersoft.studio.server.model.MRDataAdapter;
import com.jaspersoft.studio.server.model.MRJson;
import com.jaspersoft.studio.server.model.MRSecureFile;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.model.MXmlFile;
import com.jaspersoft.studio.server.protocol.Version;
import com.jaspersoft.studio.server.publish.OverwriteEnum;
import com.jaspersoft.studio.server.publish.PublishOptions;
import com.jaspersoft.studio.server.publish.PublishUtil;
import com.jaspersoft.studio.server.publish.imp.AImpObject;
import com.jaspersoft.studio.server.publish.imp.da.AImpJdbcDataAdapter;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.FileDataAdapter;
import net.sf.jasperreports.data.RepositoryDataLocation;
import net.sf.jasperreports.data.StandardRepositoryDataLocation;
import net.sf.jasperreports.data.jdbc.JdbcDataAdapter;
import net.sf.jasperreports.data.json.JsonDataAdapter;
import net.sf.jasperreports.data.xml.XmlDataAdapter;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.ui.validator.IDStringValidator;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;

public class ImpDataAdapter
extends AImpObject {
    private static Set<AImpJdbcDataAdapter> jdbcFiles = new HashSet<AImpJdbcDataAdapter>(0);
    private Map<String, PublishOptions> files = new HashMap<String, PublishOptions>();

    public ImpDataAdapter(JasperReportsConfiguration jrConfig) {
        super(jrConfig);
    }

    public File publish(JRDesignDataset jd, String dpath, MReportUnit mrunit, IProgressMonitor monitor, Set<String> fileset, IFile file) throws Exception {
        if (fileset.contains(dpath = this.preparePath(fileset, dpath))) {
            PublishOptions popt = this.files.get(dpath);
            ((List)((DAValueSetter)popt.getValueSetter()).getObject()).add(jd);
            return null;
        }
        if (dpath == null) {
            return null;
        }
        File f = this.findFile(file, dpath);
        if (f != null && f.exists()) {
            fileset.add(dpath);
            PublishOptions popt = ImpDataAdapter.createOptions(this.jrConfig, dpath);
            this.files.put(dpath, popt);
            popt.setFilePath(dpath);
            AFileResource fr = this.addResource(monitor, mrunit, fileset, f, popt);
            DAValueSetter vs = popt.getOverwrite().equals((Object)OverwriteEnum.REMOVE) ? new DAValueSetter(popt, true) : new DAValueSetter(popt);
            ((List)vs.getObject()).add(jd);
            popt.setValueSetter(vs);
            if (fr == null) {
                return null;
            }
            vs.setValue("repo:" + fr.getValue().getUriString());
        }
        return f;
    }

    @Override
    protected ResourceDescriptor createResource(MReportUnit mrunit) {
        return MRDataAdapter.createDescriptor((ANode)mrunit);
    }

    @Override
    public AFileResource publish(JasperDesign jd, JRDesignElement img, MReportUnit mrunit, IProgressMonitor monitor, Set<String> fileset, IFile file) throws Exception {
        return null;
    }

    @Override
    protected JRDesignExpression getExpression(JRDesignElement img) {
        return null;
    }

    @Override
    protected AFileResource addResource(IProgressMonitor monitor, MReportUnit mrunit, Set<String> fileset, File f, PublishOptions popt) {
        MRDataAdapter mres;
        block10: {
            ResourceDescriptor runit = mrunit.getValue();
            String rname = f.getName();
            if (popt.getFilePath() != null) {
                rname = FilenameUtils.getBaseName((String)popt.getFilePath());
            }
            ResourceDescriptor rd = this.createResource(mrunit);
            rd.setName(IDStringValidator.safeChar((String)rname));
            rd.setLabel(rname);
            rd.setParentFolder(runit.getParentFolder());
            rd.setUriString(String.valueOf(runit.getParentFolder()) + "/" + rd.getName());
            mres = new MRDataAdapter((ANode)mrunit, rd, -1);
            mres.setFile(f);
            String b = this.jrConfig.getProperty("com.jaspersoft.studio.server.PUBLISH_REPORT_OVERRIDEBYDEFAULT", "true");
            if (b.equals("true") && rd.getIsNew()) {
                popt.setOverwrite(OverwriteEnum.OVERWRITE);
            }
            mres.setPublishOptions(popt);
            PublishUtil.loadPreferences(monitor, (IFile)this.jrConfig.get("ifile"), mres);
            List<AMResource> resourses = PublishUtil.getResources(mrunit, monitor, this.jrConfig);
            resourses.add(mres);
            FileInputStream is = null;
            try {
                try {
                    is = new FileInputStream(f);
                    final DataAdapterDescriptor dad = FileDataAdapterStorage.readDataADapter((InputStream)is, (IFile)((IFile)this.jrConfig.get("ifile")), (JasperReportsConfiguration)this.jrConfig);
                    if (dad != null) {
                        Map<String, String> rs;
                        final DataAdapter da = dad.getDataAdapter();
                        if (da.getClass().getName().equals("com.jaspersoft.jasperreports.data.jrs.JrsDataAdapterImpl")) {
                            popt.setOverwrite(OverwriteEnum.REMOVE);
                        }
                        if ((rs = this.getFileName(da)) != null) {
                            rs.forEach((key, fname) -> {
                                block16: {
                                    FileOutputStream fos;
                                    InputStream fis;
                                    block14: {
                                        fis = null;
                                        fos = null;
                                        try {
                                            try {
                                                fis = RepositoryUtil.getInstance((JasperReportsContext)this.jrConfig).getInputStreamFromLocation(fname);
                                                File file = FileUtils.createTempFile((String)"tmp", (String)"");
                                                fos = new FileOutputStream(file);
                                                if (fis == null) break block14;
                                                IOUtils.copy((InputStream)fis, (OutputStream)fos);
                                                fname = fname.replace("\\", "/");
                                                int indx = fname.lastIndexOf(47);
                                                if (indx >= 0 && indx + 1 < fname.length()) {
                                                    fname = fname.substring(indx + 1);
                                                }
                                                ResourceDescriptor rd1 = this.getResource(da, mrunit);
                                                rd1.setName(IDStringValidator.safeChar((String)fname));
                                                rd1.setLabel((String)fname);
                                                rd1.setParentFolder(runit.getParentFolder());
                                                rd1.setUriString(String.valueOf(runit.getParentFolder()) + "/" + rd1.getName());
                                                AFileResource mdaf = null;
                                                if (da instanceof XmlDataAdapter) {
                                                    mdaf = new MXmlFile((ANode)mrunit, rd1, -1);
                                                } else if (da instanceof JsonDataAdapter) {
                                                    mdaf = new MRJson((ANode)mrunit, rd1, -1);
                                                } else if (da instanceof JdbcDataAdapter) {
                                                    for (AImpJdbcDataAdapter d : jdbcFiles) {
                                                        if (!d.isHandling((JdbcDataAdapter)da)) continue;
                                                        rd1.setWsType(d.getResourceType((String)key));
                                                        mdaf = rd1.getWsType().equals("secure") ? new MRSecureFile((ANode)mrunit, rd1, -1) : new MContentResource((ANode)mrunit, rd1, -1);
                                                        break;
                                                    }
                                                } else {
                                                    mdaf = new MContentResource((ANode)mrunit, rd1, -1);
                                                }
                                                if (mdaf != null) {
                                                    mdaf.setFile(file);
                                                    PublishOptions fpopt = ImpDataAdapter.createOptions(this.jrConfig, fname);
                                                    if (b.equals("true") && rd1.getIsNew()) {
                                                        fpopt.setOverwrite(OverwriteEnum.OVERWRITE);
                                                    }
                                                    mdaf.setPublishOptions(fpopt);
                                                    PublishOptions publishOptions2 = popt;
                                                    publishOptions2.getClass();
                                                    fpopt.setValueSetter(new PublishOptions.ValueSetter<DataAdapter>(publishOptions2, da){

                                                        @Override
                                                        public void setup() {
                                                            ImpDataAdapter.this.setFileName(da, this.value);
                                                            try {
                                                                File f = FileUtils.createTempFile((String)"tmp", (String)"");
                                                                org.apache.commons.io.FileUtils.writeStringToFile((File)f, (String)DataAdapterManager.toDataAdapterFile((DataAdapterDescriptor)dad, (JasperReportsContext)ImpDataAdapter.this.jrConfig), (Charset)StandardCharsets.UTF_8);
                                                                mres.setFile(f);
                                                            }
                                                            catch (IOException e) {
                                                                UIUtils.showError((Throwable)e);
                                                            }
                                                        }
                                                    });
                                                    fpopt.getValueSetter().setValue("repo:" + rd1.getUriString());
                                                    PublishUtil.loadPreferences(monitor, (IFile)this.jrConfig.get("ifile"), mdaf);
                                                    resourses.add(mdaf);
                                                }
                                                File ftmp = FileUtils.createTempFile((String)"tmp", (String)"");
                                                org.apache.commons.io.FileUtils.writeStringToFile((File)ftmp, (String)DataAdapterManager.toDataAdapterFile((DataAdapterDescriptor)dad, (JasperReportsContext)this.jrConfig), (Charset)StandardCharsets.UTF_8);
                                                mres.setFile(ftmp);
                                            }
                                            catch (IOException | JRException e) {
                                                e.printStackTrace();
                                                FileUtils.closeStream((Closeable)fis);
                                                FileUtils.closeStream(fos);
                                                break block16;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            FileUtils.closeStream(fis);
                                            FileUtils.closeStream(fos);
                                            throw throwable;
                                        }
                                    }
                                    FileUtils.closeStream((Closeable)fis);
                                    FileUtils.closeStream((Closeable)fos);
                                }
                            });
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    FileUtils.closeStream((Closeable)is);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(is);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)is);
        }
        return mres;
    }

    protected ResourceDescriptor getResource(DataAdapter da, MReportUnit parent) {
        if (Version.isGreaterThan(parent.getWsClient().getServerInfo(), "6") && da instanceof JsonDataAdapter) {
            return MRJson.createDescriptor((ANode)parent);
        }
        return MXmlFile.createDescriptor((ANode)parent);
    }

    protected void setFileName(DataAdapter da, String fname) {
        JdbcDataAdapter jdbcDA;
        if (da instanceof FileDataAdapter && ((FileDataAdapter)da).getDataFile() instanceof RepositoryDataLocation) {
            ((StandardRepositoryDataLocation)((FileDataAdapter)da).getDataFile()).setLocation(fname);
        }
        if (da instanceof JdbcDataAdapter && (jdbcDA = (JdbcDataAdapter)da).getDriver() != null) {
            for (AImpJdbcDataAdapter d : jdbcFiles) {
                if (d.setFileName(jdbcDA, d.getKeys()[0][0], fname)) break;
            }
        }
    }

    protected Map<String, String> getFileName(DataAdapter da) {
        JdbcDataAdapter jdbcDA;
        if (da instanceof JdbcDataAdapter && (jdbcDA = (JdbcDataAdapter)da).getDriver() != null) {
            for (AImpJdbcDataAdapter d : jdbcFiles) {
                Map<String, String> res = d.getFileName(jdbcDA);
                if (Misc.isNullOrEmpty(res)) continue;
                return res;
            }
        }
        if (da instanceof FileDataAdapter && ((FileDataAdapter)da).getDataFile() instanceof RepositoryDataLocation) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("property", ((RepositoryDataLocation)((FileDataAdapter)da).getDataFile()).getLocation());
            return res;
        }
        return null;
    }

    private class DAValueSetter
    extends PublishOptions.ValueSetter<List<JRDesignDataset>> {
        private boolean removeDA;

        public DAValueSetter(PublishOptions publishOptions) {
            this(publishOptions, false);
        }

        public DAValueSetter(PublishOptions publishOptions, boolean removeDA) {
            PublishOptions publishOptions2 = publishOptions;
            publishOptions2.getClass();
            super(publishOptions2, new ArrayList());
            this.removeDA = false;
            this.removeDA = removeDA;
        }

        @Override
        public void setup() {
            for (JRDesignDataset ds : (List)this.object) {
                if (this.removeDA) {
                    ds.getPropertiesMap().removeProperty("net.sf.jasperreports.data.adapter");
                    continue;
                }
                ds.setProperty("net.sf.jasperreports.data.adapter", this.getValue());
            }
        }
    }
}

