/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.publish.imp;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.server.ResourceFactory;
import com.jaspersoft.studio.server.model.AFileResource;
import com.jaspersoft.studio.server.model.MJrxml;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.publish.PublishOptions;
import com.jaspersoft.studio.server.publish.PublishUtil;
import com.jaspersoft.studio.server.publish.imp.AImpObject;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.eclipse.ui.validator.IDStringValidator;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.StringUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import net.sf.jasperreports.parts.subreport.StandardSubreportPartComponent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;

public class ImpJRXML {
    private JasperReportsConfiguration jrConfig;

    public ImpJRXML(JasperReportsConfiguration jrConfig) {
        this.jrConfig = jrConfig;
    }

    protected File findFile(IFile file, String str) {
        File f = FileUtils.findFile((IFile)file, (String)StringUtils.replaceAllIns((String)str, (String)".jasper$", (String)".jrxml"));
        if (f == null && (f = FileUtils.findFile((IFile)file, (String)str)) != null) {
            try {
                Object obj = JRLoader.loadObject((JasperReportsContext)this.jrConfig, (File)f);
                if (obj != null && obj instanceof JasperReport) {
                    JasperReport jrReport = (JasperReport)obj;
                    FileOutputStream fos = null;
                    try {
                        f = FileUtils.getTmpFile((String)str);
                        fos = new FileOutputStream(f);
                        JRXmlWriter.writeReport((JRReport)jrReport, (OutputStream)fos, (String)"UTF-8");
                        return f;
                    }
                    catch (IOException e) {
                        FileUtils.closeStream(fos);
                        e.printStackTrace();
                    }
                }
            }
            catch (JRException e) {
                e.printStackTrace();
            }
        }
        return f;
    }

    public AFileResource publish(JasperDesign jd, StandardSubreportPartComponent img, MReportUnit mrunit, IProgressMonitor monitor, Set<String> fileset, IFile file) throws Exception {
        return this.findFile(mrunit, monitor, jd, fileset, this.getExpression(img), file);
    }

    protected AFileResource findFile(MReportUnit mrunit, IProgressMonitor monitor, JasperDesign jd, Set<String> fileset, JRDesignExpression exp, IFile file) {
        String str = ExpressionUtil.cachedExpressionEvaluationString((JRExpression)exp, (JasperReportsConfiguration)this.jrConfig);
        if (str.startsWith("repo:")) {
            str = str.replaceFirst("repo:", "");
        }
        if (str == null || fileset.contains(str)) {
            AImpObject.setupSameExpression(mrunit, exp, str);
            return null;
        }
        File f = this.findFile(file, str);
        if (f != null && f.exists()) {
            PublishOptions popt = AImpObject.createOptions(this.jrConfig, str);
            popt.setjExpression(exp);
            if (!f.getName().contains(":")) {
                popt.setExpression("\"repo:" + IDStringValidator.safeChar((String)f.getName()) + "\"");
            }
            fileset.add(str);
            AFileResource res = this.addResource(monitor, mrunit, fileset, f, popt);
            String desc = jd.getProperty("com.jaspersoft.studio.report.description");
            if (!Misc.isNullOrEmpty((String)desc)) {
                res.getValue().setDescription(desc);
            }
            return res;
        }
        return null;
    }

    protected AFileResource addResource(IProgressMonitor monitor, MReportUnit mrunit, Set<String> fileset, File f, PublishOptions popt) {
        ResourceDescriptor runit = mrunit.getValue();
        String rname = f.getName();
        if (rname.startsWith("repo:")) {
            rname = rname.replaceFirst("repo:", "");
        }
        ResourceDescriptor rd = null;
        List<ResourceDescriptor> list = runit.getChildren();
        String idname = IDStringValidator.safeChar((String)rname);
        for (ResourceDescriptor r : list) {
            if (r.getName() == null || !r.getName().equals(idname)) continue;
            rd = r;
            break;
        }
        if (rd == null) {
            rd = this.createResource(mrunit);
            rd.setName(idname);
            rd.setLabel(rname);
            rd.setParentFolder(String.valueOf(runit.getUriString()) + "_files");
            rd.setUriString(String.valueOf(rd.getParentFolder()) + "/" + rd.getName());
        }
        AFileResource mres = (AFileResource)ResourceFactory.getResource((ANode)mrunit, rd, -1);
        mres.setFile(f);
        mres.setPublishOptions(popt);
        PublishUtil.getResources(mrunit, monitor, this.jrConfig).add(mres);
        return mres;
    }

    protected ResourceDescriptor createResource(MReportUnit mrunit) {
        return MJrxml.createDescriptor((ANode)mrunit);
    }

    protected JRDesignExpression getExpression(StandardSubreportPartComponent img) {
        return (JRDesignExpression)img.getExpression();
    }
}

