/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.publish.wizard.page;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.property.descriptor.expression.JRExpressionCellEditor;
import com.jaspersoft.studio.server.Activator;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AFileResource;
import com.jaspersoft.studio.server.model.AMJrxmlContainer;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MInputControl;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.publish.OverwriteEnum;
import com.jaspersoft.studio.server.publish.PublishOptions;
import com.jaspersoft.studio.server.publish.PublishUtil;
import com.jaspersoft.studio.server.publish.ResourcePublishMethod;
import com.jaspersoft.studio.server.publish.action.ReferenceResourceAction;
import com.jaspersoft.studio.server.publish.action.ResourceExpressionAction;
import com.jaspersoft.studio.server.publish.action.ResourceToFolderAction;
import com.jaspersoft.studio.server.publish.action.SelectLocalAction;
import com.jaspersoft.studio.server.publish.action.SetSelectedResourcesAction;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.ResourceManager;

public class ResourcesPage
extends JSSHelpWizardPage {
    private JasperReportsConfiguration jConfig;
    private TableViewer tableViewer;
    private AMJrxmlContainer pres;
    private SetSelectedResourcesAction setOverwriteResource;
    private SetSelectedResourcesAction setIgnoreResource;
    private SetSelectedResourcesAction setExprResource;
    private ReferenceResourceAction sresource;
    private ResourceToFolderAction sres;
    private SelectLocalAction slocal;
    private ComboBoxCellEditor cOverwrite;

    public ResourcesPage(JasperReportsConfiguration jConfig) {
        super("serverrespublish");
        this.setTitle(Messages.ResourcesPage_title);
        this.setDescription(Messages.ResourcesPage_description);
        this.jConfig = jConfig;
    }

    public void setParentResource(AMJrxmlContainer pres) {
        this.pres = pres;
    }

    protected String getContextName() {
        return "com.jaspersoft.studio.doc.select_server_resources";
    }

    public boolean isEmpty() {
        return this.tableViewer.getTable().getItemCount() > 0;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        this.tableViewer = new TableViewer(composite, 68354);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] items = super.getElements(inputElement);
                ArrayList<AMResource> res = new ArrayList<AMResource>();
                Object[] objectArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    AMResource mres;
                    Object it = objectArray[n2];
                    if (it instanceof AMResource && !(mres = (AMResource)((Object)it)).getPublishOptions().getOverwrite().equals((Object)OverwriteEnum.REMOVE)) {
                        res.add(mres);
                    }
                    ++n2;
                }
                return res.toArray();
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        Table table = (Table)this.tableViewer.getControl();
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(Messages.ResourcesPage_table_resource);
        column.setWidth(300);
        viewerColumn.setLabelProvider((CellLabelProvider)new TLabelProvider(this){

            public String getText(Object element) {
                AMResource fr = (AMResource)((Object)element);
                return fr.getDisplayText();
            }

            public Image getImage(Object element) {
                this.setErrorMessage(null);
                this.setPageComplete(true);
                AMResource fr = (AMResource)((Object)element);
                ImageDescriptor id = fr.getThisIconDescriptor().getIcon16();
                PublishOptions popt = fr.getPublishOptions();
                if (popt.getPublishMethod() != ResourcePublishMethod.LOCAL && popt.getReferencedResource() == null) {
                    FieldDecoration fd = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
                    this.setErrorMessage(Messages.ResourcesPage_0);
                    this.setPageComplete(false);
                    return ResourceManager.decorateImage((Image)id.createImage(), (Image)fd.getImage(), (int)3);
                }
                if (popt.getPublishMethod() == ResourcePublishMethod.REFERENCE) {
                    return Activator.getDefault().getImage(ResourceManager.decorateImage((ImageDescriptor)id, (ImageDescriptor)AMResource.LINK_DECORATOR, (int)3));
                }
                return Activator.getDefault().getImage(id);
            }
        });
        viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        column = viewerColumn.getColumn();
        column.setText(Messages.ResourcesPage_table_overwrite);
        column.setWidth(200);
        viewerColumn.setLabelProvider((CellLabelProvider)new TLabelProvider(this){

            public String getText(Object element) {
                AMResource fr = (AMResource)((Object)element);
                OverwriteEnum ovw = fr.getPublishOptions().getOverwrite(OverwriteEnum.IGNORE);
                if (ovw.equals((Object)OverwriteEnum.OVERWRITE)) {
                    return Messages.ResourcesPage_3;
                }
                if (ovw.equals((Object)OverwriteEnum.IGNORE)) {
                    return Messages.ResourcesPage_5;
                }
                if (ovw.equals((Object)OverwriteEnum.ONLY_EXPRESSION)) {
                    return Messages.ResourcesPage_6;
                }
                return ovw.getValue();
            }
        });
        viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        column = viewerColumn.getColumn();
        column.setText(Messages.ResourcesPage_1);
        column.setWidth(100);
        viewerColumn.setLabelProvider((CellLabelProvider)new TLabelProvider(this){

            public String getText(Object element) {
                AMResource fr = (AMResource)((Object)element);
                PublishOptions popt = fr.getPublishOptions();
                OverwriteEnum ovw = popt.getOverwrite(OverwriteEnum.IGNORE);
                if (ovw.equals((Object)OverwriteEnum.IGNORE)) {
                    return "";
                }
                if (popt.getPublishMethod() == ResourcePublishMethod.REWRITEEXPRESSION) {
                    return popt.getRepoExpression();
                }
                return Misc.nvl((String)popt.getExpression());
            }

            @Override
            public String getToolTipText(Object element) {
                String txt = this.getText(element);
                if (Misc.isNullOrEmpty((String)txt)) {
                    txt = super.getToolTipText(element);
                }
                return txt;
            }
        });
        viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        column = viewerColumn.getColumn();
        column.setText(Messages.ResourcesPage_2);
        column.setWidth(100);
        viewerColumn.setLabelProvider((CellLabelProvider)new TLabelProvider(this){

            public String getText(Object element) {
                if (element instanceof AFileResource) {
                    return ((AFileResource)((Object)element)).getHFFileSize();
                }
                return "";
            }
        });
        viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        column = viewerColumn.getColumn();
        column.setText(Messages.ResourcesPage_4);
        column.setWidth(100);
        viewerColumn.setLabelProvider((CellLabelProvider)new TLabelProvider(this){

            public String getText(Object element) {
                if (element instanceof AMResource) {
                    AMResource mres = (AMResource)((Object)element);
                    PublishOptions popt = mres.getPublishOptions();
                    OverwriteEnum ovw = popt.getOverwrite(OverwriteEnum.IGNORE);
                    if (ovw.equals((Object)OverwriteEnum.IGNORE)) {
                        return "";
                    }
                    if (ovw.equals((Object)OverwriteEnum.ONLY_EXPRESSION)) {
                        return "";
                    }
                    if (popt.getPublishMethod() == ResourcePublishMethod.RESOURCE) {
                        return sres.getText();
                    }
                    if (popt.getPublishMethod() == ResourcePublishMethod.REFERENCE) {
                        return sresource.getText();
                    }
                    if (popt.getPublishMethod() == ResourcePublishMethod.LOCAL) {
                        return slocal.getText();
                    }
                }
                return "";
            }
        });
        this.sresource = new ReferenceResourceAction(this.tableViewer);
        this.sres = new ResourceToFolderAction(this.tableViewer);
        this.slocal = new SelectLocalAction(this.tableViewer);
        this.setOverwriteResource = new SetSelectedResourcesAction(this.tableViewer, OverwriteEnum.OVERWRITE);
        this.setIgnoreResource = new SetSelectedResourcesAction(this.tableViewer, OverwriteEnum.IGNORE);
        this.setExprResource = new SetSelectedResourcesAction(this.tableViewer, OverwriteEnum.ONLY_EXPRESSION);
        this.attachCellEditors(this.tableViewer, (Composite)table);
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){
            private ResourceExpressionAction rexp;
            {
                this.rexp = new ResourceExpressionAction(ResourcesPage.this.tableViewer);
            }

            public void menuAboutToShow(IMenuManager menu) {
                StructuredSelection s = (StructuredSelection)ResourcesPage.this.tableViewer.getSelection();
                if (s != null) {
                    AMResource mres;
                    MenuManager subMenu = new MenuManager(Messages.ResourcesPage_10);
                    subMenu.add((IAction)ResourcesPage.this.setOverwriteResource);
                    subMenu.add((IAction)ResourcesPage.this.setIgnoreResource);
                    subMenu.add((IAction)ResourcesPage.this.setExprResource);
                    menu.add((IContributionItem)subMenu);
                    if (s.size() == 1 && (mres = (AMResource)((Object)s.getFirstElement())) != null && mres.getPublishOptions().getOverwrite(OverwriteEnum.OVERWRITE).equals((Object)OverwriteEnum.OVERWRITE)) {
                        if (ResourcesPage.this.sresource.calculateEnabled(mres)) {
                            menu.add((IAction)ResourcesPage.this.sresource);
                        }
                        if (ResourcesPage.this.sres.calculateEnabled(mres)) {
                            menu.add((IAction)ResourcesPage.this.sres);
                        }
                        if (ResourcesPage.this.slocal.calculateEnabled(mres)) {
                            menu.add((IAction)ResourcesPage.this.slocal);
                        }
                        if (this.rexp.calculateEnabled(mres)) {
                            menu.add((IAction)this.rexp);
                        }
                    }
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(menu);
    }

    private void attachCellEditors(TableViewer viewer, Composite parent) {
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                AMResource prop = (AMResource)((Object)element);
                PublishOptions po = prop.getPublishOptions();
                if (property.equals("VALUE")) {
                    return true;
                }
                if (property.equals("EXPRESSION") && po.getjExpression() != null && !po.getOverwrite().equals((Object)OverwriteEnum.IGNORE)) {
                    return true;
                }
                return property.equals("TYPE") && po.getOverwrite().equals((Object)OverwriteEnum.OVERWRITE);
            }

            public Object getValue(Object element, String property) {
                AMResource prop = (AMResource)((Object)element);
                PublishOptions po = prop.getPublishOptions();
                if ("VALUE".equals(property)) {
                    if (prop instanceof AFileResource) {
                        ResourcesPage.this.cOverwrite.setItems(new String[]{Messages.ResourcesPage_3, Messages.ResourcesPage_5, Messages.ResourcesPage_6});
                    } else {
                        ResourcesPage.this.cOverwrite.setItems(new String[]{Messages.ResourcesPage_3, Messages.ResourcesPage_5});
                    }
                    OverwriteEnum ovw = po.getOverwrite();
                    if (ovw.equals((Object)OverwriteEnum.OVERWRITE)) {
                        return 0;
                    }
                    if (ovw.equals((Object)OverwriteEnum.IGNORE)) {
                        return 1;
                    }
                    if (ovw.equals((Object)OverwriteEnum.ONLY_EXPRESSION)) {
                        return 2;
                    }
                    return 1;
                }
                if ("NAME".equals(property)) {
                    return prop.getDisplayText();
                }
                if ("FILESIZE".equals(property) && prop instanceof AFileResource) {
                    return ((AFileResource)((Object)element)).getHFFileSize();
                }
                if (po.getOverwrite(OverwriteEnum.IGNORE).equals((Object)OverwriteEnum.IGNORE)) {
                    return "";
                }
                if ("EXPRESSION".equals(property)) {
                    JRDesignExpression jd = new JRDesignExpression();
                    jd.setText(prop.getPublishOptions().getExpression());
                    return jd;
                }
                if ("TYPE".equals(property)) {
                    if (prop instanceof AFileResource) {
                        AFileResource mres = (AFileResource)((Object)element);
                        if (mres.getPublishOptions().getPublishMethod() == ResourcePublishMethod.RESOURCE) {
                            return 0;
                        }
                        if (mres.getPublishOptions().getPublishMethod() == ResourcePublishMethod.REFERENCE) {
                            return 1;
                        }
                        if (mres.getPublishOptions().getPublishMethod() == ResourcePublishMethod.LOCAL) {
                            return 2;
                        }
                    }
                    return 2;
                }
                return "";
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                AMResource data = (AMResource)((Object)tableItem.getData());
                PublishOptions po = data.getPublishOptions();
                if ("VALUE".equals(property)) {
                    int intValue = (Integer)value;
                    switch (intValue) {
                        case 0: {
                            po.setOverwrite(OverwriteEnum.OVERWRITE);
                            break;
                        }
                        case 1: {
                            po.setOverwrite(OverwriteEnum.IGNORE);
                            break;
                        }
                        case 2: {
                            po.setOverwrite(OverwriteEnum.ONLY_EXPRESSION);
                        }
                    }
                } else if ("EXPRESSION".equals(property)) {
                    po.setExpression(value == null ? null : ((JRDesignExpression)value).getText());
                } else if ("TYPE".equals(property) && value instanceof Integer) {
                    int intValue = (Integer)value;
                    switch (intValue) {
                        case 0: {
                            ResourcesPage.this.sres.calculateEnabled(data);
                            ResourcesPage.this.sres.run();
                            break;
                        }
                        case 1: {
                            ResourcesPage.this.sresource.calculateEnabled(data);
                            ResourcesPage.this.sresource.run();
                            break;
                        }
                        case 2: {
                            ResourcesPage.this.slocal.calculateEnabled(data);
                            ResourcesPage.this.slocal.run();
                        }
                    }
                }
                ResourcesPage.this.tableViewer.update(element, new String[]{property});
                ResourcesPage.this.tableViewer.refresh();
            }
        });
        JRExpressionCellEditor expEditor = new JRExpressionCellEditor(parent, new ExpressionContext(this.jConfig));
        this.cOverwrite = new ComboBoxCellEditor(parent, new String[]{Messages.ResourcesPage_3, Messages.ResourcesPage_5, Messages.ResourcesPage_6}, 8);
        viewer.setCellEditors(new CellEditor[]{new TextCellEditor(parent), this.cOverwrite, expEditor, new TextCellEditor(parent, 131072), new ComboBoxCellEditor(parent, new String[]{this.sres.getText(), this.sresource.getText(), this.slocal.getText()}, 8)});
        viewer.setColumnProperties(new String[]{"NAME", "VALUE", "EXPRESSION", "FILESIZE", "TYPE"});
    }

    public void fillData(boolean isNew) {
        List<AMResource> res = PublishUtil.getResources(this.pres, (IProgressMonitor)new NullProgressMonitor(), this.jConfig);
        String b = this.jConfig.getProperty("com.jaspersoft.studio.server.PUBLISH_REPORT_OVERRIDEBYDEFAULT", "true");
        if (isNew) {
            for (AMResource r : res) {
                if (r instanceof AFileResource) continue;
                if (b.equals("overwrite") || b.equals("true")) {
                    r.getPublishOptions().setOverwrite(OverwriteEnum.OVERWRITE);
                    continue;
                }
                r.getPublishOptions().setOverwrite(OverwriteEnum.IGNORE);
            }
        } else if (this.pres instanceof MReportUnit && !this.pres.getValue().getIsNew()) {
            block1: for (ResourceDescriptor n : this.pres.getValue().getChildren()) {
                if (n.getWsType() == null || !n.getWsType().equals("inputControl")) continue;
                String icname = n.getName();
                for (AMResource r : res) {
                    if (!(r instanceof MInputControl) || !r.getValue().getName().equals(icname) || r.getValue().getIsNew()) continue;
                    r.getPublishOptions().setOverwrite(OverwriteEnum.IGNORE);
                    continue block1;
                }
            }
            for (AMResource r : res) {
                if (b.equals("overwrite")) {
                    r.getPublishOptions().setOverwrite(OverwriteEnum.OVERWRITE);
                    continue;
                }
                if (b.equals("ignore")) {
                    r.getPublishOptions().setOverwrite(OverwriteEnum.IGNORE);
                    continue;
                }
                if (r.getValue().getIsNew()) continue;
                r.getPublishOptions().setOverwrite(OverwriteEnum.IGNORE);
            }
        }
        this.tableViewer.setInput(res);
        this.tableViewer.refresh();
    }

    abstract class TLabelProvider
    extends ColumnLabelProvider {
        TLabelProvider() {
        }

        public String getToolTipText(Object element) {
            String tt = "";
            AMResource mres = (AMResource)((Object)element);
            tt = String.valueOf(tt) + "ID: " + mres.getValue().getName();
            tt = String.valueOf(tt) + "\nLabel: " + mres.getValue().getLabel();
            if (mres.getPublishOptions().getPublishMethod() == ResourcePublishMethod.LOCAL) {
                tt = String.valueOf(tt) + "\nURI: " + mres.getValue().getUriString();
            } else if (mres.getPublishOptions().getPublishMethod() == ResourcePublishMethod.REFERENCE) {
                tt = String.valueOf(tt) + "\nURI: " + mres.getValue().getUriString();
                if (mres.getPublishOptions().getReferencedResource() != null) {
                    tt = String.valueOf(tt) + "\nReference To: " + mres.getPublishOptions().getReferencedResource().getUriString();
                }
            } else if (mres.getPublishOptions().getPublishMethod() == ResourcePublishMethod.RESOURCE) {
                if (mres.getPublishOptions().getReferencedResource() != null) {
                    tt = String.valueOf(tt) + "\nURI: " + mres.getPublishOptions().getReferencedResource().getUriString();
                }
            } else if (mres.getPublishOptions().getPublishMethod() == ResourcePublishMethod.REWRITEEXPRESSION && mres.getPublishOptions().getReferencedResource() != null) {
                tt = String.valueOf(tt) + "\nURI: " + mres.getPublishOptions().getReferencedResource().getUriString();
            }
            if (element instanceof AFileResource && ((AFileResource)((Object)element)).getFile() != null) {
                tt = String.valueOf(tt) + "\nFile: " + ((AFileResource)((Object)element)).getFile().getAbsolutePath();
            }
            return tt;
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 100;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 5000;
        }
    }
}

